/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class VersionService {
    private final String LATEST_VERSION = "v1_21_9";
    private final HashMap<String, String> VERSION_MAPPING = new HashMap();
    private final GSitMain gSitMain;
    private final String serverVersion;
    private String packagePath;
    private boolean available;

    public VersionService(GSitMain gSitMain) {
        this.VERSION_MAPPING.put("v1_18_1", "v1_18");
        this.VERSION_MAPPING.put("v1_19_2", "v1_19_1");
        this.VERSION_MAPPING.put("v1_20_1", "v1_20");
        this.VERSION_MAPPING.put("v1_20_4", "v1_20_3");
        this.VERSION_MAPPING.put("v1_20_6", "v1_20_5");
        this.VERSION_MAPPING.put("v1_21_1", "v1_21");
        this.VERSION_MAPPING.put("v1_21_3", "v1_21_2");
        this.VERSION_MAPPING.put("v1_21_7", "v1_21_6");
        this.VERSION_MAPPING.put("v1_21_8", "v1_21_6");
        this.VERSION_MAPPING.put("v1_21_10", "v1_21_9");
        this.gSitMain = gSitMain;
        String rawServerVersion = Bukkit.getServer().getBukkitVersion();
        this.serverVersion = rawServerVersion.substring(0, rawServerVersion.indexOf(45));
        if (!this.isNewerOrVersion(18, 0)) {
            return;
        }
        this.packagePath = ((Object)((Object)gSitMain)).getClass().getPackage().getName() + ".mcv." + this.getPackageVersion();
        this.available = this.hasPackageClass("entity.SeatEntity");
        if (this.available) {
            return;
        }
        this.packagePath = ((Object)((Object)gSitMain)).getClass().getPackage().getName() + ".mcv.v1_21_9";
        this.available = this.hasPackageClass("entity.SeatEntity");
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isNewerOrVersion(int version, int subVersion) {
        String[] serverVersionSplit = this.serverVersion.split("\\.");
        if (Integer.parseInt(serverVersionSplit[1]) > version) {
            return true;
        }
        return Integer.parseInt(serverVersionSplit[1]) == version && (serverVersionSplit.length > 2 ? Integer.parseInt(serverVersionSplit[2]) >= subVersion : subVersion == 0);
    }

    public Object getLegacyPackageObjectInstance(String className, Object ... parameters) {
        try {
            Class<?> mcvPackageClass = Class.forName(((Object)((Object)this.gSitMain)).getClass().getPackage().getName() + ".mcv.v1_17_1." + className);
            if (parameters.length == 0) {
                return mcvPackageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new);
            return mcvPackageClass.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not get legacy package object with class name '" + className + "'!", e);
            return null;
        }
    }

    public Object getPackageObjectInstance(String className, Object ... parameters) {
        try {
            Class<?> mcvPackageClass = Class.forName(this.packagePath + "." + className);
            if (parameters.length == 0) {
                return mcvPackageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class[] parameterTypes = (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new);
            return mcvPackageClass.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (Throwable e) {
            this.gSitMain.getLogger().log(Level.SEVERE, "Could not get package object with class name '" + className + "'!", e);
            return null;
        }
    }

    public boolean hasPackageClass(String className) {
        try {
            Class.forName(this.packagePath + "." + className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String getPackageVersion() {
        String packageVersion = "v" + this.serverVersion.replace(".", "_");
        return this.VERSION_MAPPING.getOrDefault(packageVersion, packageVersion);
    }
}

