/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.service;

import dev.geco.gsit.GSitMain;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class UpdateService {
    private final String REMOTE_URL = "https://api.spigotmc.org/legacy/update.php?resource=";
    private final GSitMain gSitMain;
    private LocalDate lastCheckDate = null;
    private String latestVersion = null;
    private boolean isLatestVersion = true;

    public UpdateService(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public void checkForUpdates() {
        if (!this.gSitMain.getConfigService().CHECK_FOR_UPDATE) {
            return;
        }
        this.checkVersion();
        if (this.isLatestVersion) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.gSitMain.getPermissionService().hasPermission((Permissible)player, "Update")) continue;
            this.gSitMain.getMessageService().sendMessage((CommandSender)player, "Plugin.plugin-update", "%Name%", "GSit", "%NewVersion%", this.latestVersion, "%Version%", this.gSitMain.getDescription().getVersion(), "%Path%", this.gSitMain.getDescription().getWebsite());
        }
        this.gSitMain.getMessageService().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-update", "%Name%", "GSit", "%NewVersion%", this.latestVersion, "%Version%", this.gSitMain.getDescription().getVersion(), "%Path%", this.gSitMain.getDescription().getWebsite());
    }

    public void checkForUpdates(Player player) {
        if (!this.gSitMain.getConfigService().CHECK_FOR_UPDATE) {
            return;
        }
        if (!this.gSitMain.getPermissionService().hasPermission((Permissible)player, "Update")) {
            return;
        }
        this.checkVersion();
        if (this.isLatestVersion) {
            return;
        }
        this.gSitMain.getMessageService().sendMessage((CommandSender)player, "Plugin.plugin-update", "%Name%", "GSit", "%NewVersion%", this.latestVersion, "%Version%", this.gSitMain.getDescription().getVersion(), "%Path%", this.gSitMain.getDescription().getWebsite());
    }

    private void getSpigotVersion(Consumer<String> versionConsumer) {
        this.gSitMain.getTaskService().run(() -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=62325").openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext() && versionConsumer != null) {
                    versionConsumer.accept(scanner.next());
                }
            }
            catch (IOException e) {
                if (e.getMessage().contains("50")) {
                    return;
                }
                this.gSitMain.getLogger().log(Level.SEVERE, "Could not get remote version!", e);
            }
        }, false);
    }

    private void checkVersion() {
        LocalDate today = LocalDate.now();
        if (this.lastCheckDate != null && this.lastCheckDate.equals(today)) {
            return;
        }
        this.lastCheckDate = today;
        try {
            this.getSpigotVersion(spigotVersion -> {
                this.latestVersion = spigotVersion;
                if (this.latestVersion == null) {
                    this.isLatestVersion = true;
                    return;
                }
                String pluginVersion = this.gSitMain.getDescription().getVersion();
                String[] pluginVersionParts = this.getShortVersion(pluginVersion).split("\\.");
                String[] spigotVersionParts = this.getShortVersion(this.latestVersion).split("\\.");
                int minLength = Math.min(pluginVersionParts.length, spigotVersionParts.length);
                for (int i = 0; i < minLength; ++i) {
                    int spigotPart;
                    int pluginPart = Integer.parseInt(pluginVersionParts[i]);
                    if (pluginPart < (spigotPart = Integer.parseInt(spigotVersionParts[i]))) {
                        this.isLatestVersion = false;
                        return;
                    }
                    if (pluginPart <= spigotPart) continue;
                    this.isLatestVersion = true;
                    return;
                }
                this.isLatestVersion = pluginVersionParts.length >= spigotVersionParts.length;
            });
        }
        catch (Throwable e) {
            this.isLatestVersion = true;
        }
    }

    private String getShortVersion(String version) {
        return version.replaceAll("[\\[\\] ]", "");
    }
}

