/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_21_9.model;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_21_9.entity.PlayerSitEntity;
import dev.geco.gsit.mcv.v1_21_9.entity.SeatEntity;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;

public class Pose
implements dev.geco.gsit.model.Pose {
    private final GSitMain gSitMain = GSitMain.getInstance();
    private final Seat seat;
    private final Player seatPlayer;
    private final PoseType poseType;
    private Set<Player> nearbyPlayers = new HashSet<Player>();
    private final EntityPlayer serverPlayer;
    protected final Mannequin mannequin;
    private PlayerSitEntity vehicleEntity;
    private OptionalInt leftShoulderCache;
    private OptionalInt rightShoulderCache;
    private final EnumDirection direction;
    protected PacketPlayOutEntityDestroy removeNpcPacket;
    protected PacketPlayOutSpawnEntity createNpcPacket;
    protected PacketPlayOutEntityMetadata metaNpcPacket;
    protected PacketPlayOutUpdateAttributes attributeNpcPacket;
    protected ClientboundBundlePacket bundle;
    private NonNullList<ItemStack> equipmentSlotCache;
    private ItemStack mainSlotCache;
    private float directionCache;
    protected int renderRange;
    private final Listener listener;

    public Pose(Seat seat, PoseType poseType) {
        boolean isLayPoseType;
        this.seat = seat;
        this.seatPlayer = (Player)seat.getEntity();
        this.poseType = poseType;
        this.serverPlayer = ((CraftPlayer)this.seatPlayer).getHandle();
        this.renderRange = this.seatPlayer.getWorld().getSimulationDistance() * 16;
        Location seatLocation = seat.getLocation();
        this.direction = this.getDirection();
        this.mannequin = this.createMannequin();
        double scale = this.serverPlayer.eA();
        double offset = seatLocation.getY() + this.gSitMain.getSitService().getBaseOffset();
        boolean bl = isLayPoseType = poseType == PoseType.LAY || poseType == PoseType.LAY_BACK;
        if (isLayPoseType) {
            offset += 0.1125 * scale;
        }
        if (poseType == PoseType.BELLYFLOP) {
            offset += -0.19 * scale;
        }
        float sleepYaw = this.direction == EnumDirection.d ? 270.0f : (this.direction == EnumDirection.e ? 180.0f : (this.direction == EnumDirection.f ? 0.0f : 90.0f));
        this.mannequin.a(seatLocation.getX() + (isLayPoseType ? (this.direction == EnumDirection.f ? 1.5 : (this.direction == EnumDirection.e ? -1.5 : 0.0)) : 0.0), offset, seatLocation.getZ() + (isLayPoseType ? (this.direction == EnumDirection.c ? -1.5 : (this.direction == EnumDirection.d ? 1.5 : 0.0)) : 0.0), isLayPoseType ? sleepYaw : 0.0f, poseType == PoseType.SPIN ? -90.0f : 0.0f);
        this.createNpcPacket = new PacketPlayOutSpawnEntity(this.mannequin.az(), this.mannequin.cT(), this.mannequin.dK(), this.mannequin.dM(), this.mannequin.dQ(), this.mannequin.dZ(), this.mannequin.dX(), this.mannequin.ax(), 0, this.mannequin.dI(), (double)this.mannequin.cN());
        this.removeNpcPacket = new PacketPlayOutEntityDestroy(new int[]{this.mannequin.az()});
        if (poseType == PoseType.LAY_BACK) {
            this.vehicleEntity = new PlayerSitEntity(this.seatPlayer.getLocation());
            this.vehicleEntity.a(seatLocation.getX() + (this.direction == EnumDirection.f ? 1.0 : (this.direction == EnumDirection.e ? -1.0 : 0.0)), seatLocation.getY() + this.gSitMain.getSitService().getBaseOffset() + -0.375 * scale, seatLocation.getZ() + (this.direction == EnumDirection.c ? -1.0 : (this.direction == EnumDirection.d ? 1.0 : 0.0)), sleepYaw, 0.0f);
        }
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEvent(PlayerInteractEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEntityEvent(PlayerInteractEntityEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityDamageByEntityEvent(EntityDamageByEntityEvent Event2) {
                if (Event2.getDamager() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void entityDamageEvent(EntityDamageEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.playAnimation(4);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void projectileLaunchEvent(ProjectileLaunchEvent Event2) {
                if (Event2.getEntity().getShooter() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerAnimationEvent(PlayerAnimationEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Event2.getAnimationType() == PlayerAnimationType.ARM_SWING) {
                    Pose.this.playAnimation(Event2.getPlayer().getMainHand().equals((Object)MainHand.RIGHT) ? 0 : 3);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void inventoryClickEvent(InventoryClickEvent Event2) {
                if (Event2.getWhoClicked() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerDropItemEvent(PlayerDropItemEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityPotionEffectEvent(EntityPotionEffectEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.serverPlayer.l(true);
                }
            }
        };
    }

    @Override
    public void spawn() {
        this.nearbyPlayers = this.getNearbyPlayers();
        this.mannequin.k(this.serverPlayer.cz());
        if (this.serverPlayer.cz()) {
            this.serverPlayer.k(false);
        }
        this.mannequin.c(EntityPose.values()[this.poseType.getPlayerPose().ordinal()]);
        if (this.poseType == PoseType.SPIN) {
            this.mannequin.aC().a(DataWatcherRegistry.a.a(8), (Object)4);
        }
        this.mannequin.aC().a(DataWatcherRegistry.a.a(15), (Object)((Byte)this.serverPlayer.aC().a(DataWatcherRegistry.a.a(15))));
        this.mannequin.aC().a(DataWatcherRegistry.a.a(16), (Object)((Byte)this.serverPlayer.aC().a(DataWatcherRegistry.a.a(16))));
        this.leftShoulderCache = (OptionalInt)this.serverPlayer.aC().a(DataWatcherRegistry.u.a(19));
        this.rightShoulderCache = (OptionalInt)this.serverPlayer.aC().a(DataWatcherRegistry.u.a(20));
        this.serverPlayer.aC().a(DataWatcherRegistry.u.a(19), (Object)OptionalInt.empty());
        this.serverPlayer.aC().a(DataWatcherRegistry.u.a(20), (Object)OptionalInt.empty());
        this.serverPlayer.l(true);
        this.setEquipmentVisibility(false);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            if (this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP) {
                this.seatPlayer.setSleepingIgnored(true);
            }
            if (this.gSitMain.getConfigService().P_LAY_REST) {
                this.seatPlayer.setStatistic(Statistic.TIME_SINCE_REST, 0);
            }
        }
        this.metaNpcPacket = new PacketPlayOutEntityMetadata(this.mannequin.az(), this.mannequin.aC().a() ? this.mannequin.aC().b() : this.mannequin.aC().c());
        this.attributeNpcPacket = new PacketPlayOutUpdateAttributes(this.mannequin.az(), this.serverPlayer.fp().c());
        ArrayList<Object> packages = new ArrayList<Object>();
        packages.add(this.createNpcPacket);
        if (this.poseType == PoseType.LAY_BACK) {
            this.mannequin.a((Entity)this.vehicleEntity, true, false);
            this.mannequin.c(EntityPose.values()[this.poseType.getPlayerPose().ordinal()]);
            packages.add(new PacketPlayOutSpawnEntity(this.vehicleEntity.az(), this.vehicleEntity.cT(), this.vehicleEntity.dK(), this.vehicleEntity.dM(), this.vehicleEntity.dQ(), this.vehicleEntity.dZ(), this.vehicleEntity.dX(), this.vehicleEntity.ax(), 0, this.vehicleEntity.dI(), (double)this.vehicleEntity.cN()));
            packages.add(new PacketPlayOutEntityMetadata(this.vehicleEntity.az(), this.vehicleEntity.aC().c()));
            packages.add(new PacketPlayOutMount((Entity)this.vehicleEntity));
        }
        packages.add(this.metaNpcPacket);
        packages.add(this.attributeNpcPacket);
        this.bundle = new ClientboundBundlePacket(packages);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.addViewerPlayer(nearbyPlayer);
        }
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gSitMain);
        ((SeatEntity)((CraftEntity)this.seat.getSeatEntity()).getHandle()).setRunnable(() -> {
            Set<Player> currentNearbyPlayers = this.getNearbyPlayers();
            for (Player nearbyPlayer : currentNearbyPlayers) {
                if (this.nearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.add(nearbyPlayer);
                this.addViewerPlayer(nearbyPlayer);
            }
            for (Player nearbyPlayer : new ArrayList<Player>(this.nearbyPlayers)) {
                if (currentNearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.remove(nearbyPlayer);
                this.removeViewerPlayer(nearbyPlayer);
            }
            if (this.poseType != PoseType.SPIN) {
                this.updateDirection();
            }
            this.serverPlayer.l(true);
            this.updateEquipment();
            this.setEquipmentVisibility(false);
            this.updateSkin();
            if (this.poseType != PoseType.LAY && this.poseType != PoseType.LAY_BACK || !this.gSitMain.getConfigService().P_LAY_SNORING_SOUNDS) {
                return;
            }
            long tick = this.serverPlayer.getPlayerTime();
            if ((!this.gSitMain.getConfigService().P_LAY_SNORING_NIGHT_ONLY || tick >= 12500L && tick <= 23500L) && tick % 90L == 0L) {
                for (Player nearbyPlayer : this.nearbyPlayers) {
                    nearbyPlayer.playSound(this.seat.getLocation(), Sound.ENTITY_FOX_SLEEP, SoundCategory.PLAYERS, 1.5f, 0.0f);
                }
            }
        });
    }

    private void addViewerPlayer(Player player) {
        this.sendPacket(player, (Packet<?>)this.bundle);
    }

    @Override
    public void remove() {
        ((SeatEntity)((CraftEntity)this.seat.getSeatEntity()).getHandle()).setRunnable(null);
        HandlerList.unregisterAll((Listener)this.listener);
        this.seatPlayer.removeScoreboardTag("GSit_POSE");
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.removeViewerPlayer(nearbyPlayer);
        }
        if (this.vehicleEntity != null) {
            this.sendPacket(this.serverPlayer, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{this.vehicleEntity.az()}));
        }
        if ((this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) && this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP) {
            this.seatPlayer.setSleepingIgnored(false);
        }
        if (!this.serverPlayer.cl.containsKey(MobEffects.n)) {
            this.serverPlayer.l(false);
        }
        this.setEquipmentVisibility(true);
        this.serverPlayer.aC().a(DataWatcherRegistry.u.a(19), (Object)this.leftShoulderCache);
        this.serverPlayer.aC().a(DataWatcherRegistry.u.a(20), (Object)this.rightShoulderCache);
        this.serverPlayer.k(this.mannequin.cz());
    }

    private void removeViewerPlayer(Player player) {
        EntityPlayer removePlayer = ((CraftPlayer)player).getHandle();
        this.sendPacket(removePlayer, (Packet<?>)this.removeNpcPacket);
    }

    private Set<Player> getNearbyPlayers() {
        HashSet<Player> currentNearbyPlayers = new HashSet<Player>();
        this.seatPlayer.getWorld().getPlayers().stream().filter(player -> this.seat.getLocation().distanceSquared(player.getLocation()) <= (double)(this.renderRange * this.renderRange) && player.canSee(this.seatPlayer)).forEach(currentNearbyPlayers::add);
        return currentNearbyPlayers;
    }

    private float fixYaw(float yaw) {
        return (yaw < 0.0f ? 360.0f + yaw : yaw) % 360.0f;
    }

    private void updateDirection() {
        if (this.poseType == PoseType.BELLYFLOP) {
            byte fixedRotation = this.getFixedRotation(this.seatPlayer.getLocation().getYaw());
            if (this.directionCache == (float)fixedRotation) {
                return;
            }
            this.directionCache = fixedRotation;
            PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((Entity)this.mannequin, fixedRotation);
            PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook moveEntityPacket = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.mannequin.az(), 0, 0, 0, fixedRotation, 0, true);
            for (Player nearbyPlayer : this.nearbyPlayers) {
                EntityPlayer player = ((CraftPlayer)nearbyPlayer).getHandle();
                this.sendPacket(player, (Packet<?>)rotateHeadPacket);
                this.sendPacket(player, (Packet<?>)moveEntityPacket);
            }
            return;
        }
        float playerYaw = this.seatPlayer.getLocation().getYaw();
        if (this.directionCache == playerYaw) {
            return;
        }
        this.directionCache = playerYaw;
        if (this.direction == EnumDirection.e) {
            playerYaw -= 90.0f;
        }
        if (this.direction == EnumDirection.f) {
            playerYaw += 90.0f;
        }
        if (this.direction == EnumDirection.c) {
            playerYaw -= 180.0f;
        }
        float f = (playerYaw = this.fixYaw(playerYaw)) >= 315.0f ? playerYaw - 360.0f : (playerYaw <= 45.0f ? playerYaw : (playerYaw = playerYaw >= 180.0f ? -45.0f : 45.0f));
        if (this.direction == EnumDirection.d) {
            playerYaw -= 90.0f;
        }
        if (this.direction == EnumDirection.e) {
            playerYaw += 180.0f;
        }
        if (this.direction == EnumDirection.c) {
            playerYaw += 90.0f;
        }
        PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((Entity)this.mannequin, this.getFixedRotation(playerYaw));
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)rotateHeadPacket);
        }
    }

    private void updateSkin() {
        this.mannequin.l(this.serverPlayer.cl.containsKey(MobEffects.n));
        DataWatcher entityData = this.mannequin.aC();
        this.mannequin.aC().a(DataWatcherRegistry.a.a(15), (Object)((Byte)this.serverPlayer.aC().a(DataWatcherRegistry.a.a(15))));
        this.mannequin.aC().a(DataWatcherRegistry.a.a(16), (Object)((Byte)this.serverPlayer.aC().a(DataWatcherRegistry.a.a(16))));
        this.mannequin.a(ResolvableProfile.a((GameProfile)this.serverPlayer.gz()));
        if (!entityData.a()) {
            return;
        }
        PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(this.mannequin.az(), entityData.b());
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)entityDataPacket);
        }
    }

    private void updateEquipment() {
        ItemStack mainItemStack = this.serverPlayer.a(EnumItemSlot.a);
        if (this.equipmentSlotCache != null && this.equipmentSlotCache.equals((Object)this.serverPlayer.gB().getContents()) && this.mainSlotCache == mainItemStack) {
            return;
        }
        this.equipmentSlotCache = NonNullList.a();
        this.equipmentSlotCache.addAll((Collection)this.serverPlayer.gB().getContents());
        this.mainSlotCache = mainItemStack;
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack itemStack = this.serverPlayer.a(equipmentSlot);
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)itemStack));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.mannequin.az(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
        this.serverPlayer.cl.b();
    }

    private void setEquipmentVisibility(boolean visibility) {
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack itemStack = visibility ? this.serverPlayer.a(equipmentSlot) : null;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)(itemStack != null ? itemStack : ItemStack.l)));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.serverPlayer.az(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
    }

    private void playAnimation(int animationId) {
        PacketPlayOutAnimation animatePacket = new PacketPlayOutAnimation((Entity)this.mannequin, animationId);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)animatePacket);
        }
    }

    private byte getFixedRotation(float rotation) {
        return (byte)(rotation * 256.0f / 360.0f);
    }

    private EnumDirection getDirection() {
        float yaw = this.seat.getLocation().getYaw();
        return yaw >= 135.0f || yaw < -135.0f ? EnumDirection.c : (yaw >= -135.0f && yaw < -45.0f ? EnumDirection.f : (yaw >= -45.0f && yaw < 45.0f ? EnumDirection.d : (yaw >= 45.0f ? EnumDirection.e : EnumDirection.c)));
    }

    private Mannequin createMannequin() {
        Mannequin playerMannequin = new Mannequin(EntityTypes.aG, (World)this.serverPlayer.A());
        playerMannequin.a(ResolvableProfile.a((GameProfile)this.serverPlayer.gz()));
        playerMannequin.b(true);
        playerMannequin.a(true);
        return playerMannequin;
    }

    private void sendPacket(Player player, Packet<?> packet) {
        this.sendPacket(((CraftPlayer)player).getHandle(), packet);
    }

    private void sendPacket(EntityPlayer player, Packet<?> packet) {
        player.g.b(packet);
    }

    @Override
    public Seat getSeat() {
        return this.seat;
    }

    @Override
    public Player getPlayer() {
        return this.seatPlayer;
    }

    @Override
    public PoseType getPoseType() {
        return this.poseType;
    }

    public String toString() {
        return this.seat.toString();
    }
}

