/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_19_1.model;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;

public class Pose
implements dev.geco.gsit.model.Pose {
    private final GSitMain gSitMain = GSitMain.getInstance();
    private final Seat seat;
    private final Player seatPlayer;
    private final PoseType poseType;
    private Set<Player> nearbyPlayers = new HashSet<Player>();
    private final EntityPlayer serverPlayer;
    protected final EntityPlayer playerNpc;
    private final Location blockLocation;
    private final Block bedBlock;
    private final BlockPosition bedPos;
    private final EnumDirection direction;
    protected PacketPlayOutBlockChange setBedPacket;
    protected PacketPlayOutPlayerInfo addNpcInfoPacket;
    protected PacketPlayOutPlayerInfo removeNpcInfoPacket;
    protected PacketPlayOutEntityDestroy removeNpcPacket;
    protected PacketPlayOutNamedEntitySpawn createNpcPacket;
    protected PacketPlayOutEntityMetadata metaNpcPacket;
    protected PacketPlayOutEntityTeleport teleportNpcPacket;
    protected PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook rotateNpcPacket;
    private NonNullList<ItemStack> equipmentSlotCache;
    private ItemStack mainSlotCache;
    private float directionCache;
    protected int renderRange;
    private UUID taskId;
    private final Listener listener;

    public Pose(Seat seat, PoseType poseType) {
        this.seat = seat;
        this.seatPlayer = (Player)seat.getEntity();
        this.poseType = poseType;
        this.serverPlayer = ((CraftPlayer)this.seatPlayer).getHandle();
        this.renderRange = this.seatPlayer.getWorld().getSimulationDistance() * 16;
        Location seatLocation = seat.getLocation();
        this.blockLocation = seatLocation.clone();
        this.blockLocation.setY((double)this.blockLocation.getWorld().getMinHeight());
        this.bedBlock = this.blockLocation.getBlock();
        this.bedPos = new BlockPosition(this.blockLocation.getBlockX(), this.blockLocation.getBlockY(), this.blockLocation.getBlockZ());
        this.playerNpc = this.createNPC();
        this.playerNpc.b(seatLocation.getX(), seatLocation.getY() + (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK ? 0.3125 : (poseType == PoseType.SPIN ? 0.2 : 0.0)), seatLocation.getZ(), 0.0f, 0.0f);
        this.direction = this.getDirection();
        if (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK) {
            this.setBedPacket = new PacketPlayOutBlockChange(this.bedPos, (IBlockData)((IBlockData)Blocks.aM.m().a((IBlockState)BlockBed.aD, (Comparable)this.direction.g())).a((IBlockState)BlockBed.a, (Comparable)BlockPropertyBedPart.a));
        }
        this.addNpcInfoPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{this.playerNpc});
        this.removeNpcInfoPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{this.playerNpc});
        this.removeNpcPacket = new PacketPlayOutEntityDestroy(new int[]{this.playerNpc.ae()});
        this.createNpcPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)this.playerNpc);
        if (poseType == PoseType.LAY || poseType == PoseType.LAY_BACK) {
            this.teleportNpcPacket = new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.playerNpc);
        }
        if (poseType == PoseType.SPIN) {
            this.rotateNpcPacket = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.playerNpc.ae(), 0, 0, 0, 0, this.getFixedRotation(-90.0f), true);
        }
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEvent(PlayerInteractEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerInteractEntityEvent(PlayerInteractEntityEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityDamageByEntityEvent(EntityDamageByEntityEvent Event2) {
                if (Event2.getDamager() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void entityDamageEvent(EntityDamageEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.playAnimation(1);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void projectileLaunchEvent(ProjectileLaunchEvent Event2) {
                if (Event2.getEntity().getShooter() == Pose.this.seatPlayer && !Pose.this.gSitMain.getConfigService().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void playerAnimationEvent(PlayerAnimationEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Event2.getAnimationType() == PlayerAnimationType.ARM_SWING) {
                    Pose.this.playAnimation(Event2.getPlayer().getMainHand().equals((Object)MainHand.RIGHT) ? 0 : 3);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void inventoryClickEvent(InventoryClickEvent Event2) {
                if (Event2.getWhoClicked() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void playerDropItemEvent(PlayerDropItemEvent Event2) {
                if (Event2.getPlayer() == Pose.this.seatPlayer && Pose.this.seatPlayer.getGameMode() == GameMode.CREATIVE) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void entityPotionEffectEvent(EntityPotionEffectEvent Event2) {
                if (Event2.getEntity() == Pose.this.seatPlayer) {
                    Pose.this.serverPlayer.j(true);
                }
            }
        };
    }

    @Override
    public void spawn() {
        this.nearbyPlayers = this.getNearbyPlayers();
        this.playerNpc.i(this.serverPlayer.bV());
        if (this.serverPlayer.bV()) {
            this.serverPlayer.i(false);
        }
        this.playerNpc.ai().b(DataWatcherRegistry.t.a(6), (Object)EntityPose.values()[this.poseType.getPlayerPose().ordinal()]);
        if (this.poseType == PoseType.SPIN) {
            this.playerNpc.ai().b(DataWatcherRegistry.a.a(8), (Object)4);
        }
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            this.playerNpc.ai().b(DataWatcherRegistry.m.a(14), Optional.of(this.bedPos));
        }
        this.playerNpc.ai().b(DataWatcherRegistry.a.a(17), (Object)((Byte)this.serverPlayer.ai().a(DataWatcherRegistry.a.a(17))));
        this.playerNpc.ai().b(DataWatcherRegistry.a.a(18), (Object)((Byte)this.serverPlayer.ai().a(DataWatcherRegistry.a.a(18))));
        this.playerNpc.ai().b(DataWatcherRegistry.q.a(19), (Object)((NBTTagCompound)this.serverPlayer.ai().a(DataWatcherRegistry.q.a(19))));
        this.playerNpc.ai().b(DataWatcherRegistry.q.a(20), (Object)((NBTTagCompound)this.serverPlayer.ai().a(DataWatcherRegistry.q.a(20))));
        this.serverPlayer.ai().b(DataWatcherRegistry.q.a(19), (Object)new NBTTagCompound());
        this.serverPlayer.ai().b(DataWatcherRegistry.q.a(20), (Object)new NBTTagCompound());
        this.serverPlayer.j(true);
        this.setEquipmentVisibility(false);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            if (this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP) {
                this.seatPlayer.setSleepingIgnored(true);
            }
            if (this.gSitMain.getConfigService().P_LAY_REST) {
                this.seatPlayer.setStatistic(Statistic.TIME_SINCE_REST, 0);
            }
        }
        this.metaNpcPacket = new PacketPlayOutEntityMetadata(this.playerNpc.ae(), this.playerNpc.ai(), false);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.addViewerPlayer(nearbyPlayer);
        }
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gSitMain);
        this.startUpdate();
    }

    private void addViewerPlayer(Player player) {
        EntityPlayer spawnPlayer = ((CraftPlayer)player).getHandle();
        this.sendPacket(spawnPlayer, (Packet<?>)this.addNpcInfoPacket);
        this.sendPacket(spawnPlayer, (Packet<?>)this.createNpcPacket);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            this.sendPacket(spawnPlayer, (Packet<?>)this.setBedPacket);
        }
        this.sendPacket(spawnPlayer, (Packet<?>)this.metaNpcPacket);
        if (this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) {
            this.sendPacket(spawnPlayer, (Packet<?>)this.teleportNpcPacket);
        }
        if (this.poseType == PoseType.SPIN) {
            this.sendPacket(spawnPlayer, (Packet<?>)this.rotateNpcPacket);
        }
        this.gSitMain.getTaskService().runDelayed(() -> this.sendPacket(spawnPlayer, (Packet<?>)this.removeNpcInfoPacket), (Entity)this.seatPlayer, 15L);
    }

    @Override
    public void remove() {
        this.stopUpdate();
        HandlerList.unregisterAll((Listener)this.listener);
        this.seatPlayer.removeScoreboardTag("GSit_POSE");
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.removeViewerPlayer(nearbyPlayer);
        }
        if ((this.poseType == PoseType.LAY || this.poseType == PoseType.LAY_BACK) && this.gSitMain.getConfigService().P_LAY_NIGHT_SKIP) {
            this.seatPlayer.setSleepingIgnored(false);
        }
        if (!this.serverPlayer.bS.containsKey(MobEffects.n)) {
            this.serverPlayer.j(false);
        }
        this.setEquipmentVisibility(true);
        this.serverPlayer.ai().b(DataWatcherRegistry.q.a(19), (Object)((NBTTagCompound)this.playerNpc.ai().a(DataWatcherRegistry.q.a(19))));
        this.serverPlayer.ai().b(DataWatcherRegistry.q.a(20), (Object)((NBTTagCompound)this.playerNpc.ai().a(DataWatcherRegistry.q.a(20))));
        this.serverPlayer.i(this.playerNpc.bV());
    }

    private void removeViewerPlayer(Player player) {
        EntityPlayer removePlayer = ((CraftPlayer)player).getHandle();
        this.sendPacket(removePlayer, (Packet<?>)this.removeNpcInfoPacket);
        this.sendPacket(removePlayer, (Packet<?>)this.removeNpcPacket);
        player.sendBlockChange(this.blockLocation, this.bedBlock.getBlockData());
    }

    private Set<Player> getNearbyPlayers() {
        HashSet<Player> currentNearbyPlayers = new HashSet<Player>();
        this.seatPlayer.getWorld().getPlayers().stream().filter(player -> this.seat.getLocation().distanceSquared(player.getLocation()) <= (double)(this.renderRange * this.renderRange) && player.canSee(this.seatPlayer)).forEach(currentNearbyPlayers::add);
        return currentNearbyPlayers;
    }

    private void startUpdate() {
        this.taskId = this.gSitMain.getTaskService().runAtFixedRate(() -> {
            Set<Player> currentNearbyPlayers = this.getNearbyPlayers();
            for (Player nearbyPlayer : currentNearbyPlayers) {
                if (this.nearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.add(nearbyPlayer);
                this.addViewerPlayer(nearbyPlayer);
            }
            for (Player nearbyPlayer : new ArrayList<Player>(this.nearbyPlayers)) {
                if (currentNearbyPlayers.contains(nearbyPlayer)) continue;
                this.nearbyPlayers.remove(nearbyPlayer);
                this.removeViewerPlayer(nearbyPlayer);
            }
            if (this.poseType != PoseType.SPIN) {
                this.updateDirection();
            }
            this.serverPlayer.j(true);
            this.updateEquipment();
            this.setEquipmentVisibility(false);
            this.updateSkin();
            if (this.poseType != PoseType.LAY && this.poseType != PoseType.LAY_BACK || !this.gSitMain.getConfigService().P_LAY_SNORING_SOUNDS) {
                return;
            }
            long tick = this.serverPlayer.getPlayerTime();
            if ((!this.gSitMain.getConfigService().P_LAY_SNORING_NIGHT_ONLY || tick >= 12500L && tick <= 23500L) && tick % 90L == 0L) {
                for (Player nearbyPlayer : this.nearbyPlayers) {
                    nearbyPlayer.playSound(this.seat.getLocation(), Sound.ENTITY_FOX_SLEEP, SoundCategory.PLAYERS, 1.5f, 0.0f);
                }
            }
        }, false, 5L, 1L);
    }

    private void stopUpdate() {
        this.gSitMain.getTaskService().cancel(this.taskId);
    }

    private float fixYaw(float yaw) {
        return (yaw < 0.0f ? 360.0f + yaw : yaw) % 360.0f;
    }

    private void updateDirection() {
        if (this.poseType == PoseType.BELLYFLOP) {
            byte fixedRotation = this.getFixedRotation(this.seatPlayer.getLocation().getYaw());
            if (this.directionCache == (float)fixedRotation) {
                return;
            }
            this.directionCache = fixedRotation;
            PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)this.playerNpc, fixedRotation);
            PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook moveEntityPacket = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.playerNpc.ae(), 0, 0, 0, fixedRotation, 0, true);
            for (Player nearbyPlayer : this.nearbyPlayers) {
                EntityPlayer player = ((CraftPlayer)nearbyPlayer).getHandle();
                this.sendPacket(player, (Packet<?>)rotateHeadPacket);
                this.sendPacket(player, (Packet<?>)moveEntityPacket);
            }
            return;
        }
        float playerYaw = this.seatPlayer.getLocation().getYaw();
        if (this.directionCache == playerYaw) {
            return;
        }
        this.directionCache = playerYaw;
        if (this.direction == EnumDirection.e) {
            playerYaw -= 90.0f;
        }
        if (this.direction == EnumDirection.f) {
            playerYaw += 90.0f;
        }
        if (this.direction == EnumDirection.c) {
            playerYaw -= 180.0f;
        }
        byte fixedRotation = this.getFixedRotation((playerYaw = this.fixYaw(playerYaw)) >= 315.0f ? playerYaw - 360.0f : (playerYaw <= 45.0f ? playerYaw : (playerYaw >= 180.0f ? -45.0f : 45.0f)));
        PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)this.playerNpc, fixedRotation);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)rotateHeadPacket);
        }
    }

    private void updateSkin() {
        this.playerNpc.j(this.serverPlayer.bS.containsKey(MobEffects.n));
        DataWatcher entityData = this.playerNpc.ai();
        entityData.b(DataWatcherRegistry.a.a(17), (Object)((Byte)this.serverPlayer.ai().a(DataWatcherRegistry.a.a(17))));
        entityData.b(DataWatcherRegistry.a.a(18), (Object)((Byte)this.serverPlayer.ai().a(DataWatcherRegistry.a.a(18))));
        if (!entityData.a()) {
            return;
        }
        PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(this.playerNpc.ae(), entityData, false);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)entityDataPacket);
        }
    }

    private void updateEquipment() {
        ItemStack mainItemStack = this.serverPlayer.c(EnumItemSlot.a);
        if (this.equipmentSlotCache != null && this.equipmentSlotCache.equals((Object)this.serverPlayer.fA().getContents()) && this.mainSlotCache == mainItemStack) {
            return;
        }
        this.equipmentSlotCache = NonNullList.a();
        this.equipmentSlotCache.addAll((Collection)this.serverPlayer.fA().getContents());
        this.mainSlotCache = mainItemStack;
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack itemStack = this.serverPlayer.c(equipmentSlot);
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)itemStack));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.playerNpc.ae(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
        this.serverPlayer.bU.b();
    }

    private void setEquipmentVisibility(boolean visibility) {
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack itemStack = visibility ? this.serverPlayer.c(equipmentSlot) : null;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)(itemStack != null ? itemStack : ItemStack.b)));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.serverPlayer.ae(), equipmentList);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)setEquipmentPacket);
        }
    }

    private void playAnimation(int animationId) {
        PacketPlayOutAnimation animatePacket = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)this.playerNpc, animationId);
        for (Player nearbyPlayer : this.nearbyPlayers) {
            this.sendPacket(nearbyPlayer, (Packet<?>)animatePacket);
        }
    }

    private byte getFixedRotation(float rotation) {
        return (byte)(rotation * 256.0f / 360.0f);
    }

    private EnumDirection getDirection() {
        float yaw = this.seat.getLocation().getYaw();
        return yaw >= 135.0f || yaw < -135.0f ? EnumDirection.c : (yaw >= -135.0f && yaw < -45.0f ? EnumDirection.f : (yaw >= -45.0f && yaw < 45.0f ? EnumDirection.d : (yaw >= 45.0f ? EnumDirection.e : EnumDirection.c)));
    }

    private EntityPlayer createNPC() {
        DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer serverLevel = ((CraftWorld)this.seat.getLocation().getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), this.seatPlayer.getName());
        gameProfile.getProperties().putAll((Multimap)this.serverPlayer.fy().getProperties());
        return new EntityPlayer((MinecraftServer)minecraftServer, serverLevel, gameProfile, null);
    }

    private void sendPacket(Player player, Packet<?> packet) {
        this.sendPacket(((CraftPlayer)player).getHandle(), packet);
    }

    private void sendPacket(EntityPlayer player, Packet<?> packet) {
        player.b.a(packet);
    }

    @Override
    public Seat getSeat() {
        return this.seat;
    }

    @Override
    public Player getPlayer() {
        return this.seatPlayer;
    }

    @Override
    public PoseType getPoseType() {
        return this.poseType;
    }

    public String toString() {
        return this.seat.toString();
    }
}

