/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.event;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PrePlayerStopPlayerSitEvent;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class EntityEventHandler {
    private final GSitMain gSitMain;

    public EntityEventHandler(GSitMain gSitMain) {
        this.gSitMain = gSitMain;
    }

    public void handleEntityDismountEvent(Cancellable event, Entity entity, Entity dismounted) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Seat seat = this.gSitMain.getSitService().getSeatByEntity((LivingEntity)player);
        if (!(seat == null || this.gSitMain.getConfigService().GET_UP_SNEAK && this.gSitMain.getSitService().removeSeat(seat, StopReason.GET_UP, true))) {
            event.setCancelled(true);
            return;
        }
        Pose pose = this.gSitMain.getPoseService().getPoseByPlayer(player);
        if (!(pose == null || this.gSitMain.getConfigService().GET_UP_SNEAK && this.gSitMain.getPoseService().removePose(pose, StopReason.GET_UP, true))) {
            event.setCancelled(true);
            return;
        }
        if (!dismounted.getScoreboardTags().contains("GSit_PlayerSitEntity") || !this.gSitMain.getPlayerSitService().isPlayerInPlayerSitStack(player)) {
            return;
        }
        PrePlayerStopPlayerSitEvent preEvent = new PrePlayerStopPlayerSitEvent(player, StopReason.GET_UP);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        this.gSitMain.getPlayerSitService().getPreventDismountStackPlayers().add(player);
        this.gSitMain.getTaskService().runDelayed(() -> this.gSitMain.getPlayerSitService().getPreventDismountStackPlayers().remove(player), 2L);
        Entity bottom = this.gSitMain.getPassengerUtil().getBottomEntityVehicle(dismounted);
        if (this.gSitMain.getConfigService().PS_BOTTOM_RETURN && player.isValid()) {
            this.gSitMain.getEntityUtil().setEntityLocation((Entity)player, bottom.getLocation());
        }
        this.gSitMain.getPlayerSitService().stopPlayerSit(player, StopReason.GET_UP, false, true, false);
    }
}

