/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service.converter;

import dev.geco.gmusic.GMusicMain;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class NBSConverter {
    private final GMusicMain gMusicMain;

    public NBSConverter(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public boolean convertNBSFile(File nbsFile) {
        try {
            int instrument;
            int jt;
            DataInputStream dataInput = new DataInputStream(Files.newInputStream(nbsFile.toPath(), new OpenOption[0]));
            short type = this.readShort(dataInput);
            byte version = 0;
            if (type == 0) {
                version = dataInput.readByte();
                dataInput.readByte();
                if (version >= 3) {
                    this.readShort(dataInput);
                }
            }
            int layerCount = this.readShort(dataInput);
            String title = this.readString(dataInput);
            if (title.isEmpty()) {
                title = nbsFile.getName().replaceFirst("[.][^.]+$", "");
            }
            String author = this.readString(dataInput);
            String originalAuthor = this.readString(dataInput);
            String description = this.readString(dataInput);
            float sequence = (float)this.readShort(dataInput) / 100.0f;
            dataInput.readBoolean();
            dataInput.readByte();
            dataInput.readByte();
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readString(dataInput);
            if (version >= 4) {
                dataInput.readByte();
                dataInput.readByte();
                this.readShort(dataInput);
            }
            ArrayList<Object> gnbsContent = new ArrayList<Object>();
            ArrayList<Byte> gnbsInstruments = new ArrayList<Byte>();
            ArrayList<Byte> layerVolumes = new ArrayList<Byte>();
            ArrayList<Integer> layerDirections = new ArrayList<Integer>();
            this.readLayerInfo(nbsFile, (short)layerCount, layerVolumes, layerDirections);
            int currentLayer = -1;
            while ((jt = this.readShort(dataInput)) != 0) {
                StringBuilder content = new StringBuilder((long)((float)((gnbsContent.isEmpty() ? jt - 1 : jt) * 1000) / sequence) + "!");
                while (true) {
                    short jl;
                    if ((jl = this.readShort(dataInput)) == 0) break;
                    currentLayer += jl;
                    byte i = dataInput.readByte();
                    byte k = dataInput.readByte();
                    int p = 100;
                    int v = 100;
                    if (version >= 4) {
                        v = dataInput.readByte();
                        p = 200 - dataInput.readUnsignedByte();
                        this.readShort(dataInput);
                    }
                    v = (Byte)layerVolumes.get(currentLayer) * v / 100;
                    if ((Integer)layerDirections.get(currentLayer) != 100) {
                        p = ((Integer)layerDirections.get(currentLayer) + p) / 2;
                    }
                    String contentPart = i + ":" + v + ":#" + (k - 33) + (String)(p == 100 ? "" : ":" + p);
                    content.append(content.toString().endsWith("!") ? contentPart : "_" + contentPart);
                    if (gnbsInstruments.contains(i)) continue;
                    gnbsInstruments.add(i);
                }
                currentLayer = -1;
                if (!gnbsContent.isEmpty()) {
                    String[] tick = ((String)gnbsContent.get(gnbsContent.size() - 1)).split(";");
                    if (content.toString().equals(tick[0])) {
                        gnbsContent.remove(gnbsContent.size() - 1);
                        gnbsContent.add(String.valueOf(content) + ";" + ((tick.length == 1 || tick[1].isEmpty() ? 0L : Long.parseLong(tick[1])) + 1L));
                        continue;
                    }
                    gnbsContent.add(content.toString());
                    continue;
                }
                gnbsContent.add(content.toString());
            }
            for (int layer = 0; layer < layerCount; ++layer) {
                this.readString(dataInput);
                if (version >= 4) {
                    dataInput.readByte();
                }
                dataInput.readByte();
                if (version < 2) continue;
                dataInput.readByte();
            }
            int midiInstrumentsLength = dataInput.readByte();
            ArrayList<String> midiInstruments = new ArrayList<String>();
            for (int instrumentCount = 0; instrumentCount < midiInstrumentsLength; ++instrumentCount) {
                this.readString(dataInput);
                midiInstruments.add(this.readString(dataInput).replace(".ogg", ""));
                dataInput.readByte();
                dataInput.readByte();
            }
            String gnbsFilename = nbsFile.getName();
            int extensionPos = gnbsFilename.lastIndexOf(".");
            if (extensionPos != -1) {
                gnbsFilename = gnbsFilename.substring(0, extensionPos);
            }
            File gnbsFile = new File(this.gMusicMain.getDataFolder(), "gnbs/" + gnbsFilename + ".gnbs");
            YamlConfiguration gnbsStruct = YamlConfiguration.loadConfiguration((File)gnbsFile);
            gnbsStruct.set("Song.Id", (Object)title.replace(" ", ""));
            gnbsStruct.set("Song.Title", (Object)title);
            gnbsStruct.set("Song.OriginalAuthor", (Object)originalAuthor);
            gnbsStruct.set("Song.Author", (Object)author);
            gnbsStruct.set("Song.Description", description.replace(" ", "").isEmpty() ? new ArrayList() : Arrays.asList(description.split("\n")));
            gnbsStruct.set("Song.Category", (Object)"RECORDS");
            for (instrument = 0; instrument < 16; instrument = (byte)(instrument + 1)) {
                if (!gnbsInstruments.contains((byte)instrument)) continue;
                gnbsStruct.set("Song.Content.Instruments." + (byte)instrument, (Object)((byte)instrument));
            }
            for (instrument = 16; instrument < 16 + midiInstruments.size(); ++instrument) {
                gnbsStruct.set("Song.Content.Instruments." + instrument, midiInstruments.get(instrument - 16));
            }
            gnbsStruct.set("Song.Content.Main", gnbsContent);
            gnbsStruct.save(gnbsFile);
            return true;
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not convert nbs file to gnbs file!", e);
            return false;
        }
    }

    private short readShort(DataInputStream dataInput) throws IOException {
        int i1 = dataInput.readUnsignedByte();
        int i2 = dataInput.readUnsignedByte();
        return (short)(i1 + (i2 << 8));
    }

    private int readInt(DataInputStream dataInput) throws IOException {
        int i1 = dataInput.readUnsignedByte();
        int i2 = dataInput.readUnsignedByte();
        int i3 = dataInput.readUnsignedByte();
        int i4 = dataInput.readUnsignedByte();
        return i1 + (i2 << 8) + (i3 << 16) + (i4 << 24);
    }

    private String readString(DataInputStream dataInput) throws IOException {
        int length;
        StringBuilder builder = new StringBuilder(length);
        for (length = this.readInt(dataInput); length > 0; --length) {
            char c = (char)dataInput.readByte();
            builder.append(c == '\r' ? (char)' ' : (char)c);
        }
        return builder.toString();
    }

    private void readLayerInfo(File nbsFile, Short layerCount, List<Byte> layerVolumes, List<Integer> layerDirections) {
        try {
            short jt;
            DataInputStream dataInput = new DataInputStream(Files.newInputStream(nbsFile.toPath(), new OpenOption[0]));
            short type = this.readShort(dataInput);
            byte version = 0;
            if (type == 0) {
                version = dataInput.readByte();
                dataInput.readByte();
                if (version >= 3) {
                    this.readShort(dataInput);
                }
            }
            this.readShort(dataInput);
            this.readString(dataInput);
            this.readString(dataInput);
            this.readString(dataInput);
            this.readString(dataInput);
            this.readShort(dataInput);
            dataInput.readBoolean();
            dataInput.readByte();
            dataInput.readByte();
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readInt(dataInput);
            this.readString(dataInput);
            if (version >= 4) {
                dataInput.readByte();
                dataInput.readByte();
                this.readShort(dataInput);
            }
            while ((jt = this.readShort(dataInput)) != 0) {
                short jl;
                while ((jl = this.readShort(dataInput)) != 0) {
                    dataInput.readByte();
                    dataInput.readByte();
                    if (version < 4) continue;
                    dataInput.readByte();
                    dataInput.readUnsignedByte();
                    this.readShort(dataInput);
                }
            }
            for (int layer = 0; layer < layerCount; ++layer) {
                this.readString(dataInput);
                if (version >= 4) {
                    dataInput.readByte();
                }
                byte layerVolume = dataInput.readByte();
                layerVolumes.add(layerVolume);
                int layerDirection = 100;
                if (version >= 2) {
                    layerDirection = 200 - dataInput.readUnsignedByte();
                }
                layerDirections.add(layerDirection);
            }
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not read nbs layer!", e);
        }
    }
}

