/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.Song;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaySettingsService {
    private final GMusicMain gMusicMain;
    private final HashMap<UUID, PlaySettings> playSettingsCache = new HashMap();

    public PlaySettingsService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public void createDataTables() {
        try {
            this.gMusicMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gmusic_play_settings (uuid TEXT, playListMode INTEGER, volume INTEGER, playOnJoin INTEGER, playMode INTEGER, showParticles INTEGER, reverseMode INTEGER, toggleMode INTEGER, range INTEGER, currentSong TEXT);", new Object[0]);
            this.gMusicMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gmusic_play_settings_favorites (uuid TEXT, songId TEXT);", new Object[0]);
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not create play settings database tables!", e);
        }
    }

    @NotNull
    public PlaySettings getPlaySettings(@NotNull UUID uuid) {
        if (this.playSettingsCache.containsKey(uuid)) {
            return this.playSettingsCache.get(uuid);
        }
        ArrayList<Song> favorites = new ArrayList<Song>();
        PlaySettings playSettings = null;
        try {
            try (ResultSet playSettingsFavoritesData = this.gMusicMain.getDataService().executeAndGet("SELECT * FROM gmusic_play_settings_favorites WHERE uuid = ?", uuid.toString());){
                while (playSettingsFavoritesData.next()) {
                    favorites.add(this.gMusicMain.getSongService().getSongById(playSettingsFavoritesData.getString("songId")));
                }
            }
            try (ResultSet playSettingsData = this.gMusicMain.getDataService().executeAndGet("SELECT * FROM gmusic_play_settings WHERE uuid = ?", uuid.toString());){
                if (playSettingsData.next()) {
                    playSettings = new PlaySettings(uuid, PlayListMode.byId(playSettingsData.getInt("playListMode")), playSettingsData.getInt("volume"), playSettingsData.getBoolean("playOnJoin"), PlayMode.byId(playSettingsData.getInt("playMode")), playSettingsData.getBoolean("showParticles"), playSettingsData.getBoolean("reverseMode"), playSettingsData.getBoolean("toggleMode"), playSettingsData.getLong("range"), playSettingsData.getString("currentSong"), favorites);
                }
            }
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not load play settings", e);
        }
        if (playSettings == null) {
            playSettings = this.generateDefaultPlaySettings(uuid);
        } else {
            this.playSettingsCache.put(uuid, playSettings);
        }
        playSettings.setFavorites(favorites);
        return playSettings;
    }

    @NotNull
    public PlaySettings generateDefaultPlaySettings(@NotNull UUID uuid) {
        PlaySettings playSettings = new PlaySettings(uuid, PlayListMode.byId(this.gMusicMain.getConfigService().PS_D_PLAYLIST_MODE), this.gMusicMain.getConfigService().PS_D_VOLUME, this.gMusicMain.getConfigService().R_PLAY_ON_JOIN, PlayMode.byId(this.gMusicMain.getConfigService().PS_D_PLAY_MODE), this.gMusicMain.getConfigService().PS_D_PARTICLES, this.gMusicMain.getConfigService().PS_D_REVERSE, false, 0L, null, new ArrayList<Song>());
        this.playSettingsCache.put(uuid, playSettings);
        return playSettings;
    }

    public void savePlaySettings(@NotNull UUID uuid, @Nullable PlaySettings playSettings) {
        try {
            this.gMusicMain.getDataService().execute("DELETE FROM gmusic_play_settings WHERE uuid = ?", uuid.toString());
            this.gMusicMain.getDataService().execute("DELETE FROM gmusic_play_settings_favorites WHERE uuid = ?", uuid.toString());
            if (playSettings == null) {
                this.playSettingsCache.remove(uuid);
                return;
            }
            this.playSettingsCache.put(uuid, playSettings);
            this.gMusicMain.getDataService().execute("INSERT INTO gmusic_play_settings (uuid, playListMode, volume, playOnJoin, playMode, showParticles, reverseMode, toggleMode, range, currentSong) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", uuid.toString(), playSettings.getPlayListMode().getId(), playSettings.getVolume(), playSettings.isPlayOnJoin(), playSettings.getPlayMode().getId(), playSettings.isShowingParticles(), playSettings.isReverseMode(), playSettings.isToggleMode(), playSettings.getRange(), playSettings.getCurrentSong());
            if (playSettings.getFavorites().isEmpty()) {
                return;
            }
            for (Song favoriteSong : playSettings.getFavorites()) {
                this.gMusicMain.getDataService().execute("INSERT INTO gmusic_play_settings_favorites (uuid, songId) VALUES (?, ?)", uuid.toString(), favoriteSong.getId());
            }
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not save play settings", e);
        }
    }

    public void savePlaySettings() {
        for (Map.Entry<UUID, PlaySettings> playSettings : this.playSettingsCache.entrySet()) {
            this.savePlaySettings(playSettings.getKey(), playSettings.getValue());
        }
        this.playSettingsCache.clear();
    }

    public void removePlaySettingsCache(@NotNull UUID uuid) {
        this.playSettingsCache.remove(uuid);
    }
}

