/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.NotePart;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.PlayState;
import dev.geco.gmusic.model.Song;
import dev.geco.gmusic.model.gui.MusicGUI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayService {
    private final GMusicMain gMusicMain;
    private final Random random = new Random();
    private final HashMap<UUID, PlayState> playStates = new HashMap();

    public PlayService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public void playSong(@NotNull Player player, @Nullable Song song) {
        this.playSong(player, song, 0L);
    }

    private void playSong(@NotNull Player player, @Nullable Song song, long delay) {
        if (song == null) {
            return;
        }
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
        if (playSettings.getPlayListMode() == PlayListMode.RADIO) {
            return;
        }
        PlayState playState = this.getPlayState(player.getUniqueId());
        if (playState != null) {
            playState.getTimer().cancel();
        }
        Timer timer = new Timer();
        playState = new PlayState(song, timer, playSettings.isReverseMode() ? song.getLength() + delay : -delay);
        this.setPlayState(player.getUniqueId(), playState);
        playSettings.setCurrentSong(song.getId());
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
        }
        this.startSong(player, song, timer);
    }

    @Nullable
    public Song getRandomSong(@NotNull UUID uuid) {
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        List<Song> songs = playSettings.getPlayListMode() == PlayListMode.FAVORITES ? playSettings.getFavorites() : this.gMusicMain.getSongService().getSongs();
        return !songs.isEmpty() ? songs.get(this.random.nextInt(songs.size())) : null;
    }

    @Nullable
    public Song getShuffleSong(@NotNull UUID uuid, @NotNull Song song) {
        List<Song> songs;
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        List<Song> list = songs = playSettings.getPlayListMode() == PlayListMode.FAVORITES ? playSettings.getFavorites() : this.gMusicMain.getSongService().getSongs();
        return !songs.isEmpty() ? (songs.indexOf(song) + 1 == songs.size() ? songs.get(0) : songs.get(songs.indexOf(song) + 1)) : null;
    }

    private void startSong(final @NotNull Player player, final @NotNull Song song, final @NotNull Timer timer) {
        final UUID uuid = player.getUniqueId();
        final PlayState playState = this.getPlayState(uuid);
        final PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
        final long[] ticker = new long[]{0L};
        timer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ PlayService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ticker[0] = ticker[0] + 1L;
                long position = playState.getTickPosition();
                List<NotePart> noteParts = song.getContent().get(position);
                if (noteParts != null && playSettings.getVolume() > 0) {
                    if (playSettings.isShowingParticles()) {
                        player.spawnParticle(Particle.NOTE, player.getEyeLocation().add(this.this$0.random.nextDouble() - 0.5, 0.3, this.this$0.random.nextDouble() - 0.5), 0, this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), 1.0);
                    }
                    for (NotePart notePart : noteParts) {
                        if (notePart.getSound() != null) {
                            Location location;
                            float volume = playSettings.getFixedVolume() * notePart.getVolume();
                            Location location2 = location = notePart.getDistance() == 0.0f ? player.getEyeLocation() : this.this$0.gMusicMain.getSteroNoteUtil().convertToStero(player.getEyeLocation(), notePart.getDistance());
                            if (!this.this$0.gMusicMain.getConfigService().ENVIRONMENT_EFFECTS) {
                                player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                continue;
                            }
                            if (this.this$0.gMusicMain.getEnvironmentUtil().isPlayerSwimming(player)) {
                                player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume > 0.4f ? volume - 0.3f : volume, notePart.getPitch() - 0.15f);
                                continue;
                            }
                            player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                            continue;
                        }
                        if (notePart.getStopSound() == null) continue;
                        player.stopSound(notePart.getStopSound(), song.getSoundCategory());
                    }
                }
                if (position == (playSettings.isReverseMode() ? 0L : song.getLength())) {
                    if (playSettings.getPlayMode() == PlayMode.LOOP) {
                        position = playSettings.isReverseMode() ? song.getLength() + (long)this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_REPEAT : (long)(-this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_REPEAT);
                        playState.setTickPosition(position);
                    } else {
                        timer.cancel();
                        if (playSettings.getPlayMode() == PlayMode.SHUFFLE) {
                            this.this$0.playSong(player, this.this$0.getShuffleSong(uuid, song), this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_SHUFFLE);
                        } else {
                            this.this$0.playStates.remove(uuid);
                            MusicGUI musicGUI = MusicGUI.getMusicGUI(uuid);
                            if (musicGUI != null) {
                                musicGUI.setPauseResumeBar();
                            }
                        }
                    }
                    return;
                }
                playState.setTickPosition(playSettings.isReverseMode() ? position - 1L : position + 1L);
                if (this.this$0.gMusicMain.getConfigService().A_SHOW_WHILE_PLAYING && ticker[0] % 2000L == 0L) {
                    this.this$0.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-playing", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
                }
            }
        }, 0L, 1L);
    }

    @Nullable
    public PlayState getPlayState(@NotNull UUID uuid) {
        return this.playStates.get(uuid);
    }

    public void removePlayState(@NotNull UUID uuid) {
        this.playStates.remove(uuid);
    }

    public void setPlayState(@NotNull UUID uuid, @NotNull PlayState playState) {
        this.playStates.put(uuid, playState);
    }

    public boolean hasPlayingSong(@NotNull UUID uuid) {
        return this.getPlayState(uuid) != null;
    }

    public boolean hasPausedSong(@NotNull UUID uuid) {
        PlayState playState = this.getPlayState(uuid);
        return playState != null && playState.isPaused();
    }

    @Nullable
    public Song getPlayingSong(@NotNull UUID uuid) {
        PlayState playState = this.getPlayState(uuid);
        return playState != null ? playState.getSong() : null;
    }

    @Nullable
    public Song getNextSong(@NotNull Player player) {
        PlayState playState = this.getPlayState(player.getUniqueId());
        return playState != null ? this.getShuffleSong(player.getUniqueId(), playState.getSong()) : this.getRandomSong(player.getUniqueId());
    }

    public void stopSongs() {
        for (Map.Entry<UUID, PlayState> playState : this.playStates.entrySet()) {
            playState.getValue().getTimer().cancel();
            PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(playState.getKey());
            playSettings.setCurrentSong(null);
            Player player = Bukkit.getPlayer((UUID)playState.getKey());
            if (player == null || !this.gMusicMain.getConfigService().A_SHOW_MESSAGES) continue;
            this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-stop", new Object[0]);
        }
        this.playStates.clear();
    }

    public void stopSong(@NotNull Player player) {
        PlayState playState = this.getPlayState(player.getUniqueId());
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        this.playStates.remove(player.getUniqueId());
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
        playSettings.setCurrentSong(null);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-stop", new Object[0]);
        }
    }

    public void pauseSong(@NotNull Player player) {
        PlayState playState = this.getPlayState(player.getUniqueId());
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        playState.setPaused(true);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-pause", new Object[0]);
        }
    }

    public void resumeSong(@NotNull Player player) {
        PlayState playState = this.getPlayState(player.getUniqueId());
        if (playState == null) {
            return;
        }
        playState.setTimer(new Timer());
        playState.setPaused(false);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-resume", new Object[0]);
        }
        this.startSong(player, playState.getSong(), playState.getTimer());
    }
}

