/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.NotePart;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.PlayState;
import dev.geco.gmusic.model.Song;
import dev.geco.gmusic.model.gui.MusicGUI;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JukeBoxService {
    private final GMusicMain gMusicMain;
    private final NamespacedKey jukeBoxKey;
    private final HashMap<Block, UUID> jukeBoxBlocks = new HashMap();
    private final HashMap<UUID, Block> jukeBoxes = new HashMap();
    private final Random random = new Random();

    public JukeBoxService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
        this.jukeBoxKey = new NamespacedKey((Plugin)gMusicMain, "GMusic_juke_box");
    }

    public void createDataTables() {
        try {
            this.gMusicMain.getDataService().execute("CREATE TABLE IF NOT EXISTS gmusic_juke_box (uuid TEXT, world TEXT, x INTEGER, y INTEGER, z INTEGER);", new Object[0]);
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not create juke box database tables!", e);
        }
    }

    @NotNull
    public NamespacedKey getJukeBoxKey() {
        return this.jukeBoxKey;
    }

    @NotNull
    public ItemStack createJukeBoxItem() {
        ItemStack itemStack = new ItemStack(Material.JUKEBOX);
        itemStack.setAmount(1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("Items.jukebox-title", new Object[0]));
        itemMeta.setLore(List.of(this.gMusicMain.getMessageService().getMessage("Items.jukebox-description", new Object[0])));
        itemMeta.getPersistentDataContainer().set(this.jukeBoxKey, PersistentDataType.BOOLEAN, (Object)true);
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Nullable
    public UUID getJukeBoxId(Block block) {
        return this.jukeBoxBlocks.get(block);
    }

    @Nullable
    public Block getJukeBoxBlock(@NotNull UUID uuid) {
        return this.jukeBoxes.get(uuid);
    }

    public void addTemporaryJukeBoxBlock(@NotNull UUID uuid, @NotNull Block block) {
        this.jukeBoxes.put(uuid, block);
    }

    public void removeTemporaryJukeBoxBlock(@NotNull UUID uuid) {
        this.jukeBoxes.remove(uuid);
    }

    public void loadJukeboxes(@NotNull World world) {
        this.jukeBoxBlocks.clear();
        this.jukeBoxes.clear();
        this.gMusicMain.getTaskService().runDelayed(() -> {
            try (ResultSet jukeBoxData = this.gMusicMain.getDataService().executeAndGet("SELECT * FROM gmusic_juke_box", new Object[0]);){
                while (jukeBoxData.next()) {
                    String worldName = jukeBoxData.getString("world");
                    World jukeBoxWorld = Bukkit.getWorld((String)worldName);
                    if (jukeBoxWorld == null || world != null && world.equals((Object)jukeBoxWorld)) continue;
                    Location location = new Location(jukeBoxWorld, (double)jukeBoxData.getInt("x"), (double)jukeBoxData.getInt("y"), (double)jukeBoxData.getInt("z"));
                    UUID uuid = UUID.fromString(jukeBoxData.getString("uuid"));
                    Block block = location.getBlock();
                    if (block.getType() != Material.JUKEBOX) {
                        this.gMusicMain.getDataService().execute("DELETE FROM gmusic_juke_box WHERE uuid = ?", uuid.toString());
                        continue;
                    }
                    PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
                    this.jukeBoxBlocks.put(block, uuid);
                    this.jukeBoxes.put(uuid, block);
                    if (playSettings.getPlayListMode() == PlayListMode.RADIO) {
                        this.gMusicMain.getRadioService().addRadioJukeBox(uuid, block);
                    } else if (playSettings.isPlayOnJoin()) {
                        if (this.gMusicMain.getPlayService().hasPlayingSong(uuid)) {
                            this.resumeBoxSong(uuid);
                        } else {
                            Song song = playSettings.getCurrentSong() != null ? this.gMusicMain.getSongService().getSongById(playSettings.getCurrentSong()) : null;
                            this.playBoxSong(uuid, song != null ? song : this.gMusicMain.getPlayService().getRandomSong(uuid));
                        }
                    }
                    new MusicGUI(uuid, MusicGUI.MenuType.JUKEBOX);
                }
            }
            catch (Throwable e) {
                this.gMusicMain.getLogger().log(Level.SEVERE, "Could not load jukeboxes", e);
            }
        }, 0L);
    }

    public void setJukebox(@NotNull Block block) {
        try {
            UUID uuid = UUID.randomUUID();
            this.gMusicMain.getDataService().execute("INSERT INTO gmusic_juke_box (uuid, world, x, y, z) VALUES (?, ?, ?, ?, ?)", uuid.toString(), block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
            PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().generateDefaultPlaySettings(uuid);
            playSettings.setRange(this.gMusicMain.getConfigService().JUKEBOX_RANGE);
            if (playSettings.getPlayListMode() == PlayListMode.RADIO) {
                this.gMusicMain.getRadioService().addRadioJukeBox(uuid, block);
            }
            this.jukeBoxBlocks.put(block, uuid);
            this.jukeBoxes.put(uuid, block);
            new MusicGUI(uuid, MusicGUI.MenuType.JUKEBOX);
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not set jukebox", e);
        }
    }

    public void removeJukebox(@NotNull Block block) {
        UUID uuid = this.jukeBoxBlocks.get(block);
        if (uuid == null) {
            return;
        }
        this.stopBoxSong(uuid);
        this.gMusicMain.getPlaySettingsService().savePlaySettings(uuid, null);
        MusicGUI.getMusicGUI(uuid).close(true);
        this.gMusicMain.getRadioService().removeRadioJukeBox(uuid);
        this.jukeBoxBlocks.remove(block);
        this.jukeBoxes.remove(uuid);
        try {
            this.gMusicMain.getDataService().execute("DELETE FROM gmusic_juke_box WHERE uuid = ?", uuid.toString());
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not remove jukebox", e);
        }
    }

    public HashMap<Player, Double> getPlayersInRange(@NotNull Location location, long range) {
        HashMap<Player, Double> playerRangeMap = new HashMap<Player, Double>();
        try {
            for (Player player : location.getWorld().getPlayers()) {
                double distance = location.distance(player.getLocation());
                PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
                if (playSettings == null || !(distance <= (double)range) || playSettings.isToggleMode()) continue;
                playerRangeMap.put(player, distance);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return playerRangeMap;
    }

    public void playBoxSong(@NotNull UUID uuid, @Nullable Song song) {
        this.playBoxSong(uuid, song, 0L);
    }

    private void playBoxSong(@NotNull UUID uuid, @Nullable Song song, long delay) {
        Block block;
        if (song == null) {
            return;
        }
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        if (playState != null) {
            playState.getTimer().cancel();
        }
        Timer timer = new Timer();
        playState = new PlayState(song, timer, playSettings.isReverseMode() ? song.getLength() + delay : -delay);
        this.gMusicMain.getPlayService().setPlayState(uuid, playState);
        playSettings.setCurrentSong(song.getId());
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && (block = this.jukeBoxes.get(uuid)) != null) {
            for (Player player : this.getPlayersInRange(block.getLocation().add(0.5, 0.0, 0.5), playSettings.getRange()).keySet()) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
            }
        }
        this.playBoxTimer(uuid, song, timer);
    }

    private void playBoxTimer(final @NotNull UUID uuid, final @NotNull Song song, final @NotNull Timer timer) {
        final PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        final PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        Block block = this.jukeBoxes.get(uuid);
        if (block == null) {
            return;
        }
        final Location boxLocation = block.getLocation().add(0.5, 0.0, 0.5);
        final long[] ticker = new long[]{0L};
        timer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ JukeBoxService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                block12: {
                    HashMap<Player, Double> playersInRange;
                    long position;
                    block10: {
                        block13: {
                            block11: {
                                ticker[0] = ticker[0] + 1L;
                                position = playState.getTickPosition();
                                List<NotePart> noteParts = song.getContent().get(position);
                                playersInRange = this.this$0.getPlayersInRange(boxLocation, playSettings.getRange());
                                if (noteParts != null && playSettings.getVolume() > 0 && !playersInRange.isEmpty()) {
                                    if (playSettings.isShowingParticles()) {
                                        Location particleLocation = boxLocation.clone().add(this.this$0.random.nextDouble() - 0.5, 1.25, this.this$0.random.nextDouble() - 0.5);
                                        for (Player player : playersInRange.keySet()) {
                                            player.spawnParticle(Particle.NOTE, particleLocation, 0, this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), 1.0);
                                        }
                                    }
                                    for (NotePart notePart : noteParts) {
                                        for (Player player : playersInRange.keySet()) {
                                            if (notePart.getSound() != null) {
                                                Location location;
                                                float volume = (float)((playersInRange.get(player) - (double)playSettings.getRange()) * (double)playSettings.getFixedVolume() / (double)(-playSettings.getRange())) * notePart.getVolume();
                                                Location location2 = location = notePart.getDistance() == 0.0f ? player.getEyeLocation() : this.this$0.gMusicMain.getSteroNoteUtil().convertToStero(player.getEyeLocation(), notePart.getDistance());
                                                if (!this.this$0.gMusicMain.getConfigService().ENVIRONMENT_EFFECTS) {
                                                    player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                                    continue;
                                                }
                                                if (this.this$0.gMusicMain.getEnvironmentUtil().isPlayerSwimming(player)) {
                                                    player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume > 0.4f ? volume - 0.3f : volume, notePart.getPitch() - 0.15f);
                                                    continue;
                                                }
                                                player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                                continue;
                                            }
                                            if (notePart.getStopSound() == null) continue;
                                            player.stopSound(notePart.getStopSound(), song.getSoundCategory());
                                        }
                                    }
                                }
                                if (position != (playSettings.isReverseMode() ? 0L : song.getLength())) break block10;
                                if (playSettings.getPlayMode() != PlayMode.LOOP || playSettings.getPlayListMode() == PlayListMode.RADIO) break block11;
                                position = playSettings.isReverseMode() ? song.getLength() + (long)this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_REPEAT : (long)(-this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_REPEAT);
                                playState.setTickPosition(position);
                                break block12;
                            }
                            timer.cancel();
                            if (playSettings.getPlayMode() != PlayMode.SHUFFLE || playSettings.getPlayListMode() == PlayListMode.RADIO) break block13;
                            this.this$0.playBoxSong(uuid, this.this$0.gMusicMain.getPlayService().getShuffleSong(uuid, song), this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_SHUFFLE);
                            break block12;
                        }
                        this.this$0.gMusicMain.getPlayService().removePlayState(uuid);
                        MusicGUI m = MusicGUI.getMusicGUI(uuid);
                        if (m == null) break block12;
                        m.setPauseResumeBar();
                        break block12;
                    }
                    playState.setTickPosition(playSettings.isReverseMode() ? position - 1L : position + 1L);
                    if (this.this$0.gMusicMain.getConfigService().A_SHOW_WHILE_PLAYING && ticker[0] % 2000L == 0L) {
                        for (Player player : playersInRange.keySet()) {
                            this.this$0.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
                        }
                    }
                }
            }
        }, 0L, 1L);
    }

    @Nullable
    public Song getNextSong(@NotNull UUID uuid) {
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        return playState != null ? this.gMusicMain.getPlayService().getShuffleSong(uuid, playState.getSong()) : this.gMusicMain.getPlayService().getRandomSong(uuid);
    }

    public void stopBoxSong(@NotNull UUID uuid) {
        Block block;
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        this.gMusicMain.getPlayService().removePlayState(uuid);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        playSettings.setCurrentSong(null);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && (block = this.jukeBoxes.get(uuid)) != null) {
            for (Player player : this.getPlayersInRange(block.getLocation().add(0.5, 0.0, 0.5), playSettings.getRange()).keySet()) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-stop", new Object[0]);
            }
        }
    }

    public void pauseBoxSong(@NotNull UUID uuid) {
        Block block;
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        playState.setPaused(true);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && playSettings != null && (block = this.jukeBoxes.get(uuid)) != null) {
            for (Player player : this.getPlayersInRange(block.getLocation().add(0.5, 0.0, 0.5), playSettings.getRange()).keySet()) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-pause", new Object[0]);
            }
        }
    }

    public void resumeBoxSong(@NotNull UUID uuid) {
        Block block;
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(uuid);
        if (playState == null) {
            return;
        }
        playState.setTimer(new Timer());
        playState.setPaused(false);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && playSettings != null && (block = this.jukeBoxes.get(uuid)) != null) {
            for (Player player : this.getPlayersInRange(block.getLocation().add(0.5, 0.0, 0.5), playSettings.getRange()).keySet()) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-resume", new Object[0]);
            }
        }
        this.playBoxTimer(uuid, playState.getSong(), playState.getTimer());
    }
}

