/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.Song;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DiscService {
    private final GMusicMain gMusicMain;
    private final NamespacedKey discKey;

    public DiscService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
        this.discKey = new NamespacedKey((Plugin)gMusicMain, "GMusic_disc");
    }

    @NotNull
    public NamespacedKey getDiscKey() {
        return this.discKey;
    }

    @NotNull
    public ItemStack createDiscItem(@NotNull Song song) {
        ItemStack itemStack = new ItemStack(song.getDiscMaterial());
        itemStack.setAmount(1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("Items.disc-title", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor()));
        itemMeta.setLore(List.of(this.gMusicMain.getMessageService().getMessage("Items.disc-description", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor())));
        itemMeta.getPersistentDataContainer().set(this.discKey, PersistentDataType.STRING, (Object)song.getId());
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

