/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConfigurationOptions;

public class ConfigService {
    public String L_LANG;
    public boolean L_CLIENT_LANG;
    public boolean CHECK_FOR_UPDATE;
    public boolean S_EXTENDED_RANGE;
    public boolean S_FORCE_RESOURCES;
    public int JUKEBOX_RANGE;
    public int MAX_JUKEBOX_RANGE;
    public boolean A_SHOW_MESSAGES;
    public boolean A_SHOW_WHILE_PLAYING;
    public boolean R_ACTIVE;
    public boolean R_PLAY_ON_JOIN;
    public boolean ENVIRONMENT_EFFECTS;
    public boolean TRUSTED_REGION_ONLY;
    public List<String> WORLDBLACKLIST;
    public List<String> WORLDWHITELIST;
    public int PS_TIME_UNTIL_SHUFFLE;
    public int PS_TIME_UNTIL_REPEAT;
    public boolean PS_SAVE_ON_QUIT;
    public int PS_D_PLAYLIST_MODE;
    public int PS_D_VOLUME;
    public boolean PS_D_JOIN;
    public int PS_D_PLAY_MODE;
    public boolean PS_D_PARTICLES;
    public boolean PS_D_REVERSE;
    public boolean G_DISABLE_RANDOM_SONG;
    public boolean G_DISABLE_PLAYLIST;
    public boolean G_DISABLE_OPTIONS;
    public boolean G_DISABLE_SEARCH;
    private final GMusicMain gMusicMain;

    public ConfigService(GMusicMain gMusicMain) {
        block7: {
            this.WORLDBLACKLIST = new ArrayList<String>();
            this.WORLDWHITELIST = new ArrayList<String>();
            this.gMusicMain = gMusicMain;
            if (!gMusicMain.getVersionService().isNewerOrVersion(1, 18, 2)) {
                try {
                    File configFile = new File(gMusicMain.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    InputStream configSteam = gMusicMain.getResource("config.yml");
                    if (configSteam != null) {
                        YamlConfiguration configSteamConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(configSteam, StandardCharsets.UTF_8));
                        if (!config.getKeys(true).equals(configSteamConfig.getKeys(true))) {
                            config.setDefaults((Configuration)configSteamConfig);
                            YamlConfigurationOptions options = (YamlConfigurationOptions)config.options();
                            options.parseComments(true).copyDefaults(true).width(500);
                            config.loadFromString(config.saveToString());
                            for (String comments : config.getKeys(true)) {
                                config.setComments(comments, configSteamConfig.getComments(comments));
                            }
                            config.save(configFile);
                        }
                        break block7;
                    }
                    gMusicMain.saveDefaultConfig();
                }
                catch (Throwable e) {
                    gMusicMain.saveDefaultConfig();
                }
            } else {
                gMusicMain.saveDefaultConfig();
            }
        }
        this.reload();
    }

    public void reload() {
        this.gMusicMain.reloadConfig();
        this.L_LANG = this.gMusicMain.getConfig().getString("Lang.lang", "en_us").toLowerCase();
        this.L_CLIENT_LANG = this.gMusicMain.getConfig().getBoolean("Lang.client-lang", true);
        this.CHECK_FOR_UPDATE = this.gMusicMain.getConfig().getBoolean("Options.check-for-update", true);
        this.S_EXTENDED_RANGE = this.gMusicMain.getConfig().getBoolean("Options.Sound.extened-range", true);
        this.S_FORCE_RESOURCES = this.gMusicMain.getConfig().getBoolean("Options.Sound.force-resources", true);
        this.JUKEBOX_RANGE = this.gMusicMain.getConfig().getInt("Options.jukebox-range", 50);
        this.MAX_JUKEBOX_RANGE = this.gMusicMain.getConfig().getInt("Options.max-jukebox-range", 500);
        this.A_SHOW_MESSAGES = this.gMusicMain.getConfig().getBoolean("Options.ActionBar.show-messages", true);
        this.A_SHOW_WHILE_PLAYING = this.gMusicMain.getConfig().getBoolean("Options.ActionBar.show-while-playing", true);
        this.R_ACTIVE = this.gMusicMain.getConfig().getBoolean("Options.Radio.active", true);
        this.R_PLAY_ON_JOIN = this.gMusicMain.getConfig().getBoolean("Options.Radio.play-on-join", false);
        this.ENVIRONMENT_EFFECTS = this.gMusicMain.getConfig().getBoolean("Options.environment-effects", true);
        this.TRUSTED_REGION_ONLY = this.gMusicMain.getConfig().getBoolean("Options.trusted-region-only", true);
        this.WORLDBLACKLIST = this.gMusicMain.getConfig().getStringList("Options.WorldBlacklist");
        this.WORLDWHITELIST = this.gMusicMain.getConfig().getStringList("Options.WorldWhitelist");
        this.PS_TIME_UNTIL_SHUFFLE = this.gMusicMain.getConfig().getInt("Options.PlayerSettings.time-until-shuffle", 1000);
        this.PS_TIME_UNTIL_REPEAT = this.gMusicMain.getConfig().getInt("Options.PlayerSettings.time-until-repeat", 1000);
        this.PS_SAVE_ON_QUIT = this.gMusicMain.getConfig().getBoolean("Options.PlayerSettings.save-on-quit", true);
        this.PS_D_PLAYLIST_MODE = this.gMusicMain.getConfig().getInt("Options.PlayerSettings.Default.playlist-mode", 0);
        this.PS_D_VOLUME = this.gMusicMain.getConfig().getInt("Options.PlayerSettings.Default.volume", 70);
        this.PS_D_JOIN = this.gMusicMain.getConfig().getBoolean("Options.PlayerSettings.Default.join", false);
        this.PS_D_PLAY_MODE = this.gMusicMain.getConfig().getInt("Options.PlayerSettings.Default.play-mode", 0);
        this.PS_D_PARTICLES = this.gMusicMain.getConfig().getBoolean("Options.PlayerSettings.Default.particles", false);
        this.PS_D_REVERSE = this.gMusicMain.getConfig().getBoolean("Options.PlayerSettings.Default.reverse", false);
        this.G_DISABLE_RANDOM_SONG = this.gMusicMain.getConfig().getBoolean("Options.GUI.disable-random-song", false);
        this.G_DISABLE_PLAYLIST = this.gMusicMain.getConfig().getBoolean("Options.GUI.disable-playlist", false);
        this.G_DISABLE_OPTIONS = this.gMusicMain.getConfig().getBoolean("Options.GUI.disable-options", false);
        this.G_DISABLE_SEARCH = this.gMusicMain.getConfig().getBoolean("Options.GUI.disable-search", false);
    }
}

