/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.model;

import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.Song;
import java.util.List;
import java.util.UUID;

public class PlaySettings {
    private final UUID uuid;
    private PlayListMode playlistMode;
    private int volume;
    private boolean playOnJoin;
    private PlayMode playMode;
    private boolean showParticles;
    private boolean reverseMode;
    private boolean toggleMode;
    private long range;
    private String currentSong;
    private List<Song> favorites;

    public PlaySettings(UUID uuid, PlayListMode playlistMode, int volume, boolean playOnJoin, PlayMode playMode, boolean showParticles, boolean reverseMode, boolean toggleMode, long range, String currentSong, List<Song> favorites) {
        this.uuid = uuid;
        this.playlistMode = playlistMode;
        this.volume = volume;
        this.playOnJoin = playOnJoin;
        this.playMode = playMode;
        this.showParticles = showParticles;
        this.reverseMode = reverseMode;
        this.toggleMode = toggleMode;
        this.range = range;
        this.currentSong = currentSong;
        this.favorites = favorites;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public PlayListMode getPlayListMode() {
        return this.playlistMode;
    }

    public void setPlayListMode(PlayListMode playlistMode) {
        this.playlistMode = playlistMode;
    }

    public int getVolume() {
        return this.volume;
    }

    public float getFixedVolume() {
        return (float)(this.volume * 2) / 100.0f;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public boolean isPlayOnJoin() {
        return this.playOnJoin;
    }

    public void setPlayOnJoin(boolean playOnJoin) {
        this.playOnJoin = playOnJoin;
    }

    public PlayMode getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(PlayMode playMode) {
        this.playMode = playMode;
    }

    public boolean isShowingParticles() {
        return this.showParticles;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public boolean isReverseMode() {
        return this.reverseMode;
    }

    public void setReverseMode(boolean reverseMode) {
        this.reverseMode = reverseMode;
    }

    public boolean isToggleMode() {
        return this.toggleMode;
    }

    public void setToggleMode(boolean toggleMode) {
        this.toggleMode = toggleMode;
    }

    public long getRange() {
        return this.range;
    }

    public void setRange(long range) {
        this.range = range;
    }

    public String getCurrentSong() {
        return this.currentSong;
    }

    public void setCurrentSong(String currentSong) {
        this.currentSong = currentSong;
    }

    public List<Song> getFavorites() {
        return this.favorites;
    }

    public void setFavorites(List<Song> favorites) {
        this.favorites = favorites;
    }

    public void addFavoriteSong(Song song) {
        this.favorites.add(song);
    }

    public void removeFavoriteSong(Song song) {
        this.favorites.remove(song);
    }
}

