/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.model;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.Note;

public class NotePart {
    private static final String PARTS = ":";
    private static final String VAR = "";
    private static final String KEYFLOAT = "#";
    private static final String STOP = "-";
    private final Note note;
    private String sound;
    private String stopSound;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private int originalPitch = 12;
    private float distance = 0.0f;

    public NotePart(Note note, String notePartString) {
        this.note = note;
        String[] parts = notePartString.split(PARTS);
        if (!parts[0].startsWith(STOP)) {
            this.sound = this.note.getSong().getInstruments().get(parts[0]);
        } else {
            this.stopSound = this.note.getSong().getInstruments().get(parts[0].replace(STOP, VAR));
        }
        if (this.sound == null || this.stopSound != null) {
            return;
        }
        if (parts.length == 1 || parts[1].equals(VAR)) {
            this.volume = 1.0f;
        } else {
            try {
                this.volume = Float.parseFloat(parts[1]) / 100.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parts.length > 2 && !parts[2].equals(VAR)) {
            if (parts[2].contains(KEYFLOAT)) {
                int noteKey = Integer.parseInt(parts[2].replace(KEYFLOAT, VAR));
                this.pitch = this.getPitch(noteKey);
                this.originalPitch = this.getOriginalPitch(noteKey);
                if (GMusicMain.getInstance().getConfigService().S_EXTENDED_RANGE) {
                    if (this.originalPitch >= 24) {
                        this.sound = this.sound + "_1";
                    } else if (this.originalPitch < 0) {
                        this.sound = this.sound + "_-1";
                    }
                }
            } else {
                try {
                    this.pitch = Float.parseFloat(parts[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (parts.length > 3) {
            this.distance = (float)(Integer.parseInt(parts[3]) - 100) / 200.0f * 2.0f;
        }
    }

    private float getPitch(int note) {
        if (!GMusicMain.getInstance().getConfigService().S_EXTENDED_RANGE) {
            if (note < 0) {
                return 0.5f;
            }
            if (note > 24) {
                return 2.0f;
            }
            return (float)Math.pow(2.0, (float)(note - 12) / 12.0f);
        }
        note = note < -24 ? 36 + note : (note < 0 ? 24 + note : (note < 48 ? (note %= 24) : 12 + note % 24));
        return (float)Math.pow(2.0, (float)(note - 12) / 12.0f);
    }

    private int getOriginalPitch(int note) {
        if (!GMusicMain.getInstance().getConfigService().S_EXTENDED_RANGE) {
            if (note < 0) {
                return 0;
            }
            return Math.min(note, 24);
        }
        if (note < 0) {
            if (note < -24) {
                note = -24;
            }
            return note;
        }
        if (note > 48) {
            note = 48;
        }
        return note;
    }

    public Note getNote() {
        return this.note;
    }

    public String getSound() {
        return this.sound;
    }

    public String getStopSound() {
        return this.stopSound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getOriginalPitch() {
        return this.originalPitch;
    }

    public float getDistance() {
        return this.distance;
    }
}

