/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.model;

import dev.geco.gmusic.model.NotePart;
import dev.geco.gmusic.model.Song;
import java.util.ArrayList;
import java.util.List;

public class Note {
    private static final String DELAY = "!";
    private static final String TICKDELAY = "t";
    private static final String AMOUNT = ";";
    private static final String REF = "?";
    private static final String PARTS = "_";
    private final Song song;
    private long delay = 0L;
    private long amount = 1L;
    private final List<NotePart> parts = new ArrayList<NotePart>();
    private List<Note> references = new ArrayList<Note>();

    public Note(Song song, String noteString) {
        this.song = song;
        if (noteString.contains(DELAY)) {
            try {
                this.delay = (long)(noteString.contains(TICKDELAY) ? 50 : 1) * Long.parseLong(noteString.split(DELAY)[0].replace(TICKDELAY, ""));
                if (this.delay < 0L) {
                    this.delay = 0L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            noteString = noteString.split(DELAY)[1];
        }
        if (noteString.contains(AMOUNT)) {
            try {
                long nodeAmount = Long.parseLong(noteString.split(AMOUNT)[1]);
                if (nodeAmount > 0L) {
                    this.amount += nodeAmount;
                }
            }
            catch (NumberFormatException nodeAmount) {
                // empty catch block
            }
            noteString = noteString.split(AMOUNT)[0];
        }
        if (noteString.startsWith(REF)) {
            List<Note> noteReferences = this.song.getParts().get(noteString.replace(REF, ""));
            if (noteReferences != null) {
                this.references = noteReferences;
            }
        } else {
            for (String i : noteString.split(PARTS)) {
                this.parts.add(new NotePart(this, i));
            }
        }
    }

    public Song getSong() {
        return this.song;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getAmount() {
        return this.amount;
    }

    public List<NotePart> getNoteParts() {
        return this.parts;
    }

    public List<Note> getReferences() {
        return this.references;
    }

    public boolean isReference() {
        return !this.references.isEmpty();
    }
}

