/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.mcv.v1_18_2.model.gui;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.api.event.GMusicReloadEvent;
import dev.geco.gmusic.model.gui.MusicInputGUI;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MusicInputGUI
implements dev.geco.gmusic.model.gui.MusicInputGUI {
    protected final GMusicMain gMusicMain = GMusicMain.getInstance();
    private Inventory inventory;
    private final Listener listener;
    private String input;

    public MusicInputGUI(final MusicInputGUI.InputCallback call, final MusicInputGUI.ValidateCallback validateCall) {
        this.listener = new Listener(){

            @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
            public void inventoryClickEvent(InventoryClickEvent event) {
                if (!event.getInventory().equals((Object)MusicInputGUI.this.inventory)) {
                    return;
                }
                event.setCancelled(true);
                if (event.getRawSlot() != 2) {
                    return;
                }
                if (event.getCurrentItem() == null) {
                    return;
                }
                boolean success = call.call(MusicInputGUI.this.input);
                if (!success) {
                    return;
                }
                MusicInputGUI.this.close(true);
            }

            @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
            public void PAnvE(PrepareAnvilEvent Event2) {
                if (!Event2.getInventory().equals((Object)MusicInputGUI.this.inventory)) {
                    return;
                }
                ItemStack result = Event2.getResult();
                if (result == null || !result.hasItemMeta()) {
                    return;
                }
                ItemMeta itemMeta = result.getItemMeta();
                if (itemMeta == null) {
                    return;
                }
                String newInput = itemMeta.getDisplayName();
                if (validateCall != null && (newInput = validateCall.call(itemMeta)) == null) {
                    Event2.setResult(null);
                    return;
                }
                MusicInputGUI.this.input = newInput;
                result.setItemMeta(itemMeta);
                Event2.setResult(result);
            }

            @EventHandler
            public void inventoryCloseEvent(InventoryCloseEvent event) {
                if (event.getInventory().equals((Object)MusicInputGUI.this.inventory)) {
                    MusicInputGUI.this.close(false);
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void gMusicReloadEvent(GMusicReloadEvent event) {
                if (event.getPlugin().equals((Object)MusicInputGUI.this.gMusicMain)) {
                    MusicInputGUI.this.close(true);
                }
            }

            @EventHandler
            public void pluginDisableEvent(PluginDisableEvent event) {
                if (event.getPlugin().equals((Object)MusicInputGUI.this.gMusicMain)) {
                    MusicInputGUI.this.close(true);
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gMusicMain);
    }

    @Override
    public void open(LivingEntity entity, String title, ItemStack inputItem) {
        if (!(entity instanceof Player)) {
            return;
        }
        EntityPlayer player = ((CraftPlayer)entity).getHandle();
        int containerId = player.nextContainerCounter();
        ContainerAnvil anvilMenu = new ContainerAnvil(containerId, player.fr(), ContainerAccess.a((World)player.s, (BlockPosition)player.cW()));
        anvilMenu.checkReachable = false;
        anvilMenu.maximumRepairCost = 0;
        IChatBaseComponent titleComponent = CraftChatMessage.fromString((String)title)[0];
        anvilMenu.setTitle(titleComponent);
        if (inputItem.hasItemMeta() && inputItem.getItemMeta() != null) {
            this.input = inputItem.getItemMeta().getDisplayName();
            this.inventory = (Inventory)this.gMusicMain.getVersionService().executeMethod(this.gMusicMain.getVersionService().executeMethod(anvilMenu, "getBukkitView"), "getTopInventory");
            this.inventory.setItem(0, inputItem);
        }
        PacketPlayOutOpenWindow clientboundOpenScreenPacket = new PacketPlayOutOpenWindow(containerId, Containers.h, titleComponent);
        player.b.a((Packet)clientboundOpenScreenPacket);
        player.bV = anvilMenu;
        player.a((Container)anvilMenu);
    }

    @Override
    public void close(boolean force) {
        HandlerList.unregisterAll((Listener)this.listener);
        if (this.inventory == null) {
            return;
        }
        this.inventory.clear();
        if (force) {
            for (HumanEntity entity : new ArrayList(this.inventory.getViewers())) {
                entity.closeInventory();
            }
        }
    }
}

