/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.event;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.Song;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerEventHandler
implements Listener {
    private static final String RESOURCE_PACK_URL = "https://github.com/gecolay/GMusic/raw/main/resources/resource_pack/note_block_extended_octave_range.zip";
    private final GMusicMain gMusicMain;

    public PlayerEventHandler(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        this.gMusicMain.getUpdateService().checkForUpdates(player);
        if (this.gMusicMain.getConfigService().S_EXTENDED_RANGE && this.gMusicMain.getConfigService().S_FORCE_RESOURCES) {
            player.setResourcePack(RESOURCE_PACK_URL, "null", true);
        }
        if (!this.gMusicMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            return;
        }
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(playerUuid);
        if (this.gMusicMain.getConfigService().R_PLAY_ON_JOIN) {
            playSettings.setPlayListMode(PlayListMode.RADIO);
        }
        if (playSettings.getPlayListMode() == PlayListMode.RADIO) {
            this.gMusicMain.getRadioService().addRadioPlayer(player);
        } else if (playSettings.isPlayOnJoin()) {
            if (this.gMusicMain.getPlayService().hasPlayingSong(playerUuid)) {
                this.gMusicMain.getPlayService().resumeSong(player);
            } else {
                Song song = playSettings.getCurrentSong() != null ? this.gMusicMain.getSongService().getSongById(playSettings.getCurrentSong()) : null;
                this.gMusicMain.getPlayService().playSong(player, song != null ? song : this.gMusicMain.getPlayService().getRandomSong(playerUuid));
            }
        }
    }

    @EventHandler
    public void playerChangedWorldEvent(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(playerUuid);
        if (!this.gMusicMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            this.gMusicMain.getPlayService().stopSong(player);
            this.gMusicMain.getRadioService().removeRadioPlayer(player);
            return;
        }
        if (playSettings.getPlayListMode() == PlayListMode.RADIO) {
            this.gMusicMain.getRadioService().addRadioPlayer(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.gMusicMain.getRadioService().removeRadioPlayer(player);
        if (this.gMusicMain.getConfigService().PS_SAVE_ON_QUIT) {
            this.gMusicMain.getPlaySettingsService().savePlaySettings(player.getUniqueId(), this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId()));
        }
        this.gMusicMain.getPlaySettingsService().removePlaySettingsCache(player.getUniqueId());
    }
}

