/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.event;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.gui.MusicGUI;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class JukeBoxEventHandler
implements Listener {
    private final GMusicMain gMusicMain;

    public JukeBoxEventHandler(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || player.isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.JUKEBOX) {
            return;
        }
        UUID uuid = this.gMusicMain.getJukeBoxService().getJukeBoxId(block);
        if (uuid == null) {
            return;
        }
        event.setCancelled(true);
        if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)player, "JukeBox")) {
            return;
        }
        if (!this.gMusicMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            return;
        }
        if (!this.gMusicMain.getEnvironmentUtil().canUseJukeboxInLocation(block.getLocation(), player)) {
            return;
        }
        if (!player.isSneaking()) {
            player.openInventory(MusicGUI.getMusicGUI(uuid).getInventory());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void blockPlaceEvent(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.JUKEBOX) {
            return;
        }
        ItemStack itemStack = event.getItemInHand();
        if (!itemStack.getItemMeta().getPersistentDataContainer().has(this.gMusicMain.getJukeBoxService().getJukeBoxKey())) {
            return;
        }
        this.gMusicMain.getJukeBoxService().setJukebox(block);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void blockBreakEvent(BlockBreakEvent event) {
        this.handleBlockBreak(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void blockExplodeEvent(BlockExplodeEvent event) {
        for (Block block : event.blockList()) {
            this.handleBlockBreak(block);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void entityExplodeEvent(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            this.handleBlockBreak(block);
        }
    }

    private void handleBlockBreak(Block block) {
        if (block.getType() != Material.JUKEBOX) {
            return;
        }
        if (this.gMusicMain.getJukeBoxService().getJukeBoxId(block) == null) {
            return;
        }
        this.gMusicMain.getJukeBoxService().removeJukebox(block);
        block.setType(Material.AIR);
        block.getWorld().dropItemNaturally(block.getLocation().add(0.5, 0.0, 0.5), this.gMusicMain.getJukeBoxService().createJukeBoxItem());
    }
}

