/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.event;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.Song;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;

public class DiscEventHandler
implements Listener {
    private final GMusicMain gMusicMain;

    public DiscEventHandler(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || player.isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.JUKEBOX) {
            return;
        }
        if (this.gMusicMain.getJukeBoxService().getJukeBoxId(block) != null) {
            return;
        }
        Jukebox jukebox = (Jukebox)block.getState();
        ItemStack record = jukebox.getRecord();
        if (record.getType() == Material.AIR) {
            ItemStack item = event.getItem();
            if (item == null) {
                return;
            }
            if (!item.getItemMeta().getPersistentDataContainer().has(this.gMusicMain.getDiscService().getDiscKey())) {
                return;
            }
            String songId = (String)item.getItemMeta().getPersistentDataContainer().get(this.gMusicMain.getDiscService().getDiscKey(), PersistentDataType.STRING);
            if (songId == null) {
                return;
            }
            event.setCancelled(true);
            if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)player, "Disc")) {
                return;
            }
            if (!this.gMusicMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
                return;
            }
            Song song = this.gMusicMain.getSongService().getSongById(songId);
            if (song == null) {
                return;
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
            UUID uuid = UUID.randomUUID();
            PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().generateDefaultPlaySettings(uuid);
            playSettings.setRange(this.gMusicMain.getConfigService().JUKEBOX_RANGE);
            playSettings.setPlayMode(PlayMode.DEFAULT);
            playSettings.setShowParticles(true);
            this.gMusicMain.getJukeBoxService().addTemporaryJukeBoxBlock(uuid, block);
            this.gMusicMain.getJukeBoxService().playBoxSong(uuid, song);
            ItemStack placeholder = new ItemStack(Material.STICK);
            ItemMeta itemMeta = placeholder.getItemMeta();
            itemMeta.setDisplayName(uuid.toString());
            itemMeta.getPersistentDataContainer().set(this.gMusicMain.getDiscService().getDiscKey(), PersistentDataType.STRING, (Object)songId);
            placeholder.setItemMeta(itemMeta);
            jukebox.setRecord(placeholder);
            jukebox.update(false, false);
        } else {
            this.handleRecordEject(jukebox, record);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void blockBreakEvent(BlockBreakEvent event) {
        this.handleBlockBreak(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void blockExplodeEvent(BlockExplodeEvent event) {
        for (Block block : event.blockList()) {
            this.handleBlockBreak(block);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void entityExplodeEvent(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            this.handleBlockBreak(block);
        }
    }

    private void handleBlockBreak(Block block) {
        if (block.getType() != Material.JUKEBOX) {
            return;
        }
        Jukebox jukebox = (Jukebox)block.getState();
        ItemStack record = jukebox.getRecord();
        if (record.getType() == Material.AIR) {
            return;
        }
        this.handleRecordEject(jukebox, record);
    }

    private void handleRecordEject(Jukebox jukebox, ItemStack record) {
        if (!record.getItemMeta().getPersistentDataContainer().has(this.gMusicMain.getDiscService().getDiscKey())) {
            return;
        }
        String songId = (String)record.getItemMeta().getPersistentDataContainer().get(this.gMusicMain.getDiscService().getDiscKey(), PersistentDataType.STRING);
        if (songId == null) {
            return;
        }
        try {
            UUID uuid = UUID.fromString(record.getItemMeta().getDisplayName());
            this.gMusicMain.getJukeBoxService().removeTemporaryJukeBoxBlock(uuid);
            this.gMusicMain.getJukeBoxService().stopBoxSong(uuid);
            this.gMusicMain.getPlaySettingsService().removePlaySettingsCache(uuid);
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        jukebox.setRecord(null);
        jukebox.update(false, false);
        Song song = this.gMusicMain.getSongService().getSongById(songId);
        if (song == null) {
            return;
        }
        Location dropLocation = jukebox.getLocation().add(0.5, 1.01, 0.5);
        jukebox.getWorld().dropItem(dropLocation, this.gMusicMain.getDiscService().createDiscItem(song));
    }
}

