/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.cmd.tab;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.Song;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GAdminMusicTabComplete
implements TabCompleter {
    private final GMusicMain gMusicMain;

    public GAdminMusicTabComplete(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        ArrayList<String> complete = new ArrayList<String>();
        ArrayList<String> completeStarted = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return complete;
        }
        if (args.length == 1) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic", "AdminMusic.*")) {
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.JukeBox", "AdminMusic.*")) {
                    complete.add("jukebox");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Disc", "AdminMusic.*")) {
                    complete.add("disc");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Download", "AdminMusic.*")) {
                    complete.add("download");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Radio", "AdminMusic.*")) {
                    complete.add("radio");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Edit", "AdminMusic.*")) {
                    complete.add("edit");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Play", "AdminMusic.*")) {
                    complete.add("play");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Playing", "AdminMusic.*")) {
                    complete.add("playing");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Random", "AdminMusic.*")) {
                    complete.add("random");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Stop", "AdminMusic.*")) {
                    complete.add("stop");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Pause", "AdminMusic.*")) {
                    complete.add("pause");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Resume", "AdminMusic.*")) {
                    complete.add("resume");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Skip", "AdminMusic.*")) {
                    complete.add("skip");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic.Toggle", "AdminMusic.*")) {
                    complete.add("toggle");
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        } else if (args.length == 2) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic", "AdminMusic.*") && this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic." + args[0], "AdminMusic.*")) {
                switch (args[0].toLowerCase()) {
                    case "jukebox": 
                    case "play": 
                    case "playing": 
                    case "random": 
                    case "stop": 
                    case "pause": 
                    case "resume": 
                    case "skip": 
                    case "toggle": {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            complete.add(player.getName());
                        }
                        break;
                    }
                    case "disc": 
                    case "edit": {
                        for (Song song : this.gMusicMain.getSongService().getSongs()) {
                            complete.add(song.getId());
                        }
                        break;
                    }
                    case "download": {
                        complete.add("gnbs");
                        complete.add("nbs");
                        complete.add("mid");
                        complete.add("midi");
                    }
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        } else if (args.length == 3) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic", "AdminMusic.*") && this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic." + args[0], "AdminMusic.*")) {
                if (args[0].equalsIgnoreCase("disc")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        complete.add(player.getName());
                    }
                } else if (args[0].equalsIgnoreCase("edit")) {
                    complete.add("id");
                    complete.add("title");
                    complete.add("original_author");
                    complete.add("author");
                    complete.add("description");
                    complete.add("category");
                } else if (args[0].equalsIgnoreCase("play")) {
                    for (Song song : this.gMusicMain.getSongService().getSongs()) {
                        complete.add(song.getId());
                    }
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        } else if (args.length == 4) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic", "AdminMusic.*") && this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "AdminMusic." + args[0], "AdminMusic.*") && args[0].equalsIgnoreCase("edit") && args[2].equalsIgnoreCase("category")) {
                for (SoundCategory category : SoundCategory.values()) {
                    complete.add(category.name().toLowerCase());
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        }
        return complete.isEmpty() ? completeStarted : complete;
    }
}

