/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic;

import dev.geco.gmusic.api.event.GMusicLoadedEvent;
import dev.geco.gmusic.api.event.GMusicReloadEvent;
import dev.geco.gmusic.cmd.GAdminMusicCommand;
import dev.geco.gmusic.cmd.GMusicCommand;
import dev.geco.gmusic.cmd.GMusicReloadCommand;
import dev.geco.gmusic.cmd.tab.EmptyTabComplete;
import dev.geco.gmusic.cmd.tab.GAdminMusicTabComplete;
import dev.geco.gmusic.cmd.tab.GMusicTabComplete;
import dev.geco.gmusic.event.DiscEventHandler;
import dev.geco.gmusic.event.JukeBoxEventHandler;
import dev.geco.gmusic.event.PlayerEventHandler;
import dev.geco.gmusic.link.GriefPreventionLink;
import dev.geco.gmusic.link.PlaceholderAPILink;
import dev.geco.gmusic.link.PlotSquaredLink;
import dev.geco.gmusic.link.WorldGuardLink;
import dev.geco.gmusic.metric.BStatsMetric;
import dev.geco.gmusic.service.ConfigService;
import dev.geco.gmusic.service.DataService;
import dev.geco.gmusic.service.DiscService;
import dev.geco.gmusic.service.JukeBoxService;
import dev.geco.gmusic.service.MessageService;
import dev.geco.gmusic.service.PermissionService;
import dev.geco.gmusic.service.PlayService;
import dev.geco.gmusic.service.PlaySettingsService;
import dev.geco.gmusic.service.RadioService;
import dev.geco.gmusic.service.SongService;
import dev.geco.gmusic.service.TaskService;
import dev.geco.gmusic.service.UpdateService;
import dev.geco.gmusic.service.VersionService;
import dev.geco.gmusic.service.converter.MidiConverter;
import dev.geco.gmusic.service.converter.NBSConverter;
import dev.geco.gmusic.service.message.PaperMessageService;
import dev.geco.gmusic.service.message.SpigotMessageService;
import dev.geco.gmusic.util.EnvironmentUtil;
import dev.geco.gmusic.util.SteroNoteUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GMusicMain
extends JavaPlugin {
    public static final String NAME = "GMusic";
    public static final String RESOURCE_ID = "84004";
    private final int BSTATS_RESOURCE_ID = 4925;
    private static GMusicMain gMusicMain;
    private VersionService versionService;
    private ConfigService configService;
    private MessageService messageService;
    private UpdateService updateService;
    private PermissionService permissionService;
    private TaskService taskService;
    private DataService dataService;
    private SongService songService;
    private PlayService playService;
    private PlaySettingsService playSettingsService;
    private JukeBoxService jukeBoxService;
    private DiscService discService;
    private RadioService radioService;
    private MidiConverter midiConverter;
    private NBSConverter nbsConverter;
    private EnvironmentUtil environmentUtil;
    private SteroNoteUtil steroNoteUtil;
    private GriefPreventionLink griefPreventionLink;
    private PlaceholderAPILink placeholderAPILink;
    private PlotSquaredLink plotSquaredLink;
    private WorldGuardLink worldGuardLink;
    private BStatsMetric bStatsMetric;
    private boolean supportsTaskFeature = false;
    private boolean isPaperServer = false;
    private boolean isFoliaServer = false;

    public static GMusicMain getInstance() {
        return gMusicMain;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public SongService getSongService() {
        return this.songService;
    }

    public PlayService getPlayService() {
        return this.playService;
    }

    public PlaySettingsService getPlaySettingsService() {
        return this.playSettingsService;
    }

    public JukeBoxService getJukeBoxService() {
        return this.jukeBoxService;
    }

    public DiscService getDiscService() {
        return this.discService;
    }

    public RadioService getRadioService() {
        return this.radioService;
    }

    public MidiConverter getMidiConverter() {
        return this.midiConverter;
    }

    public NBSConverter getNBSConverter() {
        return this.nbsConverter;
    }

    public EnvironmentUtil getEnvironmentUtil() {
        return this.environmentUtil;
    }

    public SteroNoteUtil getSteroNoteUtil() {
        return this.steroNoteUtil;
    }

    public GriefPreventionLink getGriefPreventionLink() {
        return this.griefPreventionLink;
    }

    public PlaceholderAPILink getPlaceholderAPILink() {
        return this.placeholderAPILink;
    }

    public PlotSquaredLink getPlotSquaredLink() {
        return this.plotSquaredLink;
    }

    public WorldGuardLink getWorldGuardLink() {
        return this.worldGuardLink;
    }

    public boolean supportsTaskFeature() {
        return this.supportsTaskFeature;
    }

    public boolean isPaperServer() {
        return this.isPaperServer;
    }

    public boolean isFoliaServer() {
        return this.isFoliaServer;
    }

    public void onLoad() {
        gMusicMain = this;
        this.versionService = new VersionService(this);
        this.configService = new ConfigService(this);
        this.updateService = new UpdateService(this);
        this.permissionService = new PermissionService();
        this.taskService = new TaskService(this);
        this.dataService = new DataService(this);
        this.songService = new SongService(this);
        this.playService = new PlayService(this);
        this.playSettingsService = new PlaySettingsService(this);
        this.jukeBoxService = new JukeBoxService(this);
        this.discService = new DiscService(this);
        this.radioService = new RadioService(this);
        this.midiConverter = new MidiConverter(this);
        this.nbsConverter = new NBSConverter(this);
        this.environmentUtil = new EnvironmentUtil(this);
        this.steroNoteUtil = new SteroNoteUtil();
        this.loadFeatures();
        this.messageService = this.isPaperServer && this.versionService.isNewerOrVersion(1, 18, 2) ? new PaperMessageService(this) : new SpigotMessageService(this);
    }

    public void onEnable() {
        if (!this.versionCheck()) {
            return;
        }
        this.loadPluginDependencies();
        this.loadSettings((CommandSender)Bukkit.getConsoleSender());
        this.setupCommands();
        this.setupEvents();
        this.setupBStatsMetric();
        Bukkit.getPluginManager().callEvent((Event)new GMusicLoadedEvent(this));
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-enabled", new Object[0]);
        this.printPluginLinks((CommandSender)Bukkit.getConsoleSender());
        this.updateService.checkForUpdates();
    }

    public void onDisable() {
        this.unload();
        if (this.bStatsMetric != null) {
            this.bStatsMetric.shutdown();
        }
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-disabled", new Object[0]);
    }

    private void loadSettings(CommandSender sender) {
        if (!this.connectDatabase(sender)) {
            return;
        }
        this.songService.loadSongs();
        this.playSettingsService.createDataTables();
        this.jukeBoxService.createDataTables();
        this.jukeBoxService.loadJukeboxes(null);
        if (this.configService.R_ACTIVE) {
            this.radioService.startRadio();
        }
    }

    public void reload(CommandSender sender) {
        GMusicReloadEvent reloadEvent = new GMusicReloadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)reloadEvent);
        if (reloadEvent.isCancelled()) {
            return;
        }
        this.unload();
        this.configService.reload();
        this.messageService.loadMessages();
        this.loadPluginDependencies();
        this.loadSettings(sender);
        this.printPluginLinks(sender);
        this.updateService.checkForUpdates();
        Bukkit.getPluginManager().callEvent((Event)new GMusicLoadedEvent(this));
    }

    private void unload() {
        this.dataService.close();
        this.playService.stopSongs();
        this.radioService.stopRadio();
        this.songService.unloadSongs();
        this.playSettingsService.savePlaySettings();
        if (this.placeholderAPILink != null) {
            this.placeholderAPILink.unregister();
        }
        if (this.worldGuardLink != null) {
            this.worldGuardLink.unregisterFlagHandlers();
        }
    }

    private void setupCommands() {
        this.getCommand("gmusic").setExecutor((CommandExecutor)new GMusicCommand(this));
        this.getCommand("gmusic").setTabCompleter((TabCompleter)new GMusicTabComplete(this));
        this.getCommand("gmusic").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gadminmusic").setExecutor((CommandExecutor)new GAdminMusicCommand(this));
        this.getCommand("gadminmusic").setTabCompleter((TabCompleter)new GAdminMusicTabComplete(this));
        this.getCommand("gadminmusic").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gmusicreload").setExecutor((CommandExecutor)new GMusicReloadCommand(this));
        this.getCommand("gmusicreload").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gmusicreload").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
    }

    private void setupEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JukeBoxEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DiscEventHandler(this), (Plugin)this);
    }

    private boolean versionCheck() {
        if (this.versionService.isNewerOrVersion(1, 13)) {
            return true;
        }
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-version", "%Version%", Bukkit.getServer().getVersion());
        this.updateService.checkForUpdates();
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private boolean connectDatabase(CommandSender sender) {
        boolean connected = this.dataService.connect();
        if (connected) {
            return true;
        }
        this.messageService.sendMessage(sender, "Plugin.plugin-data", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private void loadFeatures() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            this.supportsTaskFeature = true;
        }
        catch (ClassNotFoundException e) {
            this.supportsTaskFeature = false;
        }
        try {
            Class.forName("io.papermc.paper.event.entity.EntityMoveEvent");
            this.isPaperServer = true;
        }
        catch (ClassNotFoundException e) {
            this.isPaperServer = false;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
            this.isFoliaServer = true;
        }
        catch (ClassNotFoundException e) {
            this.isFoliaServer = false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardLink = new WorldGuardLink();
            this.worldGuardLink.registerFlags();
        }
    }

    private void loadPluginDependencies() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("GriefPrevention");
        this.griefPreventionLink = plugin != null && plugin.isEnabled() && this.configService.TRUSTED_REGION_ONLY ? new GriefPreventionLink(this) : null;
        plugin = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        if (plugin != null && plugin.isEnabled()) {
            this.placeholderAPILink = new PlaceholderAPILink(this);
            this.placeholderAPILink.register();
        } else {
            this.placeholderAPILink = null;
        }
        plugin = Bukkit.getPluginManager().getPlugin("PlotSquared");
        if (plugin != null && plugin.isEnabled() && this.configService.TRUSTED_REGION_ONLY) {
            this.plotSquaredLink = new PlotSquaredLink(this);
            if (!this.plotSquaredLink.isPlotSquaredVersionSupported()) {
                this.plotSquaredLink = null;
            }
        } else {
            this.plotSquaredLink = null;
        }
        if ((plugin = Bukkit.getPluginManager().getPlugin("WorldGuard")) != null && plugin.isEnabled()) {
            if (this.worldGuardLink == null) {
                this.worldGuardLink = new WorldGuardLink();
                this.worldGuardLink.registerFlags();
            }
            this.worldGuardLink.registerFlagHandlers();
        } else {
            this.worldGuardLink = null;
        }
    }

    private void printPluginLinks(CommandSender sender) {
        if (this.griefPreventionLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("GriefPrevention").getName());
        }
        if (this.placeholderAPILink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("PlaceholderAPI").getName());
        }
        if (this.plotSquaredLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("PlotSquared").getName());
        }
        if (this.worldGuardLink != null) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("WorldGuard").getName());
        }
    }

    private void setupBStatsMetric() {
        this.bStatsMetric = new BStatsMetric((Plugin)this, 4925);
        this.bStatsMetric.addCustomChart(new BStatsMetric.SimplePie("plugin_language", () -> this.configService.L_LANG));
        this.bStatsMetric.addCustomChart(new BStatsMetric.AdvancedPie("minecraft_version_player_amount", () -> Map.of(this.versionService.getServerVersion(), Bukkit.getOnlinePlayers().size())));
        this.bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("song_count", () -> this.songService.getSongs().size()));
    }
}

