/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.util;

import dev.geco.gmusic.GMusicMain;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class EnvironmentUtil {
    private final GMusicMain gMusicMain;
    private final List<Material> WATER_MATERIALS = new ArrayList<Material>();

    public EnvironmentUtil(GMusicMain gMusicMain) {
        this.WATER_MATERIALS.add(Material.KELP_PLANT);
        this.WATER_MATERIALS.add(Material.SEAGRASS);
        this.WATER_MATERIALS.add(Material.TALL_SEAGRASS);
        this.gMusicMain = gMusicMain;
    }

    public boolean isPlayerSwimming(@NotNull Player player) {
        Block block = player.getEyeLocation().getBlock();
        if (block.isLiquid()) {
            return true;
        }
        if (block.getBlockData() instanceof Waterlogged && ((Waterlogged)block.getBlockData()).isWaterlogged()) {
            return true;
        }
        return this.WATER_MATERIALS.contains(block.getType());
    }

    public boolean isEntityInAllowedWorld(@NotNull Entity entity) {
        boolean allowed;
        boolean bl = allowed = !this.gMusicMain.getConfigService().WORLDBLACKLIST.contains(entity.getWorld().getName());
        if (!this.gMusicMain.getConfigService().WORLDWHITELIST.isEmpty() && !this.gMusicMain.getConfigService().WORLDWHITELIST.contains(entity.getWorld().getName())) {
            allowed = false;
        }
        return allowed || this.gMusicMain.getPermissionService().hasPermission((Permissible)entity, "ByPass.World", "ByPass.*");
    }

    public boolean canUseJukeboxInLocation(@NotNull Location location, @NotNull Player player) {
        if (!this.gMusicMain.getConfigService().TRUSTED_REGION_ONLY || this.gMusicMain.getPermissionService().hasPermission((Permissible)player, "ByPass.Region", "ByPass.*")) {
            return true;
        }
        if (this.gMusicMain.getPlotSquaredLink() != null && !this.gMusicMain.getPlotSquaredLink().canUseInLocation(location, player)) {
            return false;
        }
        if (this.gMusicMain.getWorldGuardLink() != null && !this.gMusicMain.getWorldGuardLink().canUseJukeboxInLocation(location, player)) {
            return false;
        }
        return this.gMusicMain.getGriefPreventionLink() == null || this.gMusicMain.getGriefPreventionLink().canUseInLocation(location, player);
    }
}

