/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.Song;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SongService {
    public static final String GNBS_EXTENSION = "gnbs";
    public static final String NBS_EXTENSION = "nbs";
    public static final String MIDI_EXTENSION = "midi";
    public static final String MID_EXTENSION = "mid";
    public static final String GNBS_FOLDER = "gnbs";
    public static final String CONVERT_FOLDER = "convert";
    private final GMusicMain gMusicMain;
    private final TreeMap<String, Song> songs = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public SongService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public List<Song> getSongs() {
        return new ArrayList<Song>(this.songs.values());
    }

    @Nullable
    public Song getSongById(@NotNull String song) {
        return this.songs.get(song.toLowerCase());
    }

    public List<Song> filterSongsBySearch(@NotNull List<Song> songs, @NotNull String search) {
        return songs.stream().filter(song -> song.getTitle().toLowerCase().contains(search.toLowerCase())).toList();
    }

    public void loadSongs() {
        this.unloadSongs();
        this.convertSongs();
        File gnbsDir = new File(this.gMusicMain.getDataFolder(), "gnbs");
        if (!gnbsDir.exists()) {
            return;
        }
        File[] songFiles = gnbsDir.listFiles();
        if (songFiles == null) {
            return;
        }
        for (File file : songFiles) {
            this.loadSongFile(file);
        }
    }

    public boolean loadSongFile(@NotNull File file) {
        int extensionPos = file.getName().lastIndexOf(".");
        if (extensionPos <= 0 || !file.getName().substring(extensionPos + 1).equalsIgnoreCase("gnbs")) {
            return false;
        }
        try {
            Song song = new Song(file);
            if (song.getNoteAmount() == 0L) {
                this.gMusicMain.getLogger().warning("Could not load gnbs music '" + file.getName().substring(0, extensionPos) + "', no notes found");
                return false;
            }
            this.songs.put(song.getId().toLowerCase(), song);
            return true;
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.WARNING, "Could not load gnbs music '" + file.getName().substring(0, extensionPos) + "'", e);
            return false;
        }
    }

    public void unloadSongs() {
        this.songs.clear();
    }

    public void convertSongs() {
        File gnbsDir = new File(this.gMusicMain.getDataFolder(), "gnbs");
        if (!gnbsDir.exists() && !gnbsDir.mkdir()) {
            this.gMusicMain.getLogger().severe("Could not create 'gnbs' directory!");
            return;
        }
        File convertDir = new File(this.gMusicMain.getDataFolder(), CONVERT_FOLDER);
        if (!convertDir.exists() && !convertDir.mkdir()) {
            this.gMusicMain.getLogger().severe("Could not create 'convert' directory!");
            return;
        }
        File[] convertFiles = convertDir.listFiles();
        if (convertFiles == null) {
            return;
        }
        for (File file : convertFiles) {
            this.convertSongFile(file);
        }
    }

    @Nullable
    public File convertSongFile(@NotNull File file) {
        File gnbsDir = new File(this.gMusicMain.getDataFolder(), "gnbs");
        File gnbsFile = new File(gnbsDir.getAbsolutePath() + "/" + file.getName().replaceFirst("[.][^.]+$", "") + ".gnbs");
        if (gnbsFile.exists()) {
            return gnbsFile;
        }
        String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        switch (extension.toLowerCase()) {
            case "nbs": {
                if (this.gMusicMain.getNBSConverter().convertNBSFile(file)) {
                    return gnbsFile;
                }
                return null;
            }
            case "mid": 
            case "midi": {
                if (this.gMusicMain.getMidiConverter().convertMidiFile(file)) {
                    return gnbsFile;
                }
                return null;
            }
        }
        this.gMusicMain.getLogger().warning("Invalid convert extension: " + extension);
        return null;
    }
}

