/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.service;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.NotePart;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.PlayState;
import dev.geco.gmusic.model.Song;
import dev.geco.gmusic.model.gui.MusicGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioService {
    private final GMusicMain gMusicMain;
    private final Random random = new Random();
    private UUID radioUUID;
    private final Set<Player> radioPlayers = new HashSet<Player>();
    private final HashMap<UUID, Block> radioJukeBoxBlocks = new HashMap();

    public RadioService(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public void startRadio() {
        this.radioPlayers.clear();
        this.radioJukeBoxBlocks.clear();
        this.radioUUID = UUID.randomUUID();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlaySettings playerPlaySettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
            if (playerPlaySettings.getPlayListMode() != PlayListMode.RADIO) continue;
            this.radioPlayers.add(player);
        }
        this.playSong(this.gMusicMain.getPlayService().getRandomSong(this.radioUUID), 0L);
        new MusicGUI(this.radioUUID, MusicGUI.MenuType.RADIO);
    }

    @NotNull
    public UUID getRadioUUID() {
        return this.radioUUID;
    }

    public void playSong(@Nullable Song song) {
        this.playSong(song, 0L);
    }

    public void playSong(@Nullable Song song, long delay) {
        if (song == null) {
            return;
        }
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(this.radioUUID);
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        if (playState != null) {
            playState.getTimer().cancel();
        }
        Timer timer = new Timer();
        playState = new PlayState(song, timer, playSettings.isReverseMode() ? song.getLength() + delay : -delay);
        this.gMusicMain.getPlayService().setPlayState(this.radioUUID, playState);
        playSettings.setCurrentSong(song.getId());
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            HashSet<Player> players = new HashSet<Player>(this.radioPlayers);
            for (Map.Entry<UUID, Block> radioJukeBox : this.radioJukeBoxBlocks.entrySet()) {
                PlaySettings jukeBoxPlaySettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(radioJukeBox.getKey());
                HashMap<Player, Double> a = this.gMusicMain.getJukeBoxService().getPlayersInRange(radioJukeBox.getValue().getLocation().add(0.5, 0.0, 0.5), jukeBoxPlaySettings.getRange());
                players.addAll(a.keySet());
            }
            for (Player player : players) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
            }
        }
        this.playTimer(song, timer);
    }

    private void playTimer(final @NotNull Song song, final @NotNull Timer timer) {
        final PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        final PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(this.radioUUID);
        final long[] ticker = new long[]{0L};
        timer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ RadioService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ticker[0] = ticker[0] + 1L;
                long position = playState.getTickPosition();
                List<NotePart> noteParts = song.getContent().get(position);
                ArrayList<Player> players = new ArrayList<Player>(this.this$0.radioPlayers);
                if (!(noteParts == null || playSettings.getVolume() <= 0 || players.isEmpty() && this.this$0.radioJukeBoxBlocks.isEmpty())) {
                    for (Map.Entry<UUID, Block> radioJukeBox : this.this$0.radioJukeBoxBlocks.entrySet()) {
                        PlaySettings jukeBoxPlaySettings = this.this$0.gMusicMain.getPlaySettingsService().getPlaySettings(radioJukeBox.getKey());
                        if (!jukeBoxPlaySettings.isShowingParticles()) continue;
                        Location location = radioJukeBox.getValue().getLocation().add(0.5, 0.0, 0.5);
                        HashMap<Player, Double> playersInRange = this.this$0.gMusicMain.getJukeBoxService().getPlayersInRange(location, jukeBoxPlaySettings.getRange());
                        Location particleLocation = location.clone().add(this.this$0.random.nextDouble() - 0.5, 1.25, this.this$0.random.nextDouble() - 0.5);
                        for (Player player : playersInRange.keySet()) {
                            player.spawnParticle(Particle.NOTE, particleLocation, 0, this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), 1.0);
                        }
                    }
                    for (Player player : players) {
                        PlaySettings playerPlaySettings;
                        if (player == null || !(playerPlaySettings = this.this$0.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId())).isShowingParticles()) continue;
                        player.spawnParticle(Particle.NOTE, player.getEyeLocation().clone().add(this.this$0.random.nextDouble() - 0.5, 0.3, this.this$0.random.nextDouble() - 0.5), 0, this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), this.this$0.random.nextDouble(), 1.0);
                    }
                    for (NotePart notePart : noteParts) {
                        for (Player player : players) {
                            if (player == null) continue;
                            if (notePart.getSound() != null) {
                                Location location;
                                PlaySettings playerPlaySettings = this.this$0.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId());
                                float volume = playerPlaySettings.getFixedVolume() * notePart.getVolume();
                                Location location2 = location = notePart.getDistance() == 0.0f ? player.getEyeLocation() : this.this$0.gMusicMain.getSteroNoteUtil().convertToStero(player.getEyeLocation(), notePart.getDistance());
                                if (!this.this$0.gMusicMain.getConfigService().ENVIRONMENT_EFFECTS) {
                                    player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                    continue;
                                }
                                if (this.this$0.gMusicMain.getEnvironmentUtil().isPlayerSwimming(player)) {
                                    player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume > 0.4f ? volume - 0.3f : volume, notePart.getPitch() - 0.15f);
                                    continue;
                                }
                                player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                continue;
                            }
                            if (notePart.getStopSound() == null) continue;
                            player.stopSound(notePart.getStopSound(), song.getSoundCategory());
                        }
                        for (Map.Entry entry : this.this$0.radioJukeBoxBlocks.entrySet()) {
                            PlaySettings jukeBoxPlaySettings = this.this$0.gMusicMain.getPlaySettingsService().getPlaySettings((UUID)entry.getKey());
                            Location boxLocation = ((Block)entry.getValue()).getLocation().add(0.5, 0.0, 0.5);
                            HashMap<Player, Double> playersInRange = this.this$0.gMusicMain.getJukeBoxService().getPlayersInRange(boxLocation, jukeBoxPlaySettings.getRange());
                            for (Player player : playersInRange.keySet()) {
                                if (notePart.getSound() != null) {
                                    Location location;
                                    float volume = (float)((playersInRange.get(player) - (double)jukeBoxPlaySettings.getRange()) * (double)jukeBoxPlaySettings.getFixedVolume() / (double)(-jukeBoxPlaySettings.getRange())) * notePart.getVolume();
                                    Location location3 = location = notePart.getDistance() == 0.0f ? player.getEyeLocation() : this.this$0.gMusicMain.getSteroNoteUtil().convertToStero(player.getEyeLocation(), notePart.getDistance());
                                    if (!this.this$0.gMusicMain.getConfigService().ENVIRONMENT_EFFECTS) {
                                        player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                        continue;
                                    }
                                    if (this.this$0.gMusicMain.getEnvironmentUtil().isPlayerSwimming(player)) {
                                        player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume > 0.4f ? volume - 0.3f : volume, notePart.getPitch() - 0.15f);
                                        continue;
                                    }
                                    player.playSound(location, notePart.getSound(), song.getSoundCategory(), volume, notePart.getPitch());
                                    continue;
                                }
                                if (notePart.getStopSound() == null) continue;
                                player.stopSound(notePart.getStopSound(), song.getSoundCategory());
                            }
                            players.addAll(playersInRange.keySet());
                        }
                    }
                }
                if (position == (playSettings.isReverseMode() ? 0L : song.getLength())) {
                    timer.cancel();
                    this.this$0.playSong(this.this$0.gMusicMain.getPlayService().getShuffleSong(this.this$0.radioUUID, song), this.this$0.gMusicMain.getConfigService().PS_TIME_UNTIL_SHUFFLE);
                } else {
                    playState.setTickPosition(playSettings.isReverseMode() ? position - 1L : position + 1L);
                    if (this.this$0.gMusicMain.getConfigService().A_SHOW_WHILE_PLAYING && ticker[0] % 2000L == 0L) {
                        for (Player radioPlayer : players) {
                            if (radioPlayer == null) continue;
                            this.this$0.gMusicMain.getMessageService().sendActionBarMessage(radioPlayer, "Messages.actionbar-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor());
                        }
                    }
                }
            }
        }, 0L, 1L);
    }

    public void stopRadio() {
        this.gMusicMain.getPlaySettingsService().removePlaySettingsCache(this.radioUUID);
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        this.gMusicMain.getPlayService().removePlayState(this.radioUUID);
    }

    public Song getNextSong() {
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        return playState != null ? this.gMusicMain.getPlayService().getShuffleSong(this.radioUUID, playState.getSong()) : this.gMusicMain.getPlayService().getRandomSong(this.radioUUID);
    }

    public void stopSong() {
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        this.gMusicMain.getPlayService().removePlayState(this.radioUUID);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(this.radioUUID);
        playSettings.setCurrentSong(null);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES) {
            HashSet<Player> players = new HashSet<Player>(this.radioPlayers);
            for (Map.Entry<UUID, Block> radioJukeBox : this.radioJukeBoxBlocks.entrySet()) {
                PlaySettings jukeBoxPlaySettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(radioJukeBox.getKey());
                HashMap<Player, Double> a = this.gMusicMain.getJukeBoxService().getPlayersInRange(radioJukeBox.getValue().getLocation().add(0.5, 0.0, 0.5), jukeBoxPlaySettings.getRange());
                players.addAll(a.keySet());
            }
            for (Player player : players) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-pause", new Object[0]);
            }
        }
    }

    public void pauseSong() {
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        if (playState == null) {
            return;
        }
        playState.getTimer().cancel();
        playState.setPaused(true);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(this.radioUUID);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && playSettings != null) {
            HashSet<Player> players = new HashSet<Player>(this.radioPlayers);
            for (Map.Entry<UUID, Block> radioJukeBox : this.radioJukeBoxBlocks.entrySet()) {
                PlaySettings jukeBoxPlaySettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(radioJukeBox.getKey());
                HashMap<Player, Double> a = this.gMusicMain.getJukeBoxService().getPlayersInRange(radioJukeBox.getValue().getLocation().add(0.5, 0.0, 0.5), jukeBoxPlaySettings.getRange());
                players.addAll(a.keySet());
            }
            for (Player player : players) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-pause", new Object[0]);
            }
        }
    }

    public void resumeSong() {
        PlayState playState = this.gMusicMain.getPlayService().getPlayState(this.radioUUID);
        if (playState == null) {
            return;
        }
        playState.setTimer(new Timer());
        playState.setPaused(false);
        PlaySettings playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(this.radioUUID);
        if (this.gMusicMain.getConfigService().A_SHOW_MESSAGES && playSettings != null) {
            HashSet<Player> players = new HashSet<Player>(this.radioPlayers);
            for (Map.Entry<UUID, Block> radioJukeBox : this.radioJukeBoxBlocks.entrySet()) {
                PlaySettings jukeBoxPlaySettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(radioJukeBox.getKey());
                HashMap<Player, Double> a = this.gMusicMain.getJukeBoxService().getPlayersInRange(radioJukeBox.getValue().getLocation().add(0.5, 0.0, 0.5), jukeBoxPlaySettings.getRange());
                players.addAll(a.keySet());
            }
            for (Player player : players) {
                this.gMusicMain.getMessageService().sendActionBarMessage(player, "Messages.actionbar-resume", new Object[0]);
            }
        }
        this.playTimer(playState.getSong(), playState.getTimer());
    }

    public void removeRadioPlayer(@NotNull Player Player2) {
        this.radioPlayers.remove(Player2);
    }

    public void addRadioPlayer(@NotNull Player Player2) {
        this.radioPlayers.add(Player2);
    }

    public void removeRadioJukeBox(@NotNull UUID uuid) {
        this.radioJukeBoxBlocks.remove(uuid);
    }

    public void addRadioJukeBox(@NotNull UUID uuid, @NotNull Block block) {
        this.radioJukeBoxBlocks.put(uuid, block);
    }
}

