/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.model.gui;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.api.event.GMusicReloadEvent;
import dev.geco.gmusic.model.PlayListMode;
import dev.geco.gmusic.model.PlayMode;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.PlayState;
import dev.geco.gmusic.model.Song;
import dev.geco.gmusic.model.gui.MusicInputGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MusicGUI {
    private final GMusicMain gMusicMain = GMusicMain.getInstance();
    private final HashMap<Integer, Song> pageSongs = new HashMap();
    private static final HashMap<UUID, MusicGUI> musicGUIS = new HashMap();
    private static final int VOLUME_STEPS = 10;
    private static final int SHIFT_VOLUME_STEPS = 1;
    private static final long RANGE_STEPS = 1L;
    private static final long SHIFT_RANGE_STEPS = 10L;
    private final UUID uuid;
    private final MenuType type;
    private final Inventory inventory;
    private final Listener listener;
    private boolean optionState = false;
    private int page = 1;
    private boolean searchMode = false;
    private String searchKey = null;
    private final PlaySettings playSettings;

    public MusicGUI(final UUID uuid, final MenuType type) {
        this.uuid = uuid;
        this.type = type;
        musicGUIS.put(uuid, this);
        this.playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(uuid);
        this.inventory = Bukkit.createInventory((InventoryHolder)new InventoryHolder(){

            @NotNull
            public Inventory getInventory() {
                return MusicGUI.this.inventory;
            }
        }, (int)54, (String)this.gMusicMain.getMessageService().getMessage(type == MenuType.RADIO ? "MusicGUI.radio-title" : "MusicGUI.title", new Object[0]));
        this.setPage(1);
        this.setDefaultBar();
        this.listener = new Listener(){
            final /* synthetic */ MusicGUI this$0;
            {
                this.this$0 = this$0;
            }

            @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
            public void ICliE(InventoryClickEvent event) {
                if (!event.getInventory().equals((Object)this.this$0.inventory)) {
                    return;
                }
                ClickType click = event.getClick();
                if (this.this$0.gMusicMain.getVersionService().executeMethod(event.getView(), "getBottomInventory").equals(event.getClickedInventory())) {
                    switch (click) {
                        case SHIFT_RIGHT: 
                        case SHIFT_LEFT: {
                            event.setCancelled(true);
                        }
                    }
                    return;
                }
                if (!this.this$0.gMusicMain.getVersionService().executeMethod(event.getView(), "getTopInventory").equals(event.getClickedInventory())) {
                    return;
                }
                event.setCancelled(true);
                ItemStack itemStack = event.getCurrentItem();
                if (itemStack == null) {
                    return;
                }
                ItemMeta itemMeta = itemStack.getItemMeta();
                HumanEntity clicker = event.getWhoClicked();
                int slot = event.getRawSlot();
                block3 : switch (slot) {
                    case 45: {
                        if (!this.this$0.optionState) {
                            PlayState songSettings = this.this$0.gMusicMain.getPlayService().getPlayState(uuid);
                            if (songSettings == null) {
                                return;
                            }
                            switch (type.ordinal()) {
                                case 0: {
                                    Player target = Bukkit.getPlayer((UUID)uuid);
                                    if (target == null) {
                                        return;
                                    }
                                    if (songSettings.isPaused()) {
                                        this.this$0.gMusicMain.getPlayService().resumeSong(target);
                                        break;
                                    }
                                    this.this$0.gMusicMain.getPlayService().pauseSong(target);
                                    break;
                                }
                                case 1: {
                                    if (songSettings.isPaused()) {
                                        this.this$0.gMusicMain.getJukeBoxService().resumeBoxSong(uuid);
                                        break;
                                    }
                                    this.this$0.gMusicMain.getJukeBoxService().pauseBoxSong(uuid);
                                    break;
                                }
                                case 2: {
                                    if (songSettings.isPaused()) {
                                        this.this$0.gMusicMain.getRadioService().resumeSong();
                                        break;
                                    }
                                    this.this$0.gMusicMain.getRadioService().pauseSong();
                                }
                            }
                            break;
                        }
                        this.this$0.setDefaultBar();
                        break;
                    }
                    case 46: {
                        int step;
                        if (!this.this$0.optionState) {
                            switch (type.ordinal()) {
                                case 0: {
                                    Player target = Bukkit.getPlayer((UUID)uuid);
                                    if (target == null) {
                                        return;
                                    }
                                    this.this$0.gMusicMain.getPlayService().stopSong(target);
                                    break;
                                }
                                case 1: {
                                    this.this$0.gMusicMain.getJukeBoxService().stopBoxSong(uuid);
                                    break;
                                }
                                case 2: {
                                    this.this$0.gMusicMain.getRadioService().stopSong();
                                }
                            }
                            break;
                        }
                        if (type == MenuType.RADIO) break;
                        int volumn = this.this$0.playSettings.getVolume();
                        int n = step = click == ClickType.SHIFT_LEFT || click == ClickType.SHIFT_RIGHT ? 1 : 10;
                        int newVolumn = click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().PS_D_VOLUME : (click == ClickType.RIGHT ? Math.max(volumn - step, 0) : Math.min(volumn + step, 100));
                        this.this$0.playSettings.setVolume(newVolumn);
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-volume", "%Volume%", "" + newVolumn));
                        break;
                    }
                    case 47: {
                        if (!this.this$0.optionState) {
                            switch (type.ordinal()) {
                                case 0: {
                                    Player target = Bukkit.getPlayer((UUID)uuid);
                                    if (target == null) {
                                        return;
                                    }
                                    this.this$0.gMusicMain.getPlayService().playSong(target, this.this$0.gMusicMain.getPlayService().getNextSong(target));
                                    break;
                                }
                                case 1: {
                                    this.this$0.gMusicMain.getJukeBoxService().playBoxSong(uuid, this.this$0.gMusicMain.getJukeBoxService().getNextSong(uuid));
                                    break;
                                }
                                case 2: {
                                    this.this$0.gMusicMain.getRadioService().playSong(this.this$0.gMusicMain.getRadioService().getNextSong());
                                }
                            }
                            break;
                        }
                        if (type == MenuType.RADIO) break;
                        this.this$0.playSettings.setShowParticles(click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().PS_D_PARTICLES : !this.this$0.playSettings.isShowingParticles());
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-particle", "%Particle%", this.this$0.gMusicMain.getMessageService().getMessage(this.this$0.playSettings.isShowingParticles() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
                        break;
                    }
                    case 48: {
                        if (this.this$0.playSettings.getPlayListMode() == PlayListMode.RADIO) {
                            return;
                        }
                        if (!this.this$0.optionState) {
                            if (this.this$0.gMusicMain.getConfigService().G_DISABLE_RANDOM_SONG) {
                                return;
                            }
                            switch (type.ordinal()) {
                                case 0: {
                                    Player target = Bukkit.getPlayer((UUID)uuid);
                                    if (target == null) {
                                        return;
                                    }
                                    this.this$0.gMusicMain.getPlayService().playSong(target, this.this$0.gMusicMain.getPlayService().getRandomSong(uuid));
                                    break;
                                }
                                case 1: {
                                    this.this$0.gMusicMain.getJukeBoxService().playBoxSong(uuid, this.this$0.gMusicMain.getPlayService().getRandomSong(uuid));
                                    break;
                                }
                                case 2: {
                                    this.this$0.gMusicMain.getRadioService().playSong(this.this$0.gMusicMain.getPlayService().getRandomSong(this.this$0.gMusicMain.getRadioService().getRadioUUID()));
                                }
                            }
                            break;
                        }
                        if (type == MenuType.RADIO) break;
                        this.this$0.playSettings.setPlayOnJoin(click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().R_PLAY_ON_JOIN : !this.this$0.playSettings.isPlayOnJoin());
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-join", "%Join%", this.this$0.gMusicMain.getMessageService().getMessage(this.this$0.playSettings.isPlayOnJoin() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
                        break;
                    }
                    case 49: {
                        if (type == MenuType.RADIO) {
                            return;
                        }
                        if (!this.this$0.optionState) {
                            int playListModeId = this.this$0.playSettings.getPlayListMode().getId();
                            PlayListMode playListMode = PlayListMode.byId(click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().PS_D_PLAYLIST_MODE : (click == ClickType.RIGHT ? (playListModeId - 1 < 0 ? PlayListMode.values().length - 1 : playListModeId - 1) : (playListModeId + 1 > PlayListMode.values().length - 1 ? 0 : playListModeId + 1)));
                            this.this$0.playSettings.setPlayListMode(playListMode);
                            switch (type.ordinal()) {
                                case 0: {
                                    Player target = Bukkit.getPlayer((UUID)uuid);
                                    if (playListMode.getId() != playListModeId && target != null) {
                                        this.this$0.setPage(1);
                                        this.this$0.gMusicMain.getPlayService().stopSong(target);
                                    }
                                    if (playListMode == PlayListMode.RADIO) {
                                        this.this$0.gMusicMain.getRadioService().addRadioPlayer(target);
                                        break;
                                    }
                                    this.this$0.gMusicMain.getRadioService().removeRadioPlayer(target);
                                    break;
                                }
                                case 1: {
                                    if (playListMode.getId() != playListModeId) {
                                        this.this$0.setPage(1);
                                        this.this$0.gMusicMain.getJukeBoxService().stopBoxSong(uuid);
                                    }
                                    if (playListMode == PlayListMode.RADIO) {
                                        this.this$0.gMusicMain.getRadioService().addRadioJukeBox(uuid, this.this$0.gMusicMain.getJukeBoxService().getJukeBoxBlock(uuid));
                                        break;
                                    }
                                    this.this$0.gMusicMain.getRadioService().removeRadioJukeBox(uuid);
                                }
                            }
                            this.this$0.setDefaultBar();
                            break;
                        }
                        if (this.this$0.playSettings.getPlayListMode() == PlayListMode.RADIO) {
                            return;
                        }
                        int playModeId = this.this$0.playSettings.getPlayMode().getId();
                        PlayMode playMode = PlayMode.byId(click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().PS_D_PLAY_MODE : (click == ClickType.RIGHT ? (playModeId - 1 < 0 ? PlayMode.values().length - 1 : playModeId - 1) : (playModeId + 1 > PlayMode.values().length - 1 ? 0 : playModeId + 1)));
                        this.this$0.playSettings.setPlayMode(playMode);
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage(playMode == PlayMode.DEFAULT ? "MusicGUI.music-options-play-mode-once" : (playMode == PlayMode.SHUFFLE ? "MusicGUI.music-options-play-mode-shuffle" : "MusicGUI.music-options-play-mode-repeat"), new Object[0]));
                        break;
                    }
                    case 50: {
                        if (!this.this$0.optionState) {
                            this.this$0.setOptionsBar();
                            break;
                        }
                        if (this.this$0.playSettings.getPlayListMode() == PlayListMode.RADIO) {
                            return;
                        }
                        this.this$0.playSettings.setReverseMode(click == ClickType.MIDDLE ? this.this$0.gMusicMain.getConfigService().PS_D_REVERSE : !this.this$0.playSettings.isReverseMode());
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-reverse", "%Reverse%", this.this$0.gMusicMain.getMessageService().getMessage(this.this$0.playSettings.isReverseMode() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
                        break;
                    }
                    case 51: {
                        long step;
                        if (!this.this$0.optionState) {
                            if (this.this$0.playSettings.getPlayListMode() == PlayListMode.RADIO) {
                                return;
                            }
                            if (!this.this$0.gMusicMain.getVersionService().isAvailable()) {
                                return;
                            }
                            if (click == ClickType.LEFT) {
                                MusicInputGUI inputGUI = this.this$0.getInputGUIInstance(input -> {
                                    this.this$0.searchKey = input;
                                    this.this$0.setPage(1);
                                    this.this$0.setDefaultBar();
                                    clicker.openInventory(this.this$0.inventory);
                                    this.this$0.searchMode = false;
                                    return true;
                                }, ItemMeta::getDisplayName);
                                ItemStack nameItem = new ItemStack(Material.NAME_TAG);
                                ItemMeta nameItemMeta = nameItem.getItemMeta();
                                nameItemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-search-menu-field", new Object[0]));
                                nameItem.setItemMeta(nameItemMeta);
                                this.this$0.searchKey = null;
                                this.this$0.searchMode = true;
                                inputGUI.open((LivingEntity)clicker, this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-search-menu-title", new Object[0]), nameItem);
                                break;
                            }
                            if (this.this$0.searchKey == null) break;
                            this.this$0.searchKey = null;
                            this.this$0.setPage(1);
                            this.this$0.setDefaultBar();
                            break;
                        }
                        if (type != MenuType.JUKEBOX) {
                            return;
                        }
                        long range = this.this$0.playSettings.getRange();
                        long l = step = click == ClickType.SHIFT_LEFT || click == ClickType.SHIFT_RIGHT ? 10L : 1L;
                        long newRange = click == ClickType.MIDDLE ? (long)this.this$0.gMusicMain.getConfigService().JUKEBOX_RANGE : (click == ClickType.RIGHT ? Math.max(range - step, 0L) : Math.min(range + step, (long)this.this$0.gMusicMain.getConfigService().MAX_JUKEBOX_RANGE));
                        this.this$0.playSettings.setRange(newRange);
                        itemMeta.setDisplayName(this.this$0.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-range", "%Range%", "" + newRange));
                        break;
                    }
                    case 52: {
                        this.this$0.setPage(this.this$0.page - 1);
                        break;
                    }
                    case 53: {
                        this.this$0.setPage(this.this$0.page + 1);
                        break;
                    }
                    default: {
                        if (slot < 0 || slot > 44) {
                            return;
                        }
                        Song song = this.this$0.pageSongs.get(slot);
                        if (song == null) {
                            return;
                        }
                        if (click == ClickType.MIDDLE) {
                            if (this.this$0.playSettings.getFavorites().contains(song)) {
                                this.this$0.playSettings.getFavorites().remove(song);
                            } else {
                                this.this$0.playSettings.getFavorites().add(song);
                            }
                            this.this$0.setPage(this.this$0.page);
                            return;
                        }
                        switch (type.ordinal()) {
                            case 0: {
                                Player target = Bukkit.getPlayer((UUID)uuid);
                                if (target == null) {
                                    return;
                                }
                                this.this$0.gMusicMain.getPlayService().playSong(target, song);
                                break block3;
                            }
                            case 1: {
                                this.this$0.gMusicMain.getJukeBoxService().playBoxSong(uuid, song);
                                break block3;
                            }
                            case 2: {
                                this.this$0.gMusicMain.getRadioService().playSong(song);
                            }
                        }
                    }
                }
                this.this$0.setPauseResumeBar();
                itemStack.setItemMeta(itemMeta);
            }

            @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
            public void inventoryDragEvent(InventoryDragEvent event) {
                if (!event.getInventory().equals((Object)this.this$0.inventory)) {
                    return;
                }
                Iterator iterator = event.getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot >= this.this$0.inventory.getSize()) continue;
                    event.setCancelled(true);
                    return;
                }
            }

            @EventHandler
            public void inventoryCloseEvent(InventoryCloseEvent Event2) {
                if (Event2.getInventory().equals((Object)this.this$0.inventory)) {
                    this.this$0.close(false);
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void gMusicReloadEvent(GMusicReloadEvent Event2) {
                if (Event2.getPlugin().equals((Object)this.this$0.gMusicMain)) {
                    this.this$0.close(true);
                }
            }

            @EventHandler
            public void pluginDisableEvent(PluginDisableEvent Event2) {
                if (Event2.getPlugin().equals((Object)this.this$0.gMusicMain)) {
                    this.this$0.close(true);
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.gMusicMain);
    }

    public static MusicGUI getMusicGUI(UUID uuid) {
        return musicGUIS.get(uuid);
    }

    public void close(boolean force) {
        if (force) {
            for (HumanEntity entity : new ArrayList(this.inventory.getViewers())) {
                entity.closeInventory();
            }
        }
        if (!force && (this.searchMode || this.type == MenuType.JUKEBOX || this.type == MenuType.RADIO)) {
            return;
        }
        musicGUIS.remove(this.uuid);
        HandlerList.unregisterAll((Listener)this.listener);
    }

    private MusicInputGUI getInputGUIInstance(MusicInputGUI.InputCallback call, MusicInputGUI.ValidateCallback validateCall) {
        try {
            Class<?> inputGUIClass = Class.forName(this.gMusicMain.getVersionService().getPackagePath() + ".object.gui.GMusicInputGUI");
            return (MusicInputGUI)inputGUIClass.getConstructor(MusicInputGUI.InputCallback.class, MusicInputGUI.ValidateCallback.class).newInstance(call, validateCall);
        }
        catch (Throwable e) {
            this.gMusicMain.getLogger().log(Level.SEVERE, "Could not get input gui instance", e);
            return null;
        }
    }

    private void clearBar() {
        for (int slot = 45; slot < 52; ++slot) {
            this.inventory.setItem(slot, null);
        }
    }

    public void setDefaultBar() {
        ItemMeta itemMeta;
        ItemStack itemStack;
        this.optionState = false;
        this.clearBar();
        if (!this.gMusicMain.getConfigService().G_DISABLE_RANDOM_SONG && this.playSettings.getPlayListMode() != PlayListMode.RADIO) {
            itemStack = new ItemStack(Material.ENDER_PEARL);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-random", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(48, itemStack);
        }
        if (!this.gMusicMain.getConfigService().G_DISABLE_PLAYLIST && this.type != MenuType.RADIO) {
            itemStack = new ItemStack(Material.NOTE_BLOCK);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage(this.playSettings.getPlayListMode() == PlayListMode.DEFAULT ? "MusicGUI.music-playlist-mode-default" : (this.playSettings.getPlayListMode() == PlayListMode.FAVORITES ? "MusicGUI.music-playlist-mode-favorites" : "MusicGUI.music-playlist-mode-radio"), new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(49, itemStack);
        }
        if (!this.gMusicMain.getConfigService().G_DISABLE_OPTIONS) {
            itemStack = new ItemStack(Material.HOPPER);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(50, itemStack);
        }
        if (!this.gMusicMain.getConfigService().G_DISABLE_SEARCH && this.playSettings.getPlayListMode() != PlayListMode.RADIO && this.gMusicMain.getVersionService().isAvailable()) {
            itemStack = new ItemStack(Material.OAK_SIGN);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.searchKey == null || this.searchKey.isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.music-search-none", new Object[0]) : this.gMusicMain.getMessageService().getMessage("MusicGUI.music-search", "%Search%", this.searchKey));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(51, itemStack);
        }
        this.setPauseResumeBar();
    }

    public void setPauseResumeBar() {
        if (this.optionState || this.playSettings.getPlayListMode() == PlayListMode.RADIO) {
            return;
        }
        PlayState songSettings = this.gMusicMain.getPlayService().getPlayState(this.uuid);
        if (songSettings != null) {
            ItemStack itemStack = new ItemStack(Material.END_CRYSTAL);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (songSettings.isPaused()) {
                itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-resume", new Object[0]));
            } else {
                itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-pause", new Object[0]));
            }
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(45, itemStack);
            itemStack = new ItemStack(Material.BARRIER);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-stop", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(46, itemStack);
            itemStack = new ItemStack(Material.FEATHER);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-skip", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(47, itemStack);
            return;
        }
        this.inventory.setItem(45, null);
        this.inventory.setItem(46, null);
        this.inventory.setItem(47, null);
    }

    public void setOptionsBar() {
        this.optionState = true;
        this.clearBar();
        ItemStack itemStack = new ItemStack(Material.CHEST);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-back", new Object[0]));
        itemStack.setItemMeta(itemMeta);
        this.inventory.setItem(45, itemStack);
        if (this.type != MenuType.RADIO) {
            itemStack = new ItemStack(Material.MAGMA_CREAM);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-volume", "%Volume%", "" + this.playSettings.getVolume()));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(46, itemStack);
            itemStack = new ItemStack(Material.FIREWORK_ROCKET);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-particle", "%Particle%", this.gMusicMain.getMessageService().getMessage(this.playSettings.isShowingParticles() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
            itemMeta.addItemFlags(ItemFlag.values());
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(47, itemStack);
        }
        if (this.playSettings.getPlayListMode() != PlayListMode.RADIO) {
            if (this.type != MenuType.RADIO) {
                itemStack = new ItemStack(Material.DIAMOND);
                itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-join", "%Join%", this.gMusicMain.getMessageService().getMessage(this.playSettings.isPlayOnJoin() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
                itemStack.setItemMeta(itemMeta);
                this.inventory.setItem(48, itemStack);
                itemStack = new ItemStack(Material.BLAZE_POWDER);
                itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage(this.playSettings.getPlayMode() == PlayMode.DEFAULT ? "MusicGUI.music-options-play-mode-once" : (this.playSettings.getPlayMode() == PlayMode.SHUFFLE ? "MusicGUI.music-options-play-mode-shuffle" : "MusicGUI.music-options-play-mode-repeat"), new Object[0]));
                itemStack.setItemMeta(itemMeta);
                this.inventory.setItem(49, itemStack);
            }
            itemStack = new ItemStack(Material.TOTEM_OF_UNDYING);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-reverse", "%Reverse%", this.gMusicMain.getMessageService().getMessage(this.playSettings.isReverseMode() ? "MusicGUI.music-options-true" : "MusicGUI.music-options-false", new Object[0])));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(50, itemStack);
        }
        if (this.type == MenuType.JUKEBOX) {
            itemStack = new ItemStack(Material.REDSTONE);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.music-options-range", "%Range%", "" + this.playSettings.getRange()));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(51, itemStack);
        }
    }

    public void setPage(int newPage) {
        ItemMeta itemMeta;
        ItemStack itemStack;
        List<Object> songs = new ArrayList();
        if (this.playSettings.getPlayListMode() != PlayListMode.RADIO) {
            List<Song> list = songs = this.playSettings.getPlayListMode() == PlayListMode.FAVORITES ? this.playSettings.getFavorites() : this.gMusicMain.getSongService().getSongs();
            if (this.searchKey != null && !this.searchKey.isEmpty()) {
                songs = this.gMusicMain.getSongService().filterSongsBySearch(songs, this.searchKey);
            }
        }
        if (newPage > this.getMaxPageSize(songs.size())) {
            newPage = this.getMaxPageSize(songs.size());
        }
        if (newPage < 1) {
            newPage = 1;
        }
        this.page = newPage;
        for (int slot = 0; slot < 45; ++slot) {
            this.inventory.setItem(slot, null);
        }
        this.pageSongs.clear();
        if (!songs.isEmpty()) {
            for (int songPosition = (this.page - 1) * 45; songPosition < 45 * this.page && songPosition < songs.size(); ++songPosition) {
                Song song = (Song)songs.get(songPosition);
                ItemStack itemStack2 = new ItemStack(song.getDiscMaterial());
                ItemMeta itemMeta2 = itemStack2.getItemMeta();
                itemMeta2.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-title", "%Song%", song.getId(), "%SongTitle%", song.getTitle(), "%Author%", song.getAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-author", new Object[0]) : song.getAuthor(), "%OriginalAuthor%", song.getOriginalAuthor().isEmpty() ? this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-empty-original-author", new Object[0]) : song.getOriginalAuthor()));
                ArrayList<String> description = new ArrayList<String>();
                for (String descriptionRow : song.getDescription()) {
                    description.add(this.gMusicMain.getMessageService().toFormattedMessage("&6" + descriptionRow, new Object[0]));
                }
                if (this.playSettings.getFavorites().contains(song)) {
                    description.add(this.gMusicMain.getMessageService().getMessage("MusicGUI.disc-favorite", new Object[0]));
                }
                itemMeta2.setLore(description);
                this.pageSongs.put(songPosition % 45, song);
                itemMeta2.addItemFlags(ItemFlag.values());
                itemStack2.setItemMeta(itemMeta2);
                this.inventory.setItem(songPosition % 45, itemStack2);
            }
        }
        if (this.page > 1) {
            itemStack = new ItemStack(Material.ARROW);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.last-page", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(52, itemStack);
        } else {
            itemStack = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(" ");
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(52, itemStack);
        }
        if (this.page < this.getMaxPageSize(songs.size())) {
            itemStack = new ItemStack(Material.ARROW);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.gMusicMain.getMessageService().getMessage("MusicGUI.next-page", new Object[0]));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(53, itemStack);
        } else {
            itemStack = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(" ");
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(53, itemStack);
        }
    }

    private int getMaxPageSize(int songCount) {
        return songCount / 45 + (songCount % 45 == 0 ? 0 : 1);
    }

    public UUID getOwner() {
        return this.uuid;
    }

    public MenuType getMenuType() {
        return this.type;
    }

    public PlaySettings getPlaySettings() {
        return this.playSettings;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static enum MenuType {
        DEFAULT,
        JUKEBOX,
        RADIO;

    }
}

