/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.model;

import dev.geco.gmusic.model.Note;
import dev.geco.gmusic.model.NoteInstrument;
import dev.geco.gmusic.model.NotePart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.file.YamlConfiguration;

public class Song {
    private static final List<Material> DISCS = Arrays.stream(Material.values()).filter(disc -> disc.name().contains("_DISC_")).toList();
    private final String filename;
    private final String id;
    private final String title;
    private final String originalAuthor;
    private final String author;
    private final List<String> description;
    private Material discMaterial;
    private SoundCategory soundCategory;
    private final HashMap<String, String> instruments = new HashMap();
    private final HashMap<String, List<Note>> parts = new HashMap();
    private final List<Note> notes = new ArrayList<Note>();
    private final HashMap<Long, List<NotePart>> content = new HashMap();
    private long noteAmount = 0L;
    private long length = 0L;

    public Song(File gnbsFile) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)gnbsFile);
        this.filename = gnbsFile.getName();
        this.id = config.getString("Song.Id");
        this.title = config.getString("Song.Title", this.id);
        this.originalAuthor = config.getString("Song.OriginalAuthor");
        this.author = config.getString("Song.Author");
        this.description = config.getStringList("Song.Description");
        String material = config.getString("Song.Material");
        if (material != null) {
            try {
                this.discMaterial = Material.valueOf((String)material.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.discMaterial == null) {
            this.discMaterial = this.id == null ? DISCS.get(0) : DISCS.get(this.id.length() <= DISCS.size() - 1 ? this.id.length() : this.id.length() % (DISCS.size() - 1));
        }
        try {
            this.soundCategory = SoundCategory.valueOf((String)config.getString("Song.Category", "").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.soundCategory = SoundCategory.RECORDS;
        }
        ArrayList songInstruments = new ArrayList();
        try {
            songInstruments.addAll(config.getConfigurationSection("Song.Content.Instruments").getKeys(false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Object songInstrument : songInstruments) {
            try {
                String noteInstrument = NoteInstrument.getInstrument(Integer.parseInt(config.getString("Song.Content.Instruments." + (String)songInstrument, "0")));
                if (noteInstrument != null) {
                    this.instruments.put((String)songInstrument, noteInstrument);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException e) {
                this.instruments.put((String)songInstrument, config.getString("Song.Content.Instruments." + (String)songInstrument));
            }
        }
        ArrayList songParts = new ArrayList();
        try {
            songParts.addAll(config.getConfigurationSection("Song.Content.Parts").getKeys(false));
        }
        catch (Throwable songInstrument) {
            // empty catch block
        }
        for (String songPart : songParts) {
            ArrayList<Note> songNotes = new ArrayList<Note>();
            for (String contentPart : config.getStringList("Song.Content.Parts." + songPart)) {
                songNotes.add(new Note(this, contentPart));
            }
            this.parts.put(songPart, songNotes);
        }
        List mainContent = config.getStringList("Song.Content.Main");
        for (String row : mainContent) {
            this.notes.add(new Note(this, row));
        }
        for (Note note : this.notes) {
            long noteCount;
            if (note.isReference()) {
                for (noteCount = 1L; noteCount <= note.getAmount(); ++noteCount) {
                    this.length += note.getDelay();
                    for (Note noteReference : note.getReferences()) {
                        for (long nodeReferenceCount = 1L; nodeReferenceCount <= noteReference.getAmount(); ++nodeReferenceCount) {
                            this.length += noteReference.getDelay();
                            if (this.content.containsKey(this.length)) {
                                List<NotePart> noteParts = this.content.get(this.length);
                                noteParts.addAll(noteReference.getNoteParts());
                                this.content.put(this.length, noteParts);
                            } else {
                                this.content.put(this.length, noteReference.getNoteParts());
                            }
                            this.noteAmount += (long)noteReference.getNoteParts().size();
                        }
                    }
                }
                continue;
            }
            for (noteCount = 1L; noteCount <= note.getAmount(); ++noteCount) {
                this.length += note.getDelay();
                if (this.content.containsKey(this.length)) {
                    List<NotePart> noteParts = this.content.get(this.length);
                    noteParts.addAll(note.getNoteParts());
                    this.content.put(this.length, noteParts);
                } else {
                    this.content.put(this.length, note.getNoteParts());
                }
                this.noteAmount += (long)note.getNoteParts().size();
            }
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public Material getDiscMaterial() {
        return this.discMaterial;
    }

    public SoundCategory getSoundCategory() {
        return this.soundCategory;
    }

    public HashMap<String, String> getInstruments() {
        return this.instruments;
    }

    public HashMap<String, List<Note>> getParts() {
        return this.parts;
    }

    public List<Note> getMain() {
        return this.notes;
    }

    public HashMap<Long, List<NotePart>> getContent() {
        return this.content;
    }

    public long getStepAmount() {
        return this.content.size();
    }

    public long getNoteAmount() {
        return this.noteAmount;
    }

    public long getLength() {
        return this.length;
    }
}

