/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.link.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.link.WorldGuardLink;
import dev.geco.gmusic.model.Song;
import java.util.Set;

public class RegionFlagHandler
extends Handler {
    public static final Factory FACTORY = new Factory();
    private final GMusicMain gMusicMain = GMusicMain.getInstance();
    private String currentId = null;

    public RegionFlagHandler(Session session) {
        super(session);
    }

    public boolean onCrossBoundary(LocalPlayer localPlayer, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        String songId = (String)toSet.queryValue((RegionAssociable)localPlayer, (Flag)WorldGuardLink.MUSIC_FLAG);
        if (songId == null || songId.isEmpty()) {
            this.currentId = null;
            return true;
        }
        if (songId.equals(this.currentId)) {
            return true;
        }
        this.currentId = songId;
        Song song = this.gMusicMain.getSongService().getSongById(songId);
        if (song == null) {
            return true;
        }
        org.bukkit.entity.Player player = BukkitAdapter.adapt((Player)localPlayer);
        this.gMusicMain.getPlayService().playSong(player, song);
        return true;
    }

    public static class Factory
    extends Handler.Factory<RegionFlagHandler> {
        public RegionFlagHandler create(Session session) {
            return new RegionFlagHandler(session);
        }
    }
}

