/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.link;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.handler.Handler;
import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.link.worldguard.RegionFlagHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardLink {
    public static final StringFlag MUSIC_FLAG = new StringFlag("music");
    public static final StateFlag JUKEBOX_FLAG = new StateFlag("jukebox", true);

    public void registerFlags() {
        HashMap<String, Object> flags = new HashMap<String, Object>();
        flags.put(MUSIC_FLAG.getName(), MUSIC_FLAG);
        flags.put(JUKEBOX_FLAG.getName(), JUKEBOX_FLAG);
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        for (Map.Entry flag : flags.entrySet()) {
            try {
                flagRegistry.register((Flag)flag.getValue());
            }
            catch (Throwable throwable) {}
        }
    }

    public void registerFlagHandlers() {
        WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)RegionFlagHandler.FACTORY, null);
    }

    public void unregisterFlagHandlers() {
        WorldGuard.getInstance().getPlatform().getSessionManager().unregisterHandler((Handler.Factory)RegionFlagHandler.FACTORY);
    }

    public boolean canUseJukeboxInLocation(Location location, Player player) {
        try {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            if (container.get(BukkitAdapter.adapt((World)location.getWorld())) == null) {
                return true;
            }
            RegionQuery regionQuery = container.createQuery();
            com.sk89q.worldedit.util.Location regionLocation = BukkitAdapter.adapt((Location)location);
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            return regionQuery.testState(regionLocation, localPlayer, new StateFlag[]{JUKEBOX_FLAG, Flags.CHEST_ACCESS});
        }
        catch (Throwable e) {
            GMusicMain.getInstance().getLogger().log(Level.SEVERE, "Could not check WorldGuard location!", e);
            return true;
        }
    }
}

