/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.cmd.tab;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.Song;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GMusicTabComplete
implements TabCompleter {
    private final GMusicMain gMusicMain;

    public GMusicTabComplete(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        ArrayList<String> complete = new ArrayList<String>();
        ArrayList<String> completeStarted = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return complete;
        }
        if (args.length == 1) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music", "Music.*")) {
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Play", "Music.*")) {
                    complete.add("play");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Playing", "Music.*")) {
                    complete.add("playing");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Random", "Music.*")) {
                    complete.add("random");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Stop", "Music.*")) {
                    complete.add("stop");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Pause", "Music.*")) {
                    complete.add("pause");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Resume", "Music.*")) {
                    complete.add("resume");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Skip", "Music.*")) {
                    complete.add("skip");
                }
                if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Toggle", "Music.*")) {
                    complete.add("toggle");
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        } else if (args.length == 2) {
            if (this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music", "Music.*") && this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music." + args[0], "Music.*") && args[0].equalsIgnoreCase("play")) {
                for (Song song : this.gMusicMain.getSongService().getSongs()) {
                    complete.add(song.getId());
                }
            }
            if (!args[args.length - 1].isEmpty()) {
                for (String entry : complete) {
                    if (!entry.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    completeStarted.add(entry);
                }
                complete.clear();
            }
        }
        return complete.isEmpty() ? completeStarted : complete;
    }
}

