/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gmusic.cmd;

import dev.geco.gmusic.GMusicMain;
import dev.geco.gmusic.model.PlaySettings;
import dev.geco.gmusic.model.Song;
import dev.geco.gmusic.model.gui.MusicGUI;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GMusicCommand
implements CommandExecutor {
    private final GMusicMain gMusicMain;

    public GMusicCommand(GMusicMain gMusicMain) {
        this.gMusicMain = gMusicMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music", "Music.*")) {
            this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
            return true;
        }
        if (!this.gMusicMain.getEnvironmentUtil().isEntityInAllowedWorld((Entity)player)) {
            this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-world-error", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            MusicGUI musicGUI = new MusicGUI(player.getUniqueId(), MusicGUI.MenuType.DEFAULT);
            player.openInventory(musicGUI.getInventory());
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "play": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Play", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                if (args.length == 1) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-play-use-error", new Object[0]);
                    return true;
                }
                Song song = this.gMusicMain.getSongService().getSongById(args[1]);
                if (song == null) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-song-error", "%Song%", args[1]);
                    return true;
                }
                this.gMusicMain.getPlayService().playSong(player, song);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle());
                break;
            }
            case "playing": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Playing", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                if (!this.gMusicMain.getPlayService().hasPlayingSong(player.getUniqueId()) || this.gMusicMain.getPlayService().hasPausedSong(player.getUniqueId())) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-playing-error", new Object[0]);
                    return true;
                }
                Song song = this.gMusicMain.getPlayService().getPlayingSong(player.getUniqueId());
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-playing", "%Song%", song.getId(), "%SongTitle%", song.getTitle());
                break;
            }
            case "random": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Random", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                Song song = this.gMusicMain.getPlayService().getRandomSong(player.getUniqueId());
                if (song == null) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-no-song-error", new Object[0]);
                    return true;
                }
                this.gMusicMain.getPlayService().playSong(player, song);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle());
                break;
            }
            case "stop": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Stop", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                if (!this.gMusicMain.getPlayService().hasPlayingSong(player.getUniqueId())) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-playing-error", new Object[0]);
                    return true;
                }
                this.gMusicMain.getPlayService().stopSong(player);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-stop", new Object[0]);
                break;
            }
            case "pause": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Pause", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                if (!this.gMusicMain.getPlayService().hasPlayingSong(player.getUniqueId()) || this.gMusicMain.getPlayService().hasPausedSong(player.getUniqueId())) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-playing-error", new Object[0]);
                    return true;
                }
                this.gMusicMain.getPlayService().pauseSong(player);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-pause", new Object[0]);
                break;
            }
            case "resume": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Resume", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                if (!this.gMusicMain.getPlayService().hasPausedSong(player.getUniqueId())) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-paused-error", new Object[0]);
                    return true;
                }
                this.gMusicMain.getPlayService().resumeSong(player);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-resume", new Object[0]);
                break;
            }
            case "skip": {
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Skip", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                Song song = this.gMusicMain.getPlayService().getNextSong(player);
                if (song == null) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-no-song-error", new Object[0]);
                    return true;
                }
                this.gMusicMain.getPlayService().playSong(player, song);
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-play", "%Song%", song.getId(), "%SongTitle%", song.getTitle());
                break;
            }
            case "toggle": {
                PlaySettings playSettings;
                if (!this.gMusicMain.getPermissionService().hasPermission((Permissible)sender, "Music.Toggle", "Music.*")) {
                    this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
                    return true;
                }
                playSettings.setToggleMode(!(playSettings = this.gMusicMain.getPlaySettingsService().getPlaySettings(player.getUniqueId())).isToggleMode());
                break;
            }
            default: {
                this.gMusicMain.getMessageService().sendMessage(sender, "Messages.command-gmusic-use-error", new Object[0]);
            }
        }
        return true;
    }
}

