/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.util;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloAnimation;
import dev.geco.gholo.service.HoloAnimationService;
import java.util.Collection;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class TextFormatUtil {
    private final GHoloMain gHoloMain;

    public TextFormatUtil(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public String replaceSymbols(String text) {
        for (Map.Entry<String, String> symbol : this.gHoloMain.getConfigService().SYMBOLS.entrySet()) {
            String key = symbol.getKey();
            String value = symbol.getValue();
            text = text.replace(key, value);
        }
        return text;
    }

    public String formatText(String text, Player player) {
        if (HoloAnimationService.countAnimationChars(text) < 2) {
            return text;
        }
        text = this.replaceAnimationsAndPlaceholders(text, player, this.gHoloMain.getHoloAnimationService().getAnimations());
        return this.replaceSymbols(text);
    }

    public String toFormattedText(String text) {
        return this.gHoloMain.getMessageService().toFormattedMessage(text, new Object[0]);
    }

    public Object toFormattedComponent(String text) {
        return this.gHoloMain.getMessageService().toFormattedComponent(text, new Object[0]);
    }

    private String replaceAnimationsAndPlaceholders(String text, Player player, Collection<GHoloAnimation> animations) {
        for (GHoloAnimation animation : animations) {
            text = text.replace("%" + animation.getId() + "%", animation.getCurrentContent());
        }
        return this.replacePlaceholders(text, player);
    }

    public String replacePlaceholders(String text, Player player) {
        if (this.gHoloMain.hasPlaceholderAPILink()) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

