/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.util;

import dev.geco.gholo.GHoloMain;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class ImageUtil {
    public static final ChatColor DEFAULT_TRANSPARENCY_COLOR = ChatColor.GRAY;
    public static final List<String> IMAGE_TYPES = Arrays.asList("avatar", "helm", "file", "url");
    public static final File IMAGE_FOLDER = new File(GHoloMain.getInstance().getDataFolder(), "images/");
    private static final String AVATAR_URL_WITH_OVERLAY = "https://minotar.net/helm/";
    private static final String AVATAR_URL_WITHOUT_OVERLAY = "https://minotar.net/avatar/";
    private static final int DEFAULT_AVATAR_SIZE = 32;
    private final String[] lines;

    public List<String> getLines() {
        return new ArrayList<String>(Arrays.asList(this.lines));
    }

    public static void generateFolder() {
        if (!IMAGE_FOLDER.exists()) {
            IMAGE_FOLDER.mkdir();
        }
    }

    public static BufferedImage getBufferedImage(String url) {
        try {
            return ImageIO.read(new URL(url));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static BufferedImage getBufferedImage(OfflinePlayer offlinePlayer, boolean useOverlay) {
        try {
            return ImageIO.read(new URL((useOverlay ? AVATAR_URL_WITH_OVERLAY : AVATAR_URL_WITHOUT_OVERLAY) + offlinePlayer.getName() + "/32"));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static BufferedImage getBufferedImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public ImageUtil(BufferedImage image) {
        this.lines = this.toLines(this.toColorArray(image, image.getWidth(), image.getHeight()));
    }

    public ImageUtil(BufferedImage image, int size) {
        if (size <= 0) {
            size = 1;
        }
        this.lines = this.toLines(this.toColorArray(image, size, size));
    }

    public ImageUtil(BufferedImage image, int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.lines = this.toLines(this.toColorArray(image, width, height));
    }

    private String[] toLines(String[][] content) {
        String[] lines = new String[content[0].length];
        String transparencyColor = DEFAULT_TRANSPARENCY_COLOR.toString();
        String emptyPlaceholder = " [|] ";
        String fillPlaceholder = "[X]";
        for (int y = 0; y < content[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            String resetColor = ChatColor.RESET.toString();
            for (String[] color : content) {
                String currentColor = color[y];
                if (currentColor == null) {
                    if (!resetColor.equals(transparencyColor)) {
                        line.append(transparencyColor);
                        resetColor = transparencyColor;
                    }
                    line.append(emptyPlaceholder);
                    continue;
                }
                if (!resetColor.equals(currentColor)) {
                    line.append(currentColor);
                    resetColor = currentColor;
                }
                line.append(fillPlaceholder);
            }
            lines[y] = line.toString();
        }
        return lines;
    }

    private String[][] toColorArray(BufferedImage image, int width, int height) {
        BufferedImage resizedImage = width != image.getWidth() || height != image.getHeight() ? this.resizeImage(image, width, height) : image;
        String[][] colorArray = new String[resizedImage.getWidth()][resizedImage.getHeight()];
        for (int x = 0; x < resizedImage.getWidth(); ++x) {
            for (int y = 0; y < resizedImage.getHeight(); ++y) {
                colorArray[x][y] = this.getHexColor(resizedImage.getRGB(x, y));
            }
        }
        return colorArray;
    }

    private BufferedImage resizeImage(BufferedImage image, int width, int height) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale((double)width / (double)image.getWidth(), (double)height / (double)image.getHeight());
        AffineTransformOp operation = new AffineTransformOp(affineTransform, 1);
        return operation.filter(image, null);
    }

    private String getHexColor(int color) {
        if ((color >> 24 & 0xFF) < 128) {
            return null;
        }
        return "#" + String.format("%08x", color).substring(2);
    }
}

