/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class UpdateService {
    private final String REMOTE_URL = "https://api.spigotmc.org/legacy/update.php?resource=";
    private final GHoloMain gHoloMain;
    private LocalDate lastCheckDate = null;
    private String latestVersion = null;
    private boolean isLatestVersion = true;

    public UpdateService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public void checkForUpdates() {
        if (!this.gHoloMain.getConfigService().CHECK_FOR_UPDATE) {
            return;
        }
        this.checkVersion();
        if (this.isLatestVersion) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.gHoloMain.getPermissionService().hasPermission((Permissible)player, "Update")) continue;
            Object[] objectArray = new Object[8];
            objectArray[0] = "%Name%";
            objectArray[1] = "GHolo";
            objectArray[2] = "%NewVersion%";
            objectArray[3] = this.latestVersion;
            objectArray[4] = "%Version%";
            objectArray[5] = this.gHoloMain.getDescription().getVersion();
            objectArray[6] = "%Path%";
            objectArray[7] = this.gHoloMain.getDescription().getWebsite();
            this.gHoloMain.getMessageService().sendMessage((CommandSender)player, "Plugin.plugin-update", objectArray);
        }
        Object[] objectArray = new Object[8];
        objectArray[0] = "%Name%";
        objectArray[1] = "GHolo";
        objectArray[2] = "%NewVersion%";
        objectArray[3] = this.latestVersion;
        objectArray[4] = "%Version%";
        objectArray[5] = this.gHoloMain.getDescription().getVersion();
        objectArray[6] = "%Path%";
        objectArray[7] = this.gHoloMain.getDescription().getWebsite();
        this.gHoloMain.getMessageService().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-update", objectArray);
    }

    public void checkForUpdates(Player player) {
        if (!this.gHoloMain.getConfigService().CHECK_FOR_UPDATE) {
            return;
        }
        if (!this.gHoloMain.getPermissionService().hasPermission((Permissible)player, "Update")) {
            return;
        }
        this.checkVersion();
        if (this.isLatestVersion) {
            return;
        }
        Object[] objectArray = new Object[8];
        objectArray[0] = "%Name%";
        objectArray[1] = "GHolo";
        objectArray[2] = "%NewVersion%";
        objectArray[3] = this.latestVersion;
        objectArray[4] = "%Version%";
        objectArray[5] = this.gHoloMain.getDescription().getVersion();
        objectArray[6] = "%Path%";
        objectArray[7] = this.gHoloMain.getDescription().getWebsite();
        this.gHoloMain.getMessageService().sendMessage((CommandSender)player, "Plugin.plugin-update", objectArray);
    }

    private void getSpigotVersion(Consumer<String> versionConsumer) {
        this.gHoloMain.getTaskService().run(() -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + "121144").openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext() && versionConsumer != null) {
                    versionConsumer.accept(scanner.next());
                }
            }
            catch (IOException e) {
                if (e.getMessage().contains("50")) {
                    return;
                }
                this.gHoloMain.getLogger().log(Level.SEVERE, "Could not get remote version!", e);
            }
        }, false);
    }

    private void checkVersion() {
        LocalDate today = LocalDate.now();
        if (this.lastCheckDate != null && this.lastCheckDate.equals(today)) {
            return;
        }
        this.lastCheckDate = today;
        try {
            this.getSpigotVersion(spigotVersion -> {
                this.latestVersion = spigotVersion;
                if (this.latestVersion == null) {
                    this.isLatestVersion = true;
                    return;
                }
                String pluginVersion = this.gHoloMain.getDescription().getVersion();
                String[] pluginVersionParts = this.getShortVersion(pluginVersion).split("\\.");
                String[] spigotVersionParts = this.getShortVersion(this.latestVersion).split("\\.");
                int minLength = Math.min(pluginVersionParts.length, spigotVersionParts.length);
                for (int i = 0; i < minLength; ++i) {
                    int spigotPart;
                    int pluginPart = Integer.parseInt(pluginVersionParts[i]);
                    if (pluginPart < (spigotPart = Integer.parseInt(spigotVersionParts[i]))) {
                        this.isLatestVersion = false;
                        return;
                    }
                    if (pluginPart <= spigotPart) continue;
                    this.isLatestVersion = true;
                    return;
                }
                this.isLatestVersion = pluginVersionParts.length >= spigotVersionParts.length;
            });
        }
        catch (Throwable e) {
            this.isLatestVersion = true;
        }
    }

    private String getShortVersion(String version) {
        return version.replaceAll("[\\[\\] ]", "");
    }
}

