/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskService {
    private final GHoloMain gHoloMain;
    private final HashMap<UUID, Object> tasks = new HashMap();

    public TaskService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public List<UUID> getTasks() {
        return new ArrayList<UUID>(this.tasks.keySet());
    }

    public UUID run(Runnable runnable) {
        return this.run(runnable, true, null, null);
    }

    public UUID run(Runnable runnable, boolean sync) {
        return this.run(runnable, sync, null, null);
    }

    public UUID run(Runnable runnable, Entity entity) {
        return this.run(runnable, true, entity, null);
    }

    public UUID run(Runnable runnable, boolean sync, Entity entity) {
        return this.run(runnable, sync, entity, null);
    }

    public UUID run(Runnable runnable, Location location) {
        return this.run(runnable, true, null, location);
    }

    public UUID run(Runnable runnable, boolean sync, Location location) {
        return this.run(runnable, sync, null, location);
    }

    private UUID run(final Runnable runnable, boolean sync, Entity entity, Location location) {
        final UUID taskId = UUID.randomUUID();
        if (this.gHoloMain.supportsTaskFeature()) {
            if (entity != null) {
                this.tasks.put(taskId, entity.getScheduler().run((Plugin)this.gHoloMain, scheduledTask -> {
                    runnable.run();
                    this.tasks.remove(taskId);
                }, null));
                return taskId;
            }
            ScheduledTask task = location != null ? Bukkit.getRegionScheduler().run((Plugin)this.gHoloMain, location, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }) : (sync ? Bukkit.getGlobalRegionScheduler().run((Plugin)this.gHoloMain, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }) : Bukkit.getAsyncScheduler().runNow((Plugin)this.gHoloMain, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }));
            this.tasks.put(taskId, task);
        } else {
            BukkitRunnable task = new BukkitRunnable(this){
                final /* synthetic */ TaskService this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    runnable.run();
                    this.this$0.tasks.remove(taskId);
                }
            };
            this.tasks.put(taskId, task);
            if (sync) {
                task.runTask((Plugin)this.gHoloMain);
            } else {
                task.runTaskAsynchronously((Plugin)this.gHoloMain);
            }
        }
        return taskId;
    }

    public UUID runDelayed(Runnable runnable, long ticks) {
        return this.runDelayed(runnable, true, null, null, ticks);
    }

    public UUID runDelayed(Runnable runnable, boolean sync, long ticks) {
        return this.runDelayed(runnable, sync, null, null, ticks);
    }

    public UUID runDelayed(Runnable runnable, Entity entity, long ticks) {
        return this.runDelayed(runnable, true, entity, null, ticks);
    }

    public UUID runDelayed(Runnable runnable, boolean sync, Entity entity, long ticks) {
        return this.runDelayed(runnable, sync, entity, null, ticks);
    }

    public UUID runDelayed(Runnable runnable, Location location, long ticks) {
        return this.runDelayed(runnable, true, null, location, ticks);
    }

    public UUID runDelayed(Runnable runnable, boolean sync, Location location, long ticks) {
        return this.runDelayed(runnable, sync, null, location, ticks);
    }

    private UUID runDelayed(final Runnable runnable, boolean sync, Entity entity, Location location, long ticks) {
        final UUID taskId = UUID.randomUUID();
        if (this.gHoloMain.supportsTaskFeature()) {
            if (ticks <= 0L) {
                return this.run(runnable, sync, entity);
            }
            if (entity != null) {
                this.tasks.put(taskId, entity.getScheduler().runDelayed((Plugin)this.gHoloMain, scheduledTask -> {
                    runnable.run();
                    this.tasks.remove(taskId);
                }, null, ticks));
                return taskId;
            }
            ScheduledTask task = location != null ? Bukkit.getRegionScheduler().runDelayed((Plugin)this.gHoloMain, location, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }, ticks) : (sync ? Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.gHoloMain, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }, ticks) : Bukkit.getAsyncScheduler().runDelayed((Plugin)this.gHoloMain, scheduledTask -> {
                runnable.run();
                this.tasks.remove(taskId);
            }, ticks * 50L, TimeUnit.MILLISECONDS));
            this.tasks.put(taskId, task);
        } else {
            BukkitRunnable task = new BukkitRunnable(this){
                final /* synthetic */ TaskService this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    runnable.run();
                    this.this$0.tasks.remove(taskId);
                }
            };
            this.tasks.put(taskId, task);
            if (sync) {
                task.runTaskLater((Plugin)this.gHoloMain, ticks);
            } else {
                task.runTaskLaterAsynchronously((Plugin)this.gHoloMain, ticks);
            }
        }
        return taskId;
    }

    public UUID runAtFixedRate(Runnable runnable, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, true, null, null, delayTicks, ticks);
    }

    public UUID runAtFixedRate(Runnable runnable, boolean sync, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, sync, null, null, delayTicks, ticks);
    }

    public UUID runAtFixedRate(Runnable runnable, Entity entity, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, true, entity, null, delayTicks, ticks);
    }

    public UUID runAtFixedRate(Runnable runnable, boolean sync, Entity entity, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, sync, entity, null, delayTicks, ticks);
    }

    public UUID runAtFixedRate(Runnable runnable, Location location, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, true, null, location, delayTicks, ticks);
    }

    public UUID runAtFixedRate(Runnable runnable, boolean sync, Location location, long delayTicks, long ticks) {
        return this.runAtFixedRate(runnable, sync, null, location, delayTicks, ticks);
    }

    private UUID runAtFixedRate(final Runnable runnable, boolean sync, Entity entity, Location location, long delayTicks, long ticks) {
        UUID taskId = UUID.randomUUID();
        if (this.gHoloMain.supportsTaskFeature()) {
            if (entity != null) {
                this.tasks.put(taskId, entity.getScheduler().runAtFixedRate((Plugin)this.gHoloMain, scheduledTask -> runnable.run(), null, delayTicks <= 0L ? 1L : delayTicks, ticks <= 0L ? 1L : ticks));
                return taskId;
            }
            ScheduledTask task = location != null ? Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this.gHoloMain, location, scheduledTask -> runnable.run(), delayTicks <= 0L ? 1L : delayTicks, ticks <= 0L ? 1L : ticks) : (sync ? Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.gHoloMain, scheduledTask -> runnable.run(), delayTicks <= 0L ? 1L : delayTicks, ticks <= 0L ? 1L : ticks) : Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.gHoloMain, scheduledTask -> runnable.run(), delayTicks <= 0L ? 1L : delayTicks * 50L, (ticks <= 0L ? 1L : ticks) * 50L, TimeUnit.MILLISECONDS));
            this.tasks.put(taskId, task);
        } else {
            BukkitRunnable task = new BukkitRunnable(this){
                final /* synthetic */ TaskService this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    runnable.run();
                }
            };
            this.tasks.put(taskId, task);
            if (sync) {
                task.runTaskTimer((Plugin)this.gHoloMain, delayTicks, ticks);
            } else {
                task.runTaskTimerAsynchronously((Plugin)this.gHoloMain, delayTicks, ticks);
            }
        }
        return taskId;
    }

    public void cancel(UUID taskId) {
        if (!this.tasks.containsKey(taskId)) {
            return;
        }
        Object task = this.tasks.get(taskId);
        if (task instanceof BukkitRunnable) {
            ((BukkitRunnable)task).cancel();
        } else {
            ((ScheduledTask)task).cancel();
        }
        this.tasks.remove(taskId);
    }
}

