/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class HoloService {
    private final GHoloMain gHoloMain;
    private final List<GHolo> holos = new ArrayList<GHolo>();

    public HoloService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public void createTables() {
        try {
            this.gHoloMain.getDataService().execute("    CREATE TABLE IF NOT EXISTS gholo_holo (\n        uuid TEXT,\n        id TEXT,\n        location TEXT,\n        data TEXT\n    );\n", new Object[0]);
            this.gHoloMain.getDataService().execute("    CREATE TABLE IF NOT EXISTS gholo_holo_row (\n        position INTEGER,\n        holo_uuid TEXT,\n        content TEXT,\n        `offset` TEXT,\n        data TEXT\n    );\n", new Object[0]);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not create holo database tables!", e);
        }
    }

    public List<GHolo> getHolos() {
        return new ArrayList<GHolo>(this.holos);
    }

    public List<GHolo> getNearHolos(Location location, double range) {
        return this.holos.stream().filter(holo -> holo.getRawLocation().getWorld().equals((Object)location.getWorld()) && holo.getRawLocation().distance(location) <= range).toList();
    }

    public GHolo getHolo(String holoId) {
        return this.holos.stream().filter(holo -> holo.getId().equalsIgnoreCase(holoId)).findFirst().orElse(null);
    }

    public int getHoloCount() {
        return this.holos.size();
    }

    public int getHoloRowCount() {
        return this.holos.stream().mapToInt(holo -> holo.getRows().size()).sum();
    }

    public GHolo createHolo(String holoId, SimpleLocation location) {
        try {
            GHolo holo = new GHolo(UUID.randomUUID(), holoId, location);
            this.writeHolo(holo, false);
            this.holos.add(holo);
            return holo;
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not create holo '" + holoId + "'!", e);
            return null;
        }
    }

    public GHoloRow addHoloRow(GHolo holo, String content) {
        try {
            int position = holo.getRows().size();
            double sizeBetweenRows = this.gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
            double rowOffset = sizeBetweenRows * (double)position;
            SimpleVector offset = new SimpleVector(0.0, -rowOffset, 0.0);
            GHoloRow holoRow = new GHoloRow(holo, this.gHoloMain.getTextFormatUtil().replaceSymbols(content));
            holoRow.setOffset(offset);
            this.writeHoloRow(holoRow, position);
            holo.addRow(holoRow);
            this.gHoloMain.getEntityUtil().createHoloRowEntity(holoRow);
            this.gHoloMain.getHoloAnimationService().updateSubscriptionStatus(holoRow);
            return holoRow;
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not create holo row for holo '" + holo.getId() + "'!", e);
            return null;
        }
    }

    public GHoloRow insertHoloRow(GHolo holo, int position, String content, boolean updateOffsets) {
        try {
            double sizeBetweenRows = this.gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
            double rowOffset = sizeBetweenRows * (double)position;
            SimpleVector offset = new SimpleVector(0.0, -rowOffset, 0.0);
            if (updateOffsets) {
                SimpleVector moveOffset;
                try (ResultSet moveOffsetResultSet = this.gHoloMain.getDataService().executeAndGet("SELECT position, `offset` FROM gholo_holo_row WHERE holo_uuid = ? AND position >= ?", holo.getUuid().toString(), position);){
                    while (moveOffsetResultSet.next()) {
                        int movePosition = moveOffsetResultSet.getInt("position");
                        moveOffset = SimpleVector.fromString(moveOffsetResultSet.getString("offset"));
                        if (moveOffset == null) continue;
                        moveOffset.setY(moveOffset.getY() - sizeBetweenRows);
                        this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET `offset` = ? WHERE holo_uuid = ? AND position = ?", moveOffset.toString(), holo.getUuid().toString(), movePosition);
                    }
                }
                for (GHoloRow updateHoloRow : holo.getRows().subList(position, holo.getRows().size())) {
                    moveOffset = updateHoloRow.getOffset();
                    moveOffset.setY(moveOffset.getY() - sizeBetweenRows);
                    updateHoloRow.setOffset(moveOffset);
                    if (updateHoloRow.getHoloRowContent() == null) continue;
                    updateHoloRow.getHoloRowContent().publishUpdate(GHoloUpdateType.LOCATION);
                }
            }
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET position = position + 1 WHERE holo_uuid = ? AND position >= ?", holo.getUuid().toString(), position);
            GHoloRow holoRow = new GHoloRow(holo, this.gHoloMain.getTextFormatUtil().replaceSymbols(content));
            holoRow.setOffset(offset);
            this.writeHoloRow(holoRow, position);
            holo.insertRow(holoRow, position);
            this.gHoloMain.getEntityUtil().createHoloRowEntity(holoRow);
            this.gHoloMain.getHoloAnimationService().updateSubscriptionStatus(holoRow);
            return holoRow;
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not insert holo row for holo '" + holo.getId() + "'!", e);
            return null;
        }
    }

    public void updateHoloRowContent(GHoloRow holoRow, String content) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET content = ? WHERE position = ? AND holo_uuid = ?", content, holoRow.getPosition(), holoRow.getHolo().getUuid().toString());
            holoRow.setContent(this.gHoloMain.getTextFormatUtil().replaceSymbols(content));
            if (holoRow.getHoloRowContent() != null) {
                holoRow.getHoloRowContent().publishUpdate(GHoloUpdateType.CONTENT);
            }
            this.gHoloMain.getHoloAnimationService().updateSubscriptionStatus(holoRow);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not update holo row content of holo '" + holoRow.getHolo().getId() + "'!", e);
        }
    }

    public void updateHoloRowOffset(GHoloRow holoRow, SimpleVector offset) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET `offset` = ? WHERE position = ? AND holo_uuid = ?", offset.toString(), holoRow.getPosition(), holoRow.getHolo().getUuid().toString());
            holoRow.setOffset(offset);
            if (holoRow.getHoloRowContent() != null) {
                holoRow.getHoloRowContent().publishUpdate(GHoloUpdateType.LOCATION);
            }
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not update holo row `offset` of holo '" + holoRow.getHolo().getId() + "'!", e);
        }
    }

    public void updateHoloRowData(GHoloRow holoRow, GHoloData data) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET data = ? WHERE position = ? AND holo_uuid = ?", data.toString(), holoRow.getPosition(), holoRow.getHolo().getUuid().toString());
            holoRow.setData(data);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not update holo row data of holo '" + holoRow.getHolo().getId() + "'!", e);
        }
    }

    public void removeHoloRow(GHoloRow holoRow, boolean updateOffsets) {
        try {
            GHolo holo = holoRow.getHolo();
            int position = holoRow.getPosition();
            double sizeBetweenRows = this.gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
            this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo_row where holo_uuid = ? AND position = ?", holo.getUuid().toString(), position);
            if (updateOffsets) {
                SimpleVector moveOffset;
                try (ResultSet moveOffsetResultSet = this.gHoloMain.getDataService().executeAndGet("SELECT position, `offset` FROM gholo_holo_row WHERE holo_uuid = ? AND position > ?", holo.getUuid().toString(), position);){
                    while (moveOffsetResultSet.next()) {
                        int movePosition = moveOffsetResultSet.getInt("position");
                        moveOffset = SimpleVector.fromString(moveOffsetResultSet.getString("offset"));
                        if (moveOffset == null) continue;
                        moveOffset.setY(moveOffset.getY() + sizeBetweenRows);
                        this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET `offset` = ? WHERE holo_uuid = ? AND position = ?", moveOffset.toString(), holo.getUuid().toString(), movePosition);
                    }
                }
                for (GHoloRow updateHoloRow : holo.getRows().subList(position + 1, holo.getRows().size())) {
                    moveOffset = updateHoloRow.getOffset();
                    moveOffset.setY(moveOffset.getY() + sizeBetweenRows);
                    updateHoloRow.setOffset(moveOffset);
                    if (updateHoloRow.getHoloRowContent() == null) continue;
                    updateHoloRow.getHoloRowContent().publishUpdate(GHoloUpdateType.LOCATION);
                }
            }
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo_row SET position = position - 1 WHERE holo_uuid = ? AND position > ?", holo.getUuid().toString(), position);
            holo.removeRow(position);
            if (holoRow.getHoloRowContent() != null) {
                holoRow.getHoloRowContent().unloadHoloRow();
            }
            this.gHoloMain.getHoloAnimationService().unsubscribe(holoRow);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not remove holo row of holo '" + holoRow.getHolo().getId() + "'!", e);
        }
    }

    public void updateHoloId(GHolo holo, String holoId) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo SET id = ? WHERE uuid = ?", holoId, holo.getUuid().toString());
            holo.setId(holoId);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not rename holo '" + holo.getId() + "' to '" + holoId + "'!", e);
        }
    }

    public void updateHoloLocation(GHolo holo, SimpleLocation location) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo SET location = ? WHERE uuid = ?", location.toString(), holo.getUuid().toString());
            if (!holo.getRawLocation().getWorld().equals((Object)location.getWorld())) {
                this.unloadHolo(holo);
                holo.setLocation(location);
                for (GHoloRow holoRow : holo.getRows()) {
                    this.gHoloMain.getEntityUtil().createHoloRowEntity(holoRow);
                }
                return;
            }
            holo.setLocation(location);
            for (GHoloRow holoRow : holo.getRows()) {
                if (holoRow.getHoloRowContent() == null) continue;
                holoRow.getHoloRowContent().publishUpdate(GHoloUpdateType.LOCATION);
            }
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not update holo location of holo '" + holo.getId() + "'!", e);
        }
    }

    public void updateHoloData(GHolo holo, GHoloData data) {
        try {
            this.gHoloMain.getDataService().execute("UPDATE gholo_holo SET data = ? WHERE uuid = ?", data.toString(), holo.getUuid().toString());
            holo.setData(data);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not update holo data of holo '" + holo.getId() + "'!", e);
        }
    }

    public void setAllHoloRowContent(GHolo holo, List<String> rows) {
        this.unloadHolo(holo);
        holo.getRows().clear();
        try {
            this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo_row where holo_uuid = ?", holo.getUuid().toString());
            for (String row : rows) {
                this.addHoloRow(holo, row);
            }
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not set all holo rows of holo '" + holo.getId() + "'!", e);
        }
    }

    public void copyHolo(GHolo holo, String holoId) {
        try {
            GHolo newHolo = new GHolo(UUID.randomUUID(), holoId, holo.getLocation());
            newHolo.setData(holo.getData());
            this.writeHolo(newHolo, false);
            this.holos.add(newHolo);
            for (GHoloRow row : holo.getRows()) {
                GHoloRow newRow = new GHoloRow(newHolo, row.getContent());
                newRow.setOffset(row.getOffset());
                newRow.setData(row.getData());
                this.writeHoloRow(newRow, row.getPosition());
                newHolo.addRow(newRow);
                this.gHoloMain.getEntityUtil().createHoloRowEntity(newRow);
                this.gHoloMain.getHoloAnimationService().updateSubscriptionStatus(newRow);
            }
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not copy holo '" + holo.getId() + "' to '" + holoId + "'!", e);
        }
    }

    public void removeHolo(GHolo holo) {
        try {
            this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo WHERE uuid = ?", holo.getUuid().toString());
            this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo_row WHERE holo_uuid = ?", holo.getUuid().toString());
            this.holos.remove(holo);
            for (GHoloRow holoRow : holo.getRows()) {
                this.gHoloMain.getHoloAnimationService().unsubscribe(holoRow);
            }
            this.unloadHolo(holo);
        }
        catch (SQLException e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not remove holo '" + holo.getId() + "'!", e);
        }
    }

    public void loadHolos(@Nullable World world) {
        block22: {
            try {
                List<UUID> loadedHolos = this.holos.stream().map(GHolo::getUuid).toList();
                ResultSet resultSet = this.gHoloMain.getDataService().executeAndGet("SELECT * FROM gholo_holo", new Object[0]);
                block15: while (true) {
                    block16: while (resultSet.next()) {
                        String id = resultSet.getString("id");
                        try {
                            UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                            if (loadedHolos.contains(uuid)) continue;
                            SimpleLocation location = SimpleLocation.fromString(resultSet.getString("location"));
                            if (location == null || location.getWorld() == null) continue block15;
                            if (world != null && world.equals((Object)location.getWorld())) continue;
                            GHolo holo = new GHolo(uuid, id, location);
                            String dataString = resultSet.getString("data");
                            holo.getRawData().loadString(dataString);
                            ResultSet rowResultSet = this.gHoloMain.getDataService().executeAndGet("SELECT * FROM gholo_holo_row where holo_uuid = ?", uuid.toString());
                            try {
                                TreeMap<Integer, GHoloRow> holoRowMap = new TreeMap<Integer, GHoloRow>();
                                while (rowResultSet.next()) {
                                    int position = rowResultSet.getInt("position");
                                    String content = this.gHoloMain.getTextFormatUtil().replaceSymbols(rowResultSet.getString("content"));
                                    SimpleVector offset = SimpleVector.fromString(rowResultSet.getString("offset"));
                                    if (offset == null) {
                                        this.gHoloMain.getLogger().warning("Could not load holo row '" + position + "' of holo '" + id + "', invalid location!");
                                        continue block16;
                                    }
                                    GHoloRow holoRow = new GHoloRow(holo, content);
                                    holoRow.setOffset(offset);
                                    String rowDataString = rowResultSet.getString("data");
                                    holoRow.getRawData().loadString(rowDataString);
                                    holoRowMap.put(position, holoRow);
                                }
                                for (GHoloRow holoRow : holoRowMap.values()) {
                                    holo.addRow(holoRow);
                                    this.gHoloMain.getEntityUtil().createHoloRowEntity(holoRow);
                                    this.gHoloMain.getHoloAnimationService().updateSubscriptionStatus(holoRow);
                                }
                            }
                            finally {
                                if (rowResultSet == null) continue block15;
                                rowResultSet.close();
                                continue;
                            }
                            this.holos.add(holo);
                            continue block15;
                        }
                        catch (Throwable e) {
                            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not load holo '" + id + "'!", e);
                        }
                    }
                    break block22;
                    {
                        continue block15;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (SQLException e) {
                this.gHoloMain.getLogger().log(Level.SEVERE, "Could not load holos!", e);
            }
        }
    }

    public void loadHolosForPlayer(Player player) {
        for (GHolo holo : this.holos) {
            this.loadHoloForPlayer(holo, player);
        }
    }

    public void loadHolo(GHolo holo) {
        for (Player player : holo.getRawLocation().getWorld().getPlayers()) {
            this.loadHoloForPlayer(holo, player);
        }
    }

    public void loadHoloForPlayer(GHolo holo, Player player) {
        for (GHoloRow row : holo.getRows()) {
            if (row.getHoloRowContent() == null) continue;
            row.getHoloRowContent().loadHoloRow(player);
        }
    }

    public void unloadHolosForPlayer(Player player) {
        for (GHolo holo : this.holos) {
            this.unloadHoloForPlayer(holo, player);
        }
    }

    public void unloadHolo(GHolo holo) {
        for (Player player : holo.getRawLocation().getWorld().getPlayers()) {
            this.unloadHoloForPlayer(holo, player);
        }
    }

    public void unloadHoloForPlayer(GHolo holo, Player player) {
        for (GHoloRow row : holo.getRows()) {
            if (row.getHoloRowContent() == null) continue;
            row.getHoloRowContent().unloadHoloRow(player);
        }
    }

    public void clearHolosCurrentContentForPlayer(Player player) {
        for (GHolo holo : this.holos) {
            this.clearHoloCurrentContentForPlayer(holo, player);
        }
    }

    private void clearHoloCurrentContentForPlayer(GHolo holo, Player player) {
        for (GHoloRow row : holo.getRows()) {
            if (row.getHoloRowContent() == null) continue;
            row.getHoloRowContent().getCurrentContentTypes().remove(player.getUniqueId());
        }
    }

    public void unloadHolos(@Nullable World world) {
        for (GHolo holo2 : this.holos) {
            if (world != null && world.equals((Object)holo2.getRawLocation().getWorld())) continue;
            for (GHoloRow holoRow : holo2.getRows()) {
                this.gHoloMain.getHoloAnimationService().unsubscribe(holoRow);
            }
            this.unloadHolo(holo2);
        }
        if (world == null) {
            this.holos.clear();
        } else {
            this.holos.removeIf(holo -> holo.getRawLocation().getWorld().equals((Object)world));
        }
    }

    public void writeHolo(GHolo holo, boolean override) throws SQLException {
        if (override) {
            ResultSet resultSet = this.gHoloMain.getDataService().executeAndGet("SELECT uuid FROM gholo_holo WHERE id = ?", holo.getId());
            while (resultSet.next()) {
                String uuid = resultSet.getString("uuid");
                this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo WHERE uuid = ?", uuid);
                this.gHoloMain.getDataService().execute("DELETE FROM gholo_holo_row WHERE holo_uuid = ?", uuid);
            }
        }
        this.gHoloMain.getDataService().execute("INSERT INTO gholo_holo (uuid, id, location, data) VALUES (?, ?, ?, ?)", holo.getUuid().toString(), holo.getId(), holo.getRawLocation().toString(), holo.getData().toString());
    }

    public void writeHoloRow(GHoloRow holoRow, int position) throws SQLException {
        this.gHoloMain.getDataService().execute("INSERT INTO gholo_holo_row (position, holo_uuid, content, `offset`, data) VALUES (?, ?, ?, ?, ?)", position, holoRow.getHolo().getUuid().toString(), holoRow.getContent(), holoRow.getRawOffset().toString(), holoRow.getRawData().toString());
    }
}

