/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.importer.GHoloImporter;
import dev.geco.gholo.object.holo.importer.impl.DatabaseV1Importer;
import dev.geco.gholo.object.holo.importer.impl.DecentHologramsImporter;
import dev.geco.gholo.object.holo.importer.impl.FancyHologramsImporter;
import dev.geco.gholo.object.holo.importer.impl.FilesImporter;
import dev.geco.gholo.object.holo.importer.impl.HolographicDisplaysImporter;
import java.io.File;
import java.util.HashMap;

public class HoloImporterService {
    private final GHoloMain gHoloMain;
    private final HashMap<String, GHoloImporter> holoImporters = new HashMap();

    public HoloImporterService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public HashMap<String, GHoloImporter> getHoloImporters() {
        return this.holoImporters;
    }

    public GHoloImporter getHoloImporter(String type) {
        return this.holoImporters.get(type.toLowerCase());
    }

    public void registerHoloImporter(GHoloImporter holoImporter) {
        this.holoImporters.put(holoImporter.getType().toLowerCase(), holoImporter);
    }

    public void registerDefaultHoloImporters() {
        File holoFileDir = new File(this.gHoloMain.getDataFolder(), "holos");
        if (!holoFileDir.exists()) {
            holoFileDir.mkdir();
        }
        this.registerHoloImporter(new FilesImporter());
        this.registerHoloImporter(new DecentHologramsImporter());
        this.registerHoloImporter(new HolographicDisplaysImporter());
        this.registerHoloImporter(new FancyHologramsImporter());
        this.registerHoloImporter(new DatabaseV1Importer());
    }

    public void unregisterHoloImporters() {
        this.holoImporters.clear();
    }
}

