/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloAnimation;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class HoloAnimationService {
    public static final char AMIMATION_CHAR = '%';
    private final GHoloMain gHoloMain;
    private final HashMap<String, GHoloAnimation> animations = new HashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<GHoloRow>> animationSubscriber = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<GHoloRow> placeholderAPISubscriber = new ConcurrentLinkedQueue();
    private final Set<UUID> taskIds = new HashSet<UUID>();

    public HoloAnimationService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public Collection<GHoloAnimation> getAnimations() {
        return this.animations.values();
    }

    public void loadHoloAnimations() {
        this.stopHoloAnimations();
        File animationsFile = new File(this.gHoloMain.getDataFolder(), "animations.yml");
        if (!animationsFile.exists()) {
            this.gHoloMain.saveResource("animations.yml", false);
        }
        YamlConfiguration animationsData = YamlConfiguration.loadConfiguration((File)animationsFile);
        try {
            for (String id : animationsData.getConfigurationSection("Animations").getKeys(false)) {
                long ticks = animationsData.getLong("Animations." + id + ".ticks");
                if (ticks <= 0L) {
                    this.gHoloMain.getLogger().warning("Could not load animation '" + id + "', ticks must be greater than 0!");
                    continue;
                }
                this.animations.put(id.toLowerCase(), new GHoloAnimation(id.toLowerCase(), ticks, animationsData.getStringList("Animations." + id + ".content")));
                this.animationSubscriber.put(id.toLowerCase(), new ConcurrentLinkedQueue());
            }
            this.startHoloAnimations();
        }
        catch (Throwable e) {
            this.gHoloMain.getLogger().log(Level.SEVERE, "Could not load animations!", e);
        }
    }

    public void updateSubscriptionStatus(GHoloRow holoRow) {
        for (GHoloAnimation animation : this.animations.values()) {
            if (holoRow.getContent().contains("%" + animation.getId() + "%")) {
                this.animationSubscriber.get(animation.getId()).add(holoRow);
                continue;
            }
            this.animationSubscriber.get(animation.getId()).remove(holoRow);
        }
        if (!this.gHoloMain.hasPlaceholderAPILink() || HoloAnimationService.countAnimationChars(holoRow.getContent()) < 2) {
            return;
        }
        this.placeholderAPISubscriber.add(holoRow);
    }

    public void unsubscribe(GHoloRow holoRow) {
        for (ConcurrentLinkedQueue<GHoloRow> holoRows : this.animationSubscriber.values()) {
            holoRows.remove(holoRow);
        }
        this.placeholderAPISubscriber.remove(holoRow);
    }

    private void startHoloAnimations() {
        for (GHoloAnimation animation : this.animations.values()) {
            UUID taskId = this.gHoloMain.getTaskService().runAtFixedRate(() -> {
                animation.updatePosition();
                for (GHoloRow holoRow : this.animationSubscriber.get(animation.getId().toLowerCase())) {
                    holoRow.getHoloRowContent().publishUpdate(GHoloUpdateType.CONTENT);
                }
            }, false, 0L, animation.getTicks());
            this.taskIds.add(taskId);
        }
        if (!this.gHoloMain.hasPlaceholderAPILink()) {
            return;
        }
        UUID placeholderAPITaskId = this.gHoloMain.getTaskService().runAtFixedRate(() -> {
            for (GHoloRow holoRow : this.placeholderAPISubscriber) {
                holoRow.getHoloRowContent().publishUpdate(GHoloUpdateType.CONTENT);
            }
        }, false, 0L, 10L);
        this.taskIds.add(placeholderAPITaskId);
    }

    public void stopHoloAnimations() {
        for (UUID taskId : this.taskIds) {
            this.gHoloMain.getTaskService().cancel(taskId);
        }
        this.taskIds.clear();
        this.animations.clear();
        this.animationSubscriber.clear();
        this.placeholderAPISubscriber.clear();
    }

    public static int countAnimationChars(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '%') continue;
            ++count;
        }
        return count;
    }
}

