/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.service;

import dev.geco.gholo.GHoloMain;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConfigurationOptions;

public class ConfigService {
    public String L_LANG;
    public boolean L_CLIENT_LANG;
    public boolean CHECK_FOR_UPDATE;
    public double DEFAULT_SIZE_BETWEEN_ROWS;
    public int LIST_PAGE_SIZE;
    public double NEAR_RANGE;
    public HashMap<String, String> SYMBOLS = new HashMap();
    public List<String> FEATUREFLAGS = new ArrayList<String>();
    private final GHoloMain gHoloMain;

    public ConfigService(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
        try {
            File configFile = new File(gHoloMain.getDataFolder(), "config.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            InputStream configSteam = gHoloMain.getResource("config.yml");
            if (configSteam != null) {
                YamlConfiguration configSteamConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(configSteam, StandardCharsets.UTF_8));
                if (!config.getKeys(true).equals(configSteamConfig.getKeys(true))) {
                    config.setDefaults((Configuration)configSteamConfig);
                    YamlConfigurationOptions options = (YamlConfigurationOptions)config.options();
                    options.parseComments(true).copyDefaults(true).width(500);
                    config.loadFromString(config.saveToString());
                    for (String comments : config.getKeys(true)) {
                        config.setComments(comments, configSteamConfig.getComments(comments));
                    }
                    config.save(configFile);
                }
            } else {
                gHoloMain.saveDefaultConfig();
            }
        }
        catch (Throwable e) {
            gHoloMain.saveDefaultConfig();
        }
        this.reload();
    }

    public void reload() {
        this.gHoloMain.reloadConfig();
        this.L_LANG = this.gHoloMain.getConfig().getString("Lang.lang", "en_us").toLowerCase();
        this.L_CLIENT_LANG = this.gHoloMain.getConfig().getBoolean("Lang.client-lang", true);
        this.CHECK_FOR_UPDATE = this.gHoloMain.getConfig().getBoolean("Options.check-for-update", true);
        this.DEFAULT_SIZE_BETWEEN_ROWS = this.gHoloMain.getConfig().getDouble("Options.default-size-between-rows", 0.26);
        this.LIST_PAGE_SIZE = this.gHoloMain.getConfig().getInt("Options.list-page-size", 10);
        this.NEAR_RANGE = this.gHoloMain.getConfig().getDouble("Options.near-range", 20.0);
        this.SYMBOLS.clear();
        try {
            ConfigurationSection symbolsSection = this.gHoloMain.getConfig().getConfigurationSection("Options.Symbols");
            if (symbolsSection != null) {
                for (String symbol : symbolsSection.getKeys(false)) {
                    this.SYMBOLS.put(symbol, String.valueOf(this.gHoloMain.getConfig().getString("Options.Symbols." + symbol).toCharArray()[0]));
                }
            }
        }
        catch (Throwable e) {
            this.gHoloMain.getLogger().log(Level.WARNING, "Could not load config symbols correctly!", e);
        }
        this.FEATUREFLAGS = this.gHoloMain.getConfig().getStringList("Options.FeatureFlags");
    }
}

