/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.simple;

import dev.geco.gholo.GHoloMain;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SimpleVector
implements Cloneable {
    private double x;
    private double y;
    private double z;

    public SimpleVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    @NotNull
    public SimpleVector setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    @NotNull
    public SimpleVector setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    @NotNull
    public SimpleVector setZ(double z) {
        this.z = z;
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject simpleVector = new JSONObject();
        if (this.x != 0.0) {
            simpleVector.put((Object)"x", (Object)this.x);
        }
        if (this.y != 0.0) {
            simpleVector.put((Object)"y", (Object)this.y);
        }
        if (this.z != 0.0) {
            simpleVector.put((Object)"z", (Object)this.z);
        }
        return simpleVector.toJSONString();
    }

    @Nullable
    public static SimpleVector fromString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            double x = data.get((Object)"x") != null ? ((Number)data.get((Object)"x")).doubleValue() : 0.0;
            double y = data.get((Object)"y") != null ? ((Number)data.get((Object)"y")).doubleValue() : 0.0;
            double z = data.get((Object)"z") != null ? ((Number)data.get((Object)"z")).doubleValue() : 0.0;
            return new SimpleVector(x, y, z);
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load vector data!", e);
            return null;
        }
    }

    @NotNull
    public SimpleVector clone() {
        try {
            return (SimpleVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

