/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.simple;

import dev.geco.gholo.GHoloMain;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SimpleSize
implements Cloneable {
    private float width;
    private float height;

    public SimpleSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    @NotNull
    public SimpleSize setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    @NotNull
    public SimpleSize setHeight(float height) {
        this.height = height;
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject simpleSize = new JSONObject();
        simpleSize.put((Object)"width", (Object)Float.valueOf(this.width));
        simpleSize.put((Object)"height", (Object)Float.valueOf(this.height));
        return simpleSize.toJSONString();
    }

    @Nullable
    public static SimpleSize fromString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            float width = ((Number)data.get((Object)"width")).floatValue();
            float height = ((Number)data.get((Object)"height")).floatValue();
            return new SimpleSize(width, height);
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load size data!", e);
            return null;
        }
    }

    @NotNull
    public SimpleSize clone() {
        try {
            return (SimpleSize)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

