/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.simple;

import dev.geco.gholo.GHoloMain;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SimpleRotation
implements Cloneable {
    private Float yaw;
    private Float pitch;

    public SimpleRotation(@Nullable Float yaw, @Nullable Float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Nullable
    public Float getYaw() {
        return this.yaw;
    }

    @NotNull
    public SimpleRotation setYaw(@Nullable Float yaw) {
        this.yaw = yaw;
        return this;
    }

    @Nullable
    public Float getPitch() {
        return this.pitch;
    }

    @NotNull
    public SimpleRotation setPitch(@Nullable Float pitch) {
        this.pitch = pitch;
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject simpleRotation = new JSONObject();
        if (this.yaw != null) {
            simpleRotation.put((Object)"yaw", (Object)this.yaw);
        }
        if (this.pitch != null) {
            simpleRotation.put((Object)"pitch", (Object)this.pitch);
        }
        return simpleRotation.toJSONString();
    }

    @Nullable
    public static SimpleRotation fromString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            Float yaw = data.get((Object)"yaw") != null ? Float.valueOf(((Number)data.get((Object)"yaw")).floatValue()) : null;
            Float pitch = data.get((Object)"pitch") != null ? Float.valueOf(((Number)data.get((Object)"pitch")).floatValue()) : null;
            return new SimpleRotation(yaw, pitch);
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load rotation data!", e);
            return null;
        }
    }

    @NotNull
    public SimpleRotation clone() {
        try {
            return (SimpleRotation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

