/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.simple;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.simple.SimpleVector;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SimpleLocation
extends Location {
    public SimpleLocation(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @NotNull
    public SimpleLocation add(@NotNull SimpleVector offset) {
        this.setX(this.getX() + offset.getX());
        this.setY(this.getY() + offset.getY());
        this.setZ(this.getZ() + offset.getZ());
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject simpleLocation = new JSONObject();
        simpleLocation.put((Object)"world", (Object)this.getWorld().getName());
        simpleLocation.put((Object)"x", (Object)this.getX());
        simpleLocation.put((Object)"y", (Object)this.getY());
        simpleLocation.put((Object)"z", (Object)this.getZ());
        return simpleLocation.toJSONString();
    }

    @Nullable
    public static SimpleLocation fromString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            World world = Bukkit.getWorld((String)((String)data.get((Object)"world")));
            double x = ((Number)data.get((Object)"x")).doubleValue();
            double y = ((Number)data.get((Object)"y")).doubleValue();
            double z = ((Number)data.get((Object)"z")).doubleValue();
            return new SimpleLocation(world, x, y, z);
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load location data!", e);
            return null;
        }
    }

    @NotNull
    public static SimpleLocation fromBukkitLocation(@NotNull Location location) {
        return new SimpleLocation(location.getWorld(), location.getX(), location.getY(), location.getZ());
    }

    @NotNull
    public SimpleLocation clone() {
        return (SimpleLocation)super.clone();
    }
}

