/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.interaction.exporter.impl;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.interaction.GInteraction;
import dev.geco.gholo.object.interaction.GInteractionAction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.exporter.GInteractionExporter;
import dev.geco.gholo.object.interaction.exporter.GInteractionExporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FilesExporter
extends GInteractionExporter {
    @Override
    @NotNull
    public String getType() {
        return "files";
    }

    @Override
    @NotNull
    public GInteractionExporterResult exportInteractions(@NotNull GHoloMain gHoloMain, boolean override) {
        int exported = 0;
        List<GInteraction> interactions = gHoloMain.getInteractionService().getInteractions();
        if (interactions.isEmpty()) {
            return new GInteractionExporterResult(true, exported);
        }
        File interactionFileDir = new File(gHoloMain.getDataFolder(), "interactions");
        if (interactionFileDir.exists()) {
            interactionFileDir.mkdir();
        }
        for (GInteraction interaction : interactions) {
            try {
                File interactionFile = new File(interactionFileDir.getPath(), interaction.getId() + ".yml");
                if (!override && interactionFile.exists()) continue;
                FilesExporter.getInteractionFileStructure(interaction).save(interactionFile);
                ++exported;
            }
            catch (Throwable e) {
                gHoloMain.getLogger().log(Level.WARNING, "Could not export interaction '" + interaction.getId() + "'!", e);
            }
        }
        return new GInteractionExporterResult(true, exported);
    }

    private static FileConfiguration getInteractionFileStructure(GInteraction interaction) {
        YamlConfiguration structure = new YamlConfiguration();
        structure.set("Interaction.location", FilesExporter.serializeLocation(interaction.getRawLocation()));
        Map<String, Object> interactionData = FilesExporter.serializeData(interaction.getRawData());
        if (!interactionData.isEmpty()) {
            structure.set("Interaction.data", interactionData);
        }
        ArrayList actions = new ArrayList();
        for (GInteractionAction interactionAction : interaction.getActions()) {
            HashMap<String, String> actionMap = new HashMap<String, String>();
            actionMap.put("type", interactionAction.getInteractionActionType().getType());
            actionMap.put("parameter", interactionAction.getParameter());
            actions.add(actionMap);
        }
        structure.set("Interaction.actions", actions);
        return structure;
    }

    private static Map<String, Object> serializeLocation(SimpleLocation location) {
        HashMap<String, Object> locationMap = new HashMap<String, Object>();
        locationMap.put("world", location.getWorld().getName());
        locationMap.put("x", location.getX());
        locationMap.put("y", location.getY());
        locationMap.put("z", location.getZ());
        return locationMap;
    }

    private static Map<String, Object> serializeData(GInteractionData data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (!Objects.equals(data.getPermission(), GInteractionData.DEFAULT_PERMISSION)) {
            dataMap.put("permission", data.getPermission());
        }
        if (data.getRawSize().getWidth() != GInteractionData.DEFAULT_SIZE.getWidth() || data.getRawSize().getHeight() != GInteractionData.DEFAULT_SIZE.getHeight()) {
            HashMap<String, Float> sizeMap = new HashMap<String, Float>();
            if (data.getRawSize().getWidth() != GInteractionData.DEFAULT_SIZE.getWidth()) {
                sizeMap.put("width", Float.valueOf(data.getRawSize().getWidth()));
            }
            if (data.getRawSize().getHeight() != GInteractionData.DEFAULT_SIZE.getHeight()) {
                sizeMap.put("height", Float.valueOf(data.getRawSize().getHeight()));
            }
            dataMap.put("size", sizeMap);
        }
        return dataMap;
    }
}

