/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.interaction;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.simple.SimpleSize;
import java.util.Objects;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GInteractionData
implements Cloneable {
    public static final String DEFAULT_PERMISSION = null;
    public static final SimpleSize DEFAULT_SIZE = new SimpleSize(1.0f, 1.0f);
    private String permission = DEFAULT_PERMISSION;
    private SimpleSize size = new SimpleSize(1.0f, 1.0f);

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public GInteractionData setPermission(@Nullable String permission) {
        this.permission = permission;
        return this;
    }

    @NotNull
    public SimpleSize getSize() {
        return this.size.clone();
    }

    @NotNull
    public SimpleSize getRawSize() {
        return this.size;
    }

    @NotNull
    public GInteractionData setSize(@NotNull SimpleSize size) {
        this.size = size.clone();
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject data = new JSONObject();
        if (!Objects.equals(this.permission, DEFAULT_PERMISSION)) {
            data.put((Object)"permission", (Object)this.permission);
        }
        if (this.size.getWidth() != DEFAULT_SIZE.getWidth() || this.size.getHeight() != DEFAULT_SIZE.getHeight()) {
            JSONObject sizeData = new JSONObject();
            sizeData.put((Object)"width", (Object)Float.valueOf(this.size.getWidth()));
            sizeData.put((Object)"height", (Object)Float.valueOf(this.size.getHeight()));
            data.put((Object)"size", (Object)sizeData);
        }
        return data.toJSONString();
    }

    @NotNull
    public GInteractionData loadString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            if (data.get((Object)"permission") != null) {
                this.permission = (String)data.get((Object)"permission");
            }
            if (data.get((Object)"size") != null) {
                JSONObject sizeData = (JSONObject)data.get((Object)"size");
                float width = sizeData.get((Object)"width") != null ? ((Number)sizeData.get((Object)"width")).floatValue() : DEFAULT_SIZE.getWidth();
                float height = sizeData.get((Object)"height") != null ? ((Number)sizeData.get((Object)"height")).floatValue() : DEFAULT_SIZE.getWidth();
                this.size = new SimpleSize(width, height);
            }
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load interaction data!", e);
        }
        return this;
    }

    @NotNull
    public static GInteractionData fromString(@NotNull String string) {
        return new GInteractionData().loadString(string);
    }

    @NotNull
    public GInteractionData clone() {
        try {
            return (GInteractionData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

