/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.interaction;

import dev.geco.gholo.object.interaction.GInteractionAction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.IGInteractionEntity;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GInteraction {
    private final UUID uuid;
    private String id;
    private SimpleLocation location;
    private final List<GInteractionAction> actions = new ArrayList<GInteractionAction>();
    private GInteractionData data = new GInteractionData();
    private IGInteractionEntity interactionEntity = null;

    public GInteraction(@NotNull UUID uuid, @NotNull String id, @NotNull SimpleLocation location) {
        this.uuid = uuid;
        this.id = id;
        this.location = location;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public GInteraction setId(@NotNull String id) {
        this.id = id;
        return this;
    }

    @NotNull
    public SimpleLocation getRawLocation() {
        return this.location.clone();
    }

    @NotNull
    public SimpleLocation getLocation() {
        return this.location;
    }

    @NotNull
    public GInteraction setLocation(@Nullable SimpleLocation location) {
        this.location = location;
        return this;
    }

    @NotNull
    public List<GInteractionAction> getActions() {
        return this.actions;
    }

    @Nullable
    public GInteractionAction getAction(int position) {
        return position >= 0 && position < this.actions.size() ? this.actions.get(position) : null;
    }

    @NotNull
    public GInteraction addAction(@NotNull GInteractionAction interactionAction) {
        this.actions.add(interactionAction);
        return this;
    }

    @NotNull
    public GInteraction insertAction(@NotNull GInteractionAction interactionAction, int position) {
        this.actions.add(position, interactionAction);
        return this;
    }

    @NotNull
    public GInteraction removeAction(int position) {
        if (position >= 0 && position < this.actions.size()) {
            this.actions.remove(position);
        }
        return this;
    }

    @NotNull
    public GInteractionData getData() {
        return this.data.clone();
    }

    @NotNull
    public GInteractionData getRawData() {
        return this.data;
    }

    @NotNull
    public GInteraction setData(@NotNull GInteractionData data) {
        this.data = data.clone();
        return this;
    }

    @Nullable
    public IGInteractionEntity getInteractionEntity() {
        return this.interactionEntity;
    }

    @NotNull
    public GInteraction setInteractionEntity(@Nullable IGInteractionEntity interactionEntity) {
        this.interactionEntity = interactionEntity;
        return this;
    }
}

