/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.holo.importer.impl;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.importer.GHoloImporter;
import dev.geco.gholo.object.holo.importer.GHoloImporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class HolographicDisplaysImporter
extends GHoloImporter {
    @Override
    @NotNull
    public String getType() {
        return "holographic_displays";
    }

    @Override
    @NotNull
    public GHoloImporterResult importHolos(@NotNull GHoloMain gHoloMain, boolean override) {
        int imported = 0;
        File contentFile = new File("plugins/HolographicDisplays/database.yml");
        if (!contentFile.exists()) {
            return new GHoloImporterResult(true, 0L);
        }
        YamlConfiguration fileContent = YamlConfiguration.loadConfiguration((File)contentFile);
        for (String id : fileContent.getConfigurationSection("").getKeys(false)) {
            try {
                String[] args;
                if (!override && gHoloMain.getHoloService().getHolo(id) != null) continue;
                if (fileContent.contains(id + ".location")) {
                    args = fileContent.getString(id + ".location", "").split(",");
                } else {
                    String basePath = id + ".position.";
                    args = new String[]{fileContent.getString(basePath + "world"), fileContent.getString(basePath + "x"), fileContent.getString(basePath + "y"), fileContent.getString(basePath + "z")};
                }
                World world = Bukkit.getWorld((String)args[0]);
                if (world == null) continue;
                List rows = fileContent.getStringList(id + ".lines");
                List removeContent = fileContent.getStringList(id + ".lines");
                for (String removeContentLine : removeContent) {
                    if (!removeContentLine.equalsIgnoreCase("null")) continue;
                    rows.remove("null");
                }
                SimpleLocation location = new SimpleLocation(world, Double.parseDouble(args[1]), Double.parseDouble(args[2]) - 0.51, Double.parseDouble(args[3]));
                GHolo holo = new GHolo(UUID.randomUUID(), id, location);
                gHoloMain.getHoloService().writeHolo(holo, override);
                double offset = 0.0;
                for (String rowContent : rows) {
                    GHoloRow row = new GHoloRow(holo, rowContent);
                    row.setOffset(new SimpleVector(0.0, offset, 0.0));
                    gHoloMain.getHoloService().writeHoloRow(row, row.getPosition());
                    offset -= gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
                }
                ++imported;
            }
            catch (Throwable e) {
                gHoloMain.getLogger().log(Level.SEVERE, "Could not import holo '" + id + "'!", e);
            }
        }
        return new GHoloImporterResult(true, imported);
    }
}

