/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.holo.importer.impl;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.importer.GHoloImporter;
import dev.geco.gholo.object.holo.importer.GHoloImporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleRotation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FancyHologramsImporter
extends GHoloImporter {
    @Override
    @NotNull
    public String getType() {
        return "fancy_holograms";
    }

    @Override
    @NotNull
    public GHoloImporterResult importHolos(@NotNull GHoloMain gHoloMain, boolean override) {
        int imported = 0;
        File contentFile = new File("plugins/FancyHolograms/holograms.yml");
        if (!contentFile.exists()) {
            return new GHoloImporterResult(true, 0L);
        }
        YamlConfiguration fileContent = YamlConfiguration.loadConfiguration((File)contentFile);
        int version = fileContent.getInt("version");
        if (version != 2) {
            return new GHoloImporterResult(true, 0L);
        }
        for (String id : fileContent.getConfigurationSection("holograms").getKeys(false)) {
            try {
                String brightness;
                boolean seeThrough;
                String billboard;
                String textAlignment;
                boolean textShadow;
                String backgroundColor;
                String type = fileContent.getString("holograms." + id + ".type", "");
                if (!type.equalsIgnoreCase("TEXT") || !override && gHoloMain.getHoloService().getHolo(id) != null) continue;
                String locationPath = "holograms." + id + ".location.";
                String worldString = fileContent.getString(locationPath + "world", "");
                World world = Bukkit.getWorld((String)worldString);
                if (world == null) {
                    throw new RuntimeException("Can not import holo with id '" + id + "', because the world is invalid!");
                }
                double x = fileContent.getDouble(locationPath + "x");
                double y = fileContent.getDouble(locationPath + "y");
                double z = fileContent.getDouble(locationPath + "z");
                SimpleLocation location = new SimpleLocation(world, x, y, z);
                GHolo holo = new GHolo(UUID.randomUUID(), id, location);
                GHoloData data = holo.getRawData();
                double range = fileContent.getDouble("holograms." + id + ".visibility_distance", 120.0);
                if (120.0 != range) {
                    data.setRange(range);
                }
                if (!"#000000".equalsIgnoreCase(backgroundColor = fileContent.getString("holograms." + id + ".background", "#000000"))) {
                    data.setBackgroundColor(backgroundColor);
                }
                if (textShadow = fileContent.getBoolean("holograms." + id + ".text_shadow", false)) {
                    data.setTextShadow(textShadow);
                }
                if (!"center".equalsIgnoreCase(textAlignment = fileContent.getString("holograms." + id + ".text_alignment", "center"))) {
                    data.setTextAlignment(textAlignment);
                }
                if (!"center".equalsIgnoreCase(billboard = fileContent.getString("holograms." + id + ".billboard", "center"))) {
                    data.setBillboard(billboard);
                }
                if (seeThrough = fileContent.getBoolean("holograms." + id + ".see_through", false)) {
                    data.setSeeThrough(seeThrough);
                }
                SimpleVector defaultScale = GHoloData.DEFAULT_SCALE;
                double scaleX = fileContent.getDouble("holograms." + id + ".scale_x", defaultScale.getX());
                double scaleY = fileContent.getDouble("holograms." + id + ".scale_y", defaultScale.getY());
                double scaleZ = fileContent.getDouble("holograms." + id + ".scale_z", defaultScale.getZ());
                if (scaleX != defaultScale.getX() || scaleY != defaultScale.getY() || scaleZ != defaultScale.getZ()) {
                    data.setScale(new SimpleVector(scaleX, scaleY, scaleZ));
                }
                SimpleRotation defaultRotation = GHoloData.DEFAULT_ROTATION;
                float yaw = (float)fileContent.getDouble(locationPath + "yaw");
                float pitch = (float)fileContent.getDouble(locationPath + "pitch");
                SimpleRotation rotation = new SimpleRotation(Float.valueOf(yaw), Float.valueOf(pitch));
                if (yaw != defaultRotation.getYaw().floatValue() || pitch != defaultRotation.getPitch().floatValue()) {
                    data.setRotation(rotation);
                }
                if ((brightness = fileContent.getString("holograms." + id + ".brightness")) != null) {
                    data.setBrightness(Byte.parseByte(brightness));
                }
                gHoloMain.getHoloService().writeHolo(holo, override);
                List rows = fileContent.getStringList("holograms." + id + ".text");
                rows.replaceAll(rowContent -> rowContent.replaceAll("(?i)<#([0-9A-F]+)>", "#$1").replaceAll("(?i)&#([0-9A-F]{6})[0-9A-F]*", "#$1"));
                double offset = 0.0;
                for (String rowContent2 : rows) {
                    GHoloRow row = new GHoloRow(holo, rowContent2);
                    row.setOffset(new SimpleVector(0.0, offset, 0.0));
                    gHoloMain.getHoloService().writeHoloRow(row, row.getPosition());
                    offset -= gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
                }
                ++imported;
            }
            catch (Throwable e) {
                gHoloMain.getLogger().log(Level.SEVERE, "Could not import holo '" + id + "'!", e);
            }
        }
        return new GHoloImporterResult(true, imported);
    }
}

