/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.holo.exporter.impl;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.exporter.GHoloExporter;
import dev.geco.gholo.object.holo.exporter.GHoloExporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FilesExporter
extends GHoloExporter {
    @Override
    @NotNull
    public String getType() {
        return "files";
    }

    @Override
    @NotNull
    public GHoloExporterResult exportHolos(@NotNull GHoloMain gHoloMain, boolean override) {
        int exported = 0;
        List<GHolo> holos = gHoloMain.getHoloService().getHolos();
        if (holos.isEmpty()) {
            return new GHoloExporterResult(true, exported);
        }
        File holoFileDir = new File(gHoloMain.getDataFolder(), "holos");
        if (holoFileDir.exists()) {
            holoFileDir.mkdir();
        }
        for (GHolo holo : holos) {
            try {
                File holoFile = new File(holoFileDir.getPath(), holo.getId() + ".yml");
                if (!override && holoFile.exists()) continue;
                FilesExporter.getHoloFileStructure(holo).save(holoFile);
                ++exported;
            }
            catch (Throwable e) {
                gHoloMain.getLogger().log(Level.WARNING, "Could not export holo '" + holo.getId() + "'!", e);
            }
        }
        return new GHoloExporterResult(true, exported);
    }

    private static FileConfiguration getHoloFileStructure(GHolo holo) {
        YamlConfiguration structure = new YamlConfiguration();
        structure.set("Holo.location", FilesExporter.serializeLocation(holo.getRawLocation()));
        Map<String, Object> holoData = FilesExporter.serializeData(holo.getRawData());
        if (!holoData.isEmpty()) {
            structure.set("Holo.data", holoData);
        }
        ArrayList rows = new ArrayList();
        for (GHoloRow holoRow : holo.getRows()) {
            Map<String, Object> rowData;
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            rowMap.put("content", holoRow.getContent());
            Map<String, Object> offset = FilesExporter.serializeOffset(holoRow.getRawOffset());
            if (!offset.isEmpty()) {
                rowMap.put("offset", offset);
            }
            if (!(rowData = FilesExporter.serializeData(holoRow.getRawData())).isEmpty()) {
                rowMap.put("data", rowData);
            }
            rows.add(rowMap);
        }
        structure.set("Holo.rows", rows);
        return structure;
    }

    private static Map<String, Object> serializeLocation(SimpleLocation location) {
        HashMap<String, Object> locationMap = new HashMap<String, Object>();
        locationMap.put("world", location.getWorld().getName());
        locationMap.put("x", location.getX());
        locationMap.put("y", location.getY());
        locationMap.put("z", location.getZ());
        return locationMap;
    }

    private static Map<String, Object> serializeOffset(SimpleVector offset) {
        HashMap<String, Object> offsetMap = new HashMap<String, Object>();
        if (offset.getX() != 0.0) {
            offsetMap.put("x", offset.getX());
        }
        if (offset.getY() != 0.0) {
            offsetMap.put("y", offset.getY());
        }
        if (offset.getZ() != 0.0) {
            offsetMap.put("z", offset.getZ());
        }
        return offsetMap;
    }

    private static Map<String, Object> serializeData(GHoloData data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (data.getRange() != 120.0) {
            dataMap.put("range", data.getRange());
        }
        if (!Objects.equals(data.getBackgroundColor(), "#000000")) {
            dataMap.put("backgroundColor", data.getBackgroundColor());
        }
        if (data.getTextOpacity() != 0) {
            dataMap.put("textOpacity", data.getTextOpacity());
        }
        if (data.getTextShadow()) {
            dataMap.put("textShadow", data.getTextShadow());
        }
        if (!Objects.equals(data.getTextAlignment(), "center")) {
            dataMap.put("textAlignment", data.getTextAlignment());
        }
        if (!Objects.equals(data.getBillboard(), "center")) {
            dataMap.put("billboard", data.getBillboard());
        }
        if (data.getSeeThrough()) {
            dataMap.put("seeThrough", data.getSeeThrough());
        }
        if (data.getRawScale().getX() != GHoloData.DEFAULT_SCALE.getX() || data.getRawScale().getY() != GHoloData.DEFAULT_SCALE.getY() || data.getRawScale().getZ() != GHoloData.DEFAULT_SCALE.getZ()) {
            HashMap<String, Double> scaleMap = new HashMap<String, Double>();
            if (data.getRawScale().getX() != GHoloData.DEFAULT_SCALE.getX()) {
                scaleMap.put("x", data.getRawScale().getX());
            }
            if (data.getRawScale().getY() != GHoloData.DEFAULT_SCALE.getY()) {
                scaleMap.put("y", data.getRawScale().getY());
            }
            if (data.getRawScale().getZ() != GHoloData.DEFAULT_SCALE.getZ()) {
                scaleMap.put("z", data.getRawScale().getZ());
            }
            dataMap.put("scale", scaleMap);
        }
        if (!Objects.equals(data.getRawRotation().getYaw(), GHoloData.DEFAULT_ROTATION.getYaw()) || !Objects.equals(data.getRawRotation().getPitch(), GHoloData.DEFAULT_ROTATION.getPitch())) {
            HashMap<String, Float> rotationMap = new HashMap<String, Float>();
            if (!Objects.equals(data.getRawRotation().getYaw(), GHoloData.DEFAULT_ROTATION.getYaw())) {
                rotationMap.put("yaw", data.getRawRotation().getYaw());
            }
            if (!Objects.equals(data.getRawRotation().getPitch(), GHoloData.DEFAULT_ROTATION.getPitch())) {
                rotationMap.put("pitch", data.getRawRotation().getPitch());
            }
            dataMap.put("rotation", rotationMap);
        }
        if (data.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS) {
            dataMap.put("brightness", data.getBrightness());
        }
        if (!Objects.equals(data.getPermission(), GHoloData.DEFAULT_PERMISSION)) {
            dataMap.put("permission", data.getPermission());
        }
        if (data.getRawSize().getWidth() != GHoloData.DEFAULT_SIZE.getWidth() || data.getRawSize().getHeight() != GHoloData.DEFAULT_SIZE.getHeight()) {
            HashMap<String, Float> sizeMap = new HashMap<String, Float>();
            if (data.getRawSize().getWidth() != GHoloData.DEFAULT_SIZE.getWidth()) {
                sizeMap.put("width", Float.valueOf(data.getRawSize().getWidth()));
            }
            if (data.getRawSize().getHeight() != GHoloData.DEFAULT_SIZE.getHeight()) {
                sizeMap.put("height", Float.valueOf(data.getRawSize().getHeight()));
            }
            dataMap.put("size", sizeMap);
        }
        return dataMap;
    }
}

