/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.holo;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.simple.SimpleRotation;
import dev.geco.gholo.object.simple.SimpleSize;
import dev.geco.gholo.object.simple.SimpleVector;
import java.util.Objects;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GHoloData
implements Cloneable {
    public static final double DEFAULT_RANGE = 120.0;
    public static final String DEFAULT_BACKGROUND_COLOR = "#000000";
    public static final byte DEFAULT_TEXT_OPACITY = 0;
    public static final boolean DEFAULT_HAS_TEXT_SHADOW = false;
    public static final String DEFAULT_TEXT_ALIGNMENT = "center";
    public static final String DEFAULT_BILLBOARD = "center";
    public static final boolean DEFAULT_CAN_SEE_THROUGH = false;
    public static final SimpleVector DEFAULT_SCALE = new SimpleVector(1.0, 1.0, 1.0);
    public static final SimpleRotation DEFAULT_ROTATION = new SimpleRotation(null, null);
    public static final Byte DEFAULT_BRIGHTNESS = null;
    public static final String DEFAULT_PERMISSION = null;
    public static final SimpleSize DEFAULT_SIZE = new SimpleSize(1.0f, 1.0f);
    private double range = 120.0;
    private String backgroundColor = "#000000";
    private byte textOpacity = 0;
    private boolean hasTextShadow = false;
    private String textAlignment = "center";
    private String billboard = "center";
    private boolean canSeeThrough = false;
    private SimpleVector scale = new SimpleVector(1.0, 1.0, 1.0);
    private SimpleRotation rotation = new SimpleRotation(null, null);
    private Byte brightness = DEFAULT_BRIGHTNESS;
    private String permission = DEFAULT_PERMISSION;
    private SimpleSize size = new SimpleSize(1.0f, 1.0f);

    public double getRange() {
        return this.range;
    }

    @NotNull
    public GHoloData setRange(double range) {
        this.range = range;
        return this;
    }

    @Nullable
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public GHoloData setBackgroundColor(@Nullable String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public byte getTextOpacity() {
        return this.textOpacity;
    }

    @NotNull
    public GHoloData setTextOpacity(byte textOpacity) {
        this.textOpacity = textOpacity;
        return this;
    }

    public boolean getTextShadow() {
        return this.hasTextShadow;
    }

    @NotNull
    public GHoloData setTextShadow(boolean hasTextShadow) {
        this.hasTextShadow = hasTextShadow;
        return this;
    }

    @NotNull
    public String getTextAlignment() {
        return this.textAlignment;
    }

    @NotNull
    public GHoloData setTextAlignment(@NotNull String textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    @NotNull
    public String getBillboard() {
        return this.billboard;
    }

    @NotNull
    public GHoloData setBillboard(@NotNull String billboard) {
        this.billboard = billboard;
        return this;
    }

    public boolean getSeeThrough() {
        return this.canSeeThrough;
    }

    @NotNull
    public GHoloData setSeeThrough(boolean canSeeThrough) {
        this.canSeeThrough = canSeeThrough;
        return this;
    }

    @NotNull
    public SimpleVector getScale() {
        return this.scale;
    }

    @NotNull
    public SimpleVector getRawScale() {
        return this.scale.clone();
    }

    @NotNull
    public GHoloData setScale(@NotNull SimpleVector scale) {
        this.scale = scale;
        return this;
    }

    @NotNull
    public SimpleRotation getRotation() {
        return this.rotation.clone();
    }

    @NotNull
    public SimpleRotation getRawRotation() {
        return this.rotation;
    }

    @NotNull
    public GHoloData setRotation(@NotNull SimpleRotation rotation) {
        this.rotation = rotation.clone();
        return this;
    }

    @Nullable
    public Byte getBrightness() {
        return this.brightness;
    }

    @NotNull
    public GHoloData setBrightness(@Nullable Byte brightness) {
        this.brightness = brightness;
        return this;
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public GHoloData setPermission(@Nullable String permission) {
        this.permission = permission;
        return this;
    }

    @NotNull
    public SimpleSize getSize() {
        return this.size.clone();
    }

    @NotNull
    public SimpleSize getRawSize() {
        return this.size;
    }

    @NotNull
    public GHoloData setSize(@NotNull SimpleSize size) {
        this.size = size.clone();
        return this;
    }

    @NotNull
    public String toString() {
        JSONObject data = new JSONObject();
        if (this.range != 120.0) {
            data.put((Object)"range", (Object)this.range);
        }
        if (!Objects.equals(this.backgroundColor, DEFAULT_BACKGROUND_COLOR)) {
            data.put((Object)"background_color", (Object)this.backgroundColor);
        }
        if (this.textOpacity != 0) {
            data.put((Object)"text_opacity", (Object)this.textOpacity);
        }
        if (this.hasTextShadow) {
            data.put((Object)"text_shadow", (Object)this.hasTextShadow);
        }
        if (!Objects.equals(this.textAlignment, "center")) {
            data.put((Object)"text_alignment", (Object)this.textAlignment);
        }
        if (!Objects.equals(this.billboard, "center")) {
            data.put((Object)"billboard", (Object)this.billboard);
        }
        if (this.canSeeThrough) {
            data.put((Object)"see_through", (Object)this.canSeeThrough);
        }
        if (this.scale.getX() != DEFAULT_SCALE.getX() || this.scale.getY() != DEFAULT_SCALE.getY() || this.scale.getZ() != DEFAULT_SCALE.getZ()) {
            JSONObject scaleData = new JSONObject();
            if (this.scale.getX() != DEFAULT_SCALE.getX()) {
                scaleData.put((Object)"x", (Object)this.scale.getX());
            }
            if (this.scale.getY() != DEFAULT_SCALE.getY()) {
                scaleData.put((Object)"y", (Object)this.scale.getY());
            }
            if (this.scale.getZ() != DEFAULT_SCALE.getZ()) {
                scaleData.put((Object)"z", (Object)this.scale.getZ());
            }
            data.put((Object)"scale", (Object)scaleData);
        }
        if (!Objects.equals(this.rotation.getYaw(), DEFAULT_ROTATION.getYaw()) || !Objects.equals(this.rotation.getPitch(), DEFAULT_ROTATION.getPitch())) {
            JSONObject rotationData = new JSONObject();
            if (!Objects.equals(this.rotation.getYaw(), DEFAULT_ROTATION.getYaw())) {
                rotationData.put((Object)"yaw", (Object)this.rotation.getYaw());
            }
            if (!Objects.equals(this.rotation.getPitch(), DEFAULT_ROTATION.getPitch())) {
                rotationData.put((Object)"pitch", (Object)this.rotation.getPitch());
            }
            data.put((Object)"rotation", (Object)rotationData);
        }
        if (this.brightness != DEFAULT_BRIGHTNESS) {
            data.put((Object)"brightness", (Object)this.brightness);
        }
        if (!Objects.equals(this.permission, DEFAULT_PERMISSION)) {
            data.put((Object)"permission", (Object)this.permission);
        }
        if (this.size.getWidth() != DEFAULT_SIZE.getWidth() || this.size.getHeight() != DEFAULT_SIZE.getHeight()) {
            JSONObject sizeData = new JSONObject();
            if (this.size.getWidth() != DEFAULT_SIZE.getWidth()) {
                sizeData.put((Object)"width", (Object)Float.valueOf(this.size.getWidth()));
            }
            if (this.size.getHeight() != DEFAULT_SIZE.getHeight()) {
                sizeData.put((Object)"height", (Object)Float.valueOf(this.size.getHeight()));
            }
            data.put((Object)"size", (Object)sizeData);
        }
        return data.toJSONString();
    }

    @NotNull
    public GHoloData loadString(@NotNull String string) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject data = (JSONObject)parser.parse(string);
            if (data.get((Object)"range") != null) {
                this.range = ((Number)data.get((Object)"range")).doubleValue();
            }
            if (data.get((Object)"background_color") != null) {
                this.backgroundColor = (String)data.get((Object)"background_color");
            }
            if (data.get((Object)"text_opacity") != null) {
                this.textOpacity = ((Number)data.get((Object)"text_opacity")).byteValue();
            }
            if (data.get((Object)"text_shadow") != null) {
                this.hasTextShadow = (Boolean)data.get((Object)"text_shadow");
            }
            if (data.get((Object)"text_alignment") != null) {
                this.textAlignment = (String)data.get((Object)"text_alignment");
            }
            if (data.get((Object)"billboard") != null) {
                this.billboard = (String)data.get((Object)"billboard");
            }
            if (data.get((Object)"see_through") != null) {
                this.canSeeThrough = (Boolean)data.get((Object)"see_through");
            }
            if (data.get((Object)"scale") != null) {
                JSONObject scaleData = (JSONObject)data.get((Object)"scale");
                double x = scaleData.get((Object)"x") != null ? ((Number)scaleData.get((Object)"x")).doubleValue() : DEFAULT_SCALE.getX();
                double y = scaleData.get((Object)"y") != null ? ((Number)scaleData.get((Object)"y")).doubleValue() : DEFAULT_SCALE.getY();
                double z = scaleData.get((Object)"z") != null ? ((Number)scaleData.get((Object)"z")).doubleValue() : DEFAULT_SCALE.getZ();
                this.scale = new SimpleVector(x, y, z);
            }
            if (data.get((Object)"rotation") != null) {
                JSONObject rotationData = (JSONObject)data.get((Object)"rotation");
                Float yaw = rotationData.get((Object)"yaw") != null ? Float.valueOf(((Number)rotationData.get((Object)"yaw")).floatValue()) : DEFAULT_ROTATION.getYaw();
                Float pitch = rotationData.get((Object)"pitch") != null ? Float.valueOf(((Number)rotationData.get((Object)"pitch")).floatValue()) : DEFAULT_ROTATION.getPitch();
                this.rotation = new SimpleRotation(yaw, pitch);
            }
            if (data.get((Object)"brightness") != null) {
                this.brightness = ((Number)data.get((Object)"brightness")).byteValue();
            }
            if (data.get((Object)"permission") != null) {
                this.permission = (String)data.get((Object)"permission");
            }
            if (data.get((Object)"size") != null) {
                JSONObject sizeData = (JSONObject)data.get((Object)"size");
                float width = sizeData.get((Object)"width") != null ? ((Number)sizeData.get((Object)"width")).floatValue() : DEFAULT_SIZE.getWidth();
                float height = sizeData.get((Object)"height") != null ? ((Number)sizeData.get((Object)"height")).floatValue() : DEFAULT_SIZE.getWidth();
                this.size = new SimpleSize(width, height);
            }
        }
        catch (Throwable e) {
            GHoloMain.getInstance().getLogger().log(Level.SEVERE, "Could not load holo data!", e);
        }
        return this;
    }

    @NotNull
    public static GHoloData fromString(@NotNull String string) {
        return new GHoloData().loadString(string);
    }

    @NotNull
    public GHoloData clone() {
        try {
            return (GHoloData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

