/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.object.holo;

import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GHolo {
    private final UUID uuid;
    private String id;
    private SimpleLocation location;
    private final List<GHoloRow> rows = new ArrayList<GHoloRow>();
    private GHoloData data = new GHoloData();

    public GHolo(@NotNull UUID uuid, @NotNull String id, @NotNull SimpleLocation location) {
        this.uuid = uuid;
        this.id = id;
        this.location = location.clone();
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public GHolo setId(@NotNull String id) {
        this.id = id;
        return this;
    }

    @NotNull
    public SimpleLocation getLocation() {
        return this.location.clone();
    }

    @NotNull
    public SimpleLocation getRawLocation() {
        return this.location;
    }

    @NotNull
    public GHolo setLocation(@NotNull SimpleLocation location) {
        this.location = location.clone();
        return this;
    }

    @NotNull
    public List<GHoloRow> getRows() {
        return this.rows;
    }

    @Nullable
    public GHoloRow getRow(int position) {
        return position >= 0 && position < this.rows.size() ? this.rows.get(position) : null;
    }

    @NotNull
    public GHolo addRow(@NotNull GHoloRow holoRow) {
        this.rows.add(holoRow);
        return this;
    }

    @NotNull
    public GHolo insertRow(@NotNull GHoloRow holoRow, int position) {
        this.rows.add(position, holoRow);
        return this;
    }

    @NotNull
    public GHolo removeRow(int position) {
        if (position >= 0 && position < this.rows.size()) {
            this.rows.remove(position);
        }
        return this;
    }

    @NotNull
    public GHoloData getData() {
        return this.data.clone();
    }

    @NotNull
    public GHoloData getRawData() {
        return this.data;
    }

    @NotNull
    public GHolo setData(@NotNull GHoloData data) {
        this.data = data.clone();
        return this;
    }
}

