/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_21_9.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleSize;
import dev.geco.gholo.object.simple.SimpleVector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GHoloRowItemContent
extends Display.ItemDisplay
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final DataWatcherObject<ItemStack> holoItemData;
    private final DataWatcherObject<Vector3f> holoScaleData;

    /*
     * WARNING - void declaration
     */
    public GHoloRowItemContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.av, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        int n;
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        DataWatcherObject itemAccessor = null;
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Field[] fieldArray = Display.ItemDisplay.class.getDeclaredFields();
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                Field field = fieldArray[n];
                if (!field.getType().equals(DataWatcherObject.class)) continue;
                fieldList.add(field);
            }
            Field field = (Field)fieldList.getFirst();
            field.setAccessible(true);
            itemAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable e) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", e);
        }
        this.holoItemData = itemAccessor;
        DataWatcherObject scaleAccessor = null;
        try {
            void var8_18;
            ArrayList<Field> arrayList = new ArrayList<Field>();
            Field[] fieldArray = Display.class.getDeclaredFields();
            n = fieldArray.length;
            boolean bl = false;
            while (var8_18 < n) {
                Field field2 = fieldArray[var8_18];
                if (field2.getType().equals(DataWatcherObject.class)) {
                    arrayList.add(field2);
                }
                ++var8_18;
            }
            Field field = (Field)arrayList.get(4);
            field.setAccessible(true);
            scaleAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable throwable) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", throwable);
        }
        this.holoScaleData = scaleAccessor;
        for (GHoloUpdateType gHoloUpdateType : GHoloUpdateType.values()) {
            this.handleUpdate(gHoloUpdateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (create) {
            serverPlayer.g.b((Packet)new PacketPlayOutSpawnEntity(this.az(), this.aH, this.dK(), this.dM(), this.dQ(), this.dZ(), this.dX(), this.ax(), 0, this.dI(), (double)this.dX()));
        }
        serverPlayer.g.b((Packet)this.getDataPacket(content));
    }

    private PacketPlayOutEntityMetadata getDataPacket(String content) {
        Optional itemData;
        MinecraftKey resourceLocation;
        ArrayList<DataWatcher.c> data = this.aC().c();
        if (data == null) {
            data = new ArrayList<DataWatcher.c>();
        } else {
            data.removeIf(dataValue -> dataValue.a() == this.holoItemData.a());
        }
        List defaultResetData = this.aC().b();
        if (defaultResetData != null) {
            data.addAll(defaultResetData);
        }
        if (content != null && (resourceLocation = MinecraftKey.c((String)content.toLowerCase())) != null && (itemData = BuiltInRegistries.h.c(resourceLocation)).isPresent()) {
            data.add(new DataWatcher.c(this.holoItemData.a(), this.holoItemData.b(), (Object)((Item)((Holder.c)itemData.get()).a()).m()));
        }
        return new PacketPlayOutEntityMetadata(this.az(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.az(), PositionMoveRotation.a((Entity)this), Set.of(), false);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.g.b((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.a_(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.a(yaw, pitch);
                break;
            }
            case RANGE: {
                double range = rowData.getRange() != 120.0 ? rowData.getRange() : (holoData.getRange() != 120.0 ? holoData.getRange() : 120.0);
                this.b((float)(range / 64.0));
                break;
            }
            case BILLBOARD: {
                String billboard = !Objects.equals(rowData.getBillboard(), "center") ? rowData.getBillboard() : (!Objects.equals(holoData.getBillboard(), "center") ? holoData.getBillboard() : "center");
                this.setBillboard(billboard);
                break;
            }
            case SCALE: {
                SimpleVector scale = !Objects.equals(rowData.getRawScale(), GHoloData.DEFAULT_SCALE) ? rowData.getRawScale() : (!Objects.equals(holoData.getRawScale(), GHoloData.DEFAULT_SCALE) ? holoData.getRawScale() : GHoloData.DEFAULT_SCALE);
                this.az.a(this.holoScaleData, (Object)new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ()));
                break;
            }
            case BRIGHTNESS: {
                Byte brightness = rowData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? rowData.getBrightness() : (holoData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? holoData.getBrightness() : GHoloData.DEFAULT_BRIGHTNESS);
                this.a(brightness != null ? new Brightness((int)brightness.byteValue(), Brightness.c.c()) : null);
                break;
            }
            case SIZE: {
                SimpleSize size = !Objects.equals(rowData.getRawSize(), GHoloData.DEFAULT_SIZE) ? rowData.getRawSize() : (!Objects.equals(holoData.getRawSize(), GHoloData.DEFAULT_SIZE) ? holoData.getRawSize() : GHoloData.DEFAULT_SIZE);
                this.x(size.getWidth());
                this.y(size.getHeight());
            }
        }
    }

    private void setBillboard(String billboard) {
        this.a(Display.BillboardConstraints.valueOf((String)billboard.toUpperCase()));
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.g.b((Packet)this.getDataPacket(null));
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.g.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.az()}));
    }
}

